/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.AddTableRequest;
import io.deephaven.proto.backplane.grpc.DeleteTableRequest;
import java.util.List;

public interface InputTableServiceContextualAuthWiring {
    public void checkPermissionAddTableToInputTable(AuthContext var1, AddTableRequest var2, List<Table> var3);

    public void checkPermissionDeleteTableFromInputTable(AuthContext var1, DeleteTableRequest var2, List<Table> var3);

    public static class TestUseOnly
    implements InputTableServiceContextualAuthWiring {
        public InputTableServiceContextualAuthWiring delegate;

        @Override
        public void checkPermissionAddTableToInputTable(AuthContext authContext, AddTableRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionAddTableToInputTable(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionDeleteTableFromInputTable(AuthContext authContext, DeleteTableRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionDeleteTableFromInputTable(authContext, request, sourceTables);
            }
        }
    }

    public static class DenyAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
        }
    }

    public static abstract class DelegateAll
    implements InputTableServiceContextualAuthWiring {
        protected abstract void checkPermission(AuthContext var1, List<Table> var2);

        @Override
        public void checkPermissionAddTableToInputTable(AuthContext authContext, AddTableRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionDeleteTableFromInputTable(AuthContext authContext, DeleteTableRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }
    }
}

