/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.proto.backplane.grpc.FetchObjectRequest;
import io.deephaven.proto.backplane.grpc.ObjectServiceGrpc;
import io.deephaven.proto.backplane.grpc.StreamRequest;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;

public interface ObjectServiceAuthWiring
extends ServiceAuthWiring<ObjectServiceGrpc.ObjectServiceImplBase> {
    @Override
    default public ServerServiceDefinition intercept(ObjectServiceGrpc.ObjectServiceImplBase delegate) {
        ServerServiceDefinition service = delegate.bindService();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)service.getServiceDescriptor());
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "FetchObject", null, this::onMessageReceivedFetchObject));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "MessageStream", this::onCallStartedMessageStream, this::onMessageReceivedMessageStream));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "OpenMessageStream", null, this::onMessageReceivedOpenMessageStream));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "NextMessageStream", null, this::onMessageReceivedNextMessageStream));
        return serviceBuilder.build();
    }

    public void onMessageReceivedFetchObject(AuthContext var1, FetchObjectRequest var2);

    public void onCallStartedMessageStream(AuthContext var1);

    public void onMessageReceivedMessageStream(AuthContext var1, StreamRequest var2);

    public void onMessageReceivedOpenMessageStream(AuthContext var1, StreamRequest var2);

    public void onMessageReceivedNextMessageStream(AuthContext var1, StreamRequest var2);

    public static class TestUseOnly
    implements ObjectServiceAuthWiring {
        public ObjectServiceAuthWiring delegate;

        @Override
        public void onMessageReceivedFetchObject(AuthContext authContext, FetchObjectRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedFetchObject(authContext, request);
            }
        }

        @Override
        public void onCallStartedMessageStream(AuthContext authContext) {
            if (this.delegate != null) {
                this.delegate.onCallStartedMessageStream(authContext);
            }
        }

        @Override
        public void onMessageReceivedMessageStream(AuthContext authContext, StreamRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedMessageStream(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedOpenMessageStream(AuthContext authContext, StreamRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedOpenMessageStream(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedNextMessageStream(AuthContext authContext, StreamRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedNextMessageStream(authContext, request);
            }
        }
    }

    public static class DenyAll
    implements ObjectServiceAuthWiring {
        @Override
        public void onMessageReceivedFetchObject(AuthContext authContext, FetchObjectRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onCallStartedMessageStream(AuthContext authContext) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedMessageStream(AuthContext authContext, StreamRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedOpenMessageStream(AuthContext authContext, StreamRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedNextMessageStream(AuthContext authContext, StreamRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    implements ObjectServiceAuthWiring {
        @Override
        public void onMessageReceivedFetchObject(AuthContext authContext, FetchObjectRequest request) {
        }

        @Override
        public void onCallStartedMessageStream(AuthContext authContext) {
        }

        @Override
        public void onMessageReceivedMessageStream(AuthContext authContext, StreamRequest request) {
        }

        @Override
        public void onMessageReceivedOpenMessageStream(AuthContext authContext, StreamRequest request) {
        }

        @Override
        public void onMessageReceivedNextMessageStream(AuthContext authContext, StreamRequest request) {
        }
    }
}

