/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.GetTableRequest;
import io.deephaven.proto.backplane.grpc.MergeRequest;
import io.deephaven.proto.backplane.grpc.PartitionByRequest;
import java.util.List;

public interface PartitionedTableServiceContextualAuthWiring {
    public void checkPermissionPartitionBy(AuthContext var1, PartitionByRequest var2, List<Table> var3);

    public void checkPermissionMerge(AuthContext var1, MergeRequest var2, List<Table> var3);

    public void checkPermissionGetTable(AuthContext var1, GetTableRequest var2, List<Table> var3);

    public static class TestUseOnly
    implements PartitionedTableServiceContextualAuthWiring {
        public PartitionedTableServiceContextualAuthWiring delegate;

        @Override
        public void checkPermissionPartitionBy(AuthContext authContext, PartitionByRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionPartitionBy(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionMerge(AuthContext authContext, MergeRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionMerge(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionGetTable(AuthContext authContext, GetTableRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionGetTable(authContext, request, sourceTables);
            }
        }
    }

    public static class DenyAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
        }
    }

    public static abstract class DelegateAll
    implements PartitionedTableServiceContextualAuthWiring {
        protected abstract void checkPermission(AuthContext var1, List<Table> var2);

        @Override
        public void checkPermissionPartitionBy(AuthContext authContext, PartitionByRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionMerge(AuthContext authContext, MergeRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionGetTable(AuthContext authContext, GetTableRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }
    }
}

