/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.proto.backplane.grpc.ExportNotificationRequest;
import io.deephaven.proto.backplane.grpc.ExportRequest;
import io.deephaven.proto.backplane.grpc.HandshakeRequest;
import io.deephaven.proto.backplane.grpc.PublishRequest;
import io.deephaven.proto.backplane.grpc.ReleaseRequest;
import io.deephaven.proto.backplane.grpc.SessionServiceGrpc;
import io.deephaven.proto.backplane.grpc.TerminationNotificationRequest;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;

public interface SessionServiceAuthWiring
extends ServiceAuthWiring<SessionServiceGrpc.SessionServiceImplBase> {
    @Override
    default public ServerServiceDefinition intercept(SessionServiceGrpc.SessionServiceImplBase delegate) {
        ServerServiceDefinition service = delegate.bindService();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)service.getServiceDescriptor());
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "NewSession", null, this::onMessageReceivedNewSession));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "RefreshSessionToken", null, this::onMessageReceivedRefreshSessionToken));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "CloseSession", null, this::onMessageReceivedCloseSession));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "Release", null, this::onMessageReceivedRelease));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "ExportFromTicket", null, this::onMessageReceivedExportFromTicket));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "PublishFromTicket", null, this::onMessageReceivedPublishFromTicket));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "ExportNotifications", null, this::onMessageReceivedExportNotifications));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "TerminationNotification", null, this::onMessageReceivedTerminationNotification));
        return serviceBuilder.build();
    }

    public void onMessageReceivedNewSession(AuthContext var1, HandshakeRequest var2);

    public void onMessageReceivedRefreshSessionToken(AuthContext var1, HandshakeRequest var2);

    public void onMessageReceivedCloseSession(AuthContext var1, HandshakeRequest var2);

    public void onMessageReceivedRelease(AuthContext var1, ReleaseRequest var2);

    public void onMessageReceivedExportFromTicket(AuthContext var1, ExportRequest var2);

    public void onMessageReceivedPublishFromTicket(AuthContext var1, PublishRequest var2);

    public void onMessageReceivedExportNotifications(AuthContext var1, ExportNotificationRequest var2);

    public void onMessageReceivedTerminationNotification(AuthContext var1, TerminationNotificationRequest var2);

    public static class TestUseOnly
    implements SessionServiceAuthWiring {
        public SessionServiceAuthWiring delegate;

        @Override
        public void onMessageReceivedNewSession(AuthContext authContext, HandshakeRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedNewSession(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedRefreshSessionToken(AuthContext authContext, HandshakeRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedRefreshSessionToken(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedCloseSession(AuthContext authContext, HandshakeRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedCloseSession(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedRelease(AuthContext authContext, ReleaseRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedRelease(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedExportFromTicket(AuthContext authContext, ExportRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedExportFromTicket(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedPublishFromTicket(AuthContext authContext, PublishRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedPublishFromTicket(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedExportNotifications(AuthContext authContext, ExportNotificationRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedExportNotifications(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedTerminationNotification(AuthContext authContext, TerminationNotificationRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedTerminationNotification(authContext, request);
            }
        }
    }

    public static class DenyAll
    implements SessionServiceAuthWiring {
        @Override
        public void onMessageReceivedNewSession(AuthContext authContext, HandshakeRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedRefreshSessionToken(AuthContext authContext, HandshakeRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedCloseSession(AuthContext authContext, HandshakeRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedRelease(AuthContext authContext, ReleaseRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedExportFromTicket(AuthContext authContext, ExportRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedPublishFromTicket(AuthContext authContext, PublishRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedExportNotifications(AuthContext authContext, ExportNotificationRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedTerminationNotification(AuthContext authContext, TerminationNotificationRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    implements SessionServiceAuthWiring {
        @Override
        public void onMessageReceivedNewSession(AuthContext authContext, HandshakeRequest request) {
        }

        @Override
        public void onMessageReceivedRefreshSessionToken(AuthContext authContext, HandshakeRequest request) {
        }

        @Override
        public void onMessageReceivedCloseSession(AuthContext authContext, HandshakeRequest request) {
        }

        @Override
        public void onMessageReceivedRelease(AuthContext authContext, ReleaseRequest request) {
        }

        @Override
        public void onMessageReceivedExportFromTicket(AuthContext authContext, ExportRequest request) {
        }

        @Override
        public void onMessageReceivedPublishFromTicket(AuthContext authContext, PublishRequest request) {
        }

        @Override
        public void onMessageReceivedExportNotifications(AuthContext authContext, ExportNotificationRequest request) {
        }

        @Override
        public void onMessageReceivedTerminationNotification(AuthContext authContext, TerminationNotificationRequest request) {
        }
    }
}

