/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.proto.backplane.grpc.CreateDirectoryRequest;
import io.deephaven.proto.backplane.grpc.DeleteItemRequest;
import io.deephaven.proto.backplane.grpc.FetchFileRequest;
import io.deephaven.proto.backplane.grpc.ListItemsRequest;
import io.deephaven.proto.backplane.grpc.MoveItemRequest;
import io.deephaven.proto.backplane.grpc.SaveFileRequest;
import io.deephaven.proto.backplane.grpc.StorageServiceGrpc;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;

public interface StorageServiceAuthWiring
extends ServiceAuthWiring<StorageServiceGrpc.StorageServiceImplBase> {
    @Override
    default public ServerServiceDefinition intercept(StorageServiceGrpc.StorageServiceImplBase delegate) {
        ServerServiceDefinition service = delegate.bindService();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)service.getServiceDescriptor());
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "ListItems", null, this::onMessageReceivedListItems));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "FetchFile", null, this::onMessageReceivedFetchFile));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "SaveFile", null, this::onMessageReceivedSaveFile));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "MoveItem", null, this::onMessageReceivedMoveItem));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "CreateDirectory", null, this::onMessageReceivedCreateDirectory));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "DeleteItem", null, this::onMessageReceivedDeleteItem));
        return serviceBuilder.build();
    }

    public void onMessageReceivedListItems(AuthContext var1, ListItemsRequest var2);

    public void onMessageReceivedFetchFile(AuthContext var1, FetchFileRequest var2);

    public void onMessageReceivedSaveFile(AuthContext var1, SaveFileRequest var2);

    public void onMessageReceivedMoveItem(AuthContext var1, MoveItemRequest var2);

    public void onMessageReceivedCreateDirectory(AuthContext var1, CreateDirectoryRequest var2);

    public void onMessageReceivedDeleteItem(AuthContext var1, DeleteItemRequest var2);

    public static class TestUseOnly
    implements StorageServiceAuthWiring {
        public StorageServiceAuthWiring delegate;

        @Override
        public void onMessageReceivedListItems(AuthContext authContext, ListItemsRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedListItems(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedFetchFile(AuthContext authContext, FetchFileRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedFetchFile(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedSaveFile(AuthContext authContext, SaveFileRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedSaveFile(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedMoveItem(AuthContext authContext, MoveItemRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedMoveItem(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedCreateDirectory(AuthContext authContext, CreateDirectoryRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedCreateDirectory(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedDeleteItem(AuthContext authContext, DeleteItemRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedDeleteItem(authContext, request);
            }
        }
    }

    public static class DenyAll
    implements StorageServiceAuthWiring {
        @Override
        public void onMessageReceivedListItems(AuthContext authContext, ListItemsRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedFetchFile(AuthContext authContext, FetchFileRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedSaveFile(AuthContext authContext, SaveFileRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedMoveItem(AuthContext authContext, MoveItemRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedCreateDirectory(AuthContext authContext, CreateDirectoryRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedDeleteItem(AuthContext authContext, DeleteItemRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    implements StorageServiceAuthWiring {
        @Override
        public void onMessageReceivedListItems(AuthContext authContext, ListItemsRequest request) {
        }

        @Override
        public void onMessageReceivedFetchFile(AuthContext authContext, FetchFileRequest request) {
        }

        @Override
        public void onMessageReceivedSaveFile(AuthContext authContext, SaveFileRequest request) {
        }

        @Override
        public void onMessageReceivedMoveItem(AuthContext authContext, MoveItemRequest request) {
        }

        @Override
        public void onMessageReceivedCreateDirectory(AuthContext authContext, CreateDirectoryRequest request) {
        }

        @Override
        public void onMessageReceivedDeleteItem(AuthContext authContext, DeleteItemRequest request) {
        }
    }
}

