/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.testing;

import io.deephaven.base.testing.BaseCachedJMockTestCase;

public abstract class BaseArrayTestCase
extends BaseCachedJMockTestCase {
    public static void assertEquals(String name, double[][] a, double[][] b) {
        BaseArrayTestCase.assertEquals(name, a, b, 1.0E-10);
    }

    public static void assertEquals(String name, double[][] a, double[][] b, double tolerance) {
        if (a == null || b == null) {
            BaseArrayTestCase.assertTrue((a == b ? 1 : 0) != 0);
        } else {
            BaseArrayTestCase.assertTrue((b != null ? 1 : 0) != 0);
            BaseArrayTestCase.assertEquals((String)(name + ".length"), (int)a.length, (int)b.length);
            for (int i = 0; i < a.length; ++i) {
                BaseArrayTestCase.assertEquals(name + "[" + i + "]", a[i], b[i], tolerance);
            }
        }
    }

    public static void assertEquals(double[][] a, double[][] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(double[][] a, double[][] b, double tolerance) {
        BaseArrayTestCase.assertEquals("array", a, b, tolerance);
    }

    public static void assertEquals(String name, boolean[] a, boolean[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(boolean[] a, boolean[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, char[] a, char[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(char[] a, char[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, byte[] a, byte[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(byte[] a, byte[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, short[] a, short[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(short[] a, short[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, int[] a, int[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(int[] a, int[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, long[] a, long[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(long[] a, long[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String message, float[] a, float[] b) {
        BaseArrayTestCase.assertEquals(message, a, b, 1.0E-10f);
    }

    public static void assertEquals(float[] a, float[] b) {
        BaseArrayTestCase.assertEquals("array", a, b, 1.0E-10f);
    }

    public static void assertEquals(float[] a, float[] b, float tolerance) {
        BaseArrayTestCase.assertEquals("array", a, b, tolerance);
    }

    public static void assertEquals(String name, float[] a, float[] b, float tolerance) {
        String msg = BaseArrayTestCase.compareArray(name, a, b, tolerance);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertCloseInMagnitude(float[] a, float[] b, float percentage) {
        String msg = BaseArrayTestCase.checkMagnitudeArray("array", a, b, percentage);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(String message, double[] a, double[] b) {
        BaseArrayTestCase.assertEquals(message, a, b, 1.0E-10);
    }

    public static void assertEquals(double[] a, double[] b) {
        BaseArrayTestCase.assertEquals("array", a, b, 1.0E-10);
    }

    public static void assertEquals(double[] a, double[] b, double tolerance) {
        BaseArrayTestCase.assertEquals("array", a, b, tolerance);
    }

    public static void assertEquals(String name, double[] a, double[] b, double tolerance) {
        String msg = BaseArrayTestCase.compareArray(name, a, b, tolerance);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertCloseInMagnitude(double[] a, double[] b, double percentage) {
        String msg = BaseArrayTestCase.checkMagnitudeArray("array", a, b, percentage);
        if (msg != null) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static void assertEquals(Object[] a, Object[] b) {
        BaseArrayTestCase.assertEquals("array", a, b);
    }

    public static void assertEquals(String name, Object[] a, Object[] b) {
        String msg = BaseArrayTestCase.compareArray(name, a, b);
        if (null != msg) {
            BaseArrayTestCase.fail((String)msg);
        }
    }

    public static String compareArray(String name, char[] a, char[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, byte[] a, byte[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, short[] a, short[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, int[] a, int[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, long[] a, long[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, boolean[] a, boolean[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    public static String compareArray(String name, float[] a, float[] b, float tolerance) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i], tolerance)) == null; ++i) {
            }
        }
        return err;
    }

    public static String checkMagnitudeArray(String name, float[] a, float[] b, float percentage) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        String err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (b[i] < a[i] * (1.0f - percentage) || b[i] > a[i] * (1.0f + percentage)) {
                    err = "expected " + a[i] + " but was " + b[i];
                }
                if (err != null) break;
            }
        }
        return err;
    }

    public static String compareArray(String name, double[] a, double[] b, double tolerance) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i], tolerance)) == null; ++i) {
            }
        }
        return err;
    }

    public static String checkMagnitudeArray(String name, double[] a, double[] b, double percentage) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        String err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (b[i] < a[i] * (1.0 - percentage) || b[i] > a[i] * (1.0 + percentage)) {
                    err = "expected " + a[i] + " but was " + b[i];
                }
                if (err != null) break;
            }
        }
        return err;
    }

    static String compareArray(String name, Object[] a, Object[] b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return name + " expected: null but was: not null";
        }
        if (b == null) {
            return name + " expected: not null but was: null";
        }
        Object err = null;
        if (a.length != b.length) {
            err = name + " length expected:<" + a.length + "> but was:<" + b.length + ">";
        } else {
            for (int i = 0; i < a.length && (err = BaseArrayTestCase.compare(name + "[" + i + "]", a[i], b[i])) == null; ++i) {
            }
        }
        return err;
    }

    static String compare(String name, Object ai, Object bi) {
        String err = null;
        if (ai == null || bi == null) {
            if (ai != bi) {
                err = BaseArrayTestCase.xMessage(name, ai, bi);
            }
        } else if (!ai.equals(bi)) {
            err = BaseArrayTestCase.xMessage(name, ai, bi);
        }
        return err;
    }

    private static String compare(String name, long a, long b) {
        if (a != b) {
            return name + " expected: <" + a + "> but was: <" + b + ">";
        }
        return null;
    }

    private static String compare(String name, boolean a, boolean b) {
        if (a != b) {
            return name + " expected: <" + a + "> but was: <" + b + ">";
        }
        return null;
    }

    private static String compare(String name, double a, double b, double tolerance) {
        if (Math.abs(a - b) > tolerance || Double.isNaN(a) ^ Double.isNaN(b)) {
            return name + " expected: <" + a + "> but was: <" + b + ">";
        }
        return null;
    }

    private static String xMessage(String name, Object a, Object b) {
        return name + " expected: " + BaseArrayTestCase.xname(a) + " but was: " + BaseArrayTestCase.xname(b);
    }

    private static String xname(Object s) {
        if (s == null) {
            return "null";
        }
        return "<" + s + ">";
    }
}

