/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.testing;

import io.deephaven.base.Function;
import io.deephaven.base.verify.Assert;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.api.Action;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.api.ThreadingPolicy;
import org.jmock.auto.internal.Mockomatic;
import org.jmock.imposters.ByteBuddyClassImposteriser;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.CustomAction;
import org.jmock.lib.concurrent.Synchroniser;

public abstract class BaseCachedJMockTestCase
extends TestCase {
    protected final Mockery context = new Mockery();

    public BaseCachedJMockTestCase() {
        this.context.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
        this.context.setImposteriser((Imposteriser)CachingImposteriser.INSTANCE);
        new Mockomatic(this.context).fillIn((Object)this);
    }

    public <T> T mock(Class<T> tClass) {
        return (T)this.context.mock(tClass);
    }

    public <T> T mock(Class<T> tClass, String s) {
        return (T)this.context.mock(tClass, s);
    }

    public States states(String s) {
        return this.context.states(s);
    }

    public Sequence sequence(String s) {
        return this.context.sequence(s);
    }

    public void checking(ExpectationBuilder expectationBuilder) {
        this.context.checking(expectationBuilder);
    }

    public void assertIsSatisfied() {
        this.context.assertIsSatisfied();
    }

    protected void tearDown() throws Exception {
        this.context.assertIsSatisfied();
        super.tearDown();
    }

    private static class ProxyInfo {
        public Class[] proxiedClasses;
        public Class mockedType;
        public Class[] ancillaryTypes;

        public ProxyInfo(Class<?> mockedType, Class<?> ... ancillaryTypes) {
            this.mockedType = mockedType;
            this.ancillaryTypes = ancillaryTypes;
            this.proxiedClasses = new Class[ancillaryTypes.length + 1];
            this.proxiedClasses[0] = mockedType;
            System.arraycopy(ancillaryTypes, 0, this.proxiedClasses, 1, ancillaryTypes.length);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            ProxyInfo proxyInfo = (ProxyInfo)that;
            return Arrays.equals(this.proxiedClasses, proxyInfo.proxiedClasses);
        }

        public int hashCode() {
            return Arrays.hashCode(this.proxiedClasses);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Class proxiedClass : this.proxiedClasses) {
                stringBuilder.append(0 == stringBuilder.length() ? "[" : ", ").append(proxiedClass.getSimpleName());
            }
            return stringBuilder.append("]").toString();
        }
    }

    public static class CachingImposteriser
    implements Imposteriser {
        public static final CachingImposteriser INSTANCE = new CachingImposteriser();
        private static final Class[] CONSTRUCTOR_PARAMS = new Class[]{InvocationHandler.class};
        private static Map<ProxyInfo, Function.Unary<?, Invokable>> proxyInfoToConstructorMap = new HashMap();

        public boolean canImposterise(Class<?> type) {
            return ByteBuddyClassImposteriser.INSTANCE.canImposterise(type);
        }

        public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancillaryTypes) {
            ProxyInfo proxyInfo = new ProxyInfo(mockedType, ancillaryTypes);
            Function.Unary<?, Invokable> constructor = proxyInfoToConstructorMap.get(proxyInfo);
            if (null == constructor) {
                constructor = this.createConstructor(proxyInfo);
                proxyInfoToConstructorMap.put(proxyInfo, constructor);
            }
            return (T)constructor.call((Object)mockObject);
        }

        private Function.Unary<?, Invokable> createConstructor(ProxyInfo proxyInfo) {
            if (proxyInfo.mockedType.isInterface()) {
                return this.createInterfaceConstructor(proxyInfo);
            }
            return this.createClassConstructor(proxyInfo);
        }

        private Function.Unary<?, Invokable> createInterfaceConstructor(ProxyInfo proxyInfo) {
            Constructor<?> constructor;
            ClassLoader proxyClassLoader = BaseCachedJMockTestCase.class.getClassLoader();
            Class<?> proxyClass = Proxy.getProxyClass(proxyClassLoader, proxyInfo.proxiedClasses);
            try {
                constructor = proxyClass.getConstructor(CONSTRUCTOR_PARAMS);
            }
            catch (NoSuchMethodException e) {
                throw Assert.exceptionNeverCaught((Exception)e);
            }
            return new Function.Unary<Object, Invokable>(){

                public Object call(final Invokable invokable) {
                    try {
                        return constructor.newInstance(new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                return invokable.invoke(new Invocation(proxy, method, args));
                            }
                        });
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw Assert.exceptionNeverCaught((Exception)e);
                    }
                }
            };
        }

        private Function.Unary<?, Invokable> createClassConstructor(ProxyInfo proxyInfo) {
            return imposter -> ByteBuddyClassImposteriser.INSTANCE.imposterise(imposter, proxyInfo.mockedType, proxyInfo.ancillaryTypes);
        }
    }

    public static class Expectations
    extends org.jmock.Expectations {
        private static AtomicInteger willDoCounter = new AtomicInteger(0);

        public static <T> Matcher<T> some(Class<T> type) {
            return CoreMatchers.instanceOf(type);
        }

        public static <T> Matcher<T> any(Class<T> type) {
            return CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(type), CoreMatchers.nullValue(type)});
        }

        public void willDo(Function.Nullary<Object> proc) {
            this.currentBuilder().setAction((Action)Expectations.run(proc));
        }

        public static CustomAction run(final Function.Nullary<Object> proc) {
            return new CustomAction("willDo_" + willDoCounter.incrementAndGet()){

                public Object invoke(Invocation invocation) throws Throwable {
                    return proc.call();
                }
            };
        }

        public void willDo(Function.Unary<Object, Invocation> proc) {
            this.currentBuilder().setAction((Action)Expectations.run(proc));
        }

        public static CustomAction run(final Function.Unary<Object, Invocation> proc) {
            return new CustomAction("willDo_" + willDoCounter.incrementAndGet()){

                public Object invoke(Invocation invocation) throws Throwable {
                    return proc.call((Object)invocation);
                }
            };
        }
    }
}

