/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ResettableChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.table.Context;
import org.jetbrains.annotations.NotNull;

public class ContextWithChunk<ATTR extends Any, CONTEXT extends Context>
implements Context {
    private final CONTEXT context;
    private WritableChunk<ATTR> writableChunk;
    private final ResettableWritableChunk<ATTR> resettableWritableChunk;

    ContextWithChunk(CONTEXT context, ChunkType chunkType, int chunkCapacity) {
        this.context = context;
        this.writableChunk = chunkType.makeWritableChunk(chunkCapacity);
        this.writableChunk.setSize(chunkCapacity);
        this.resettableWritableChunk = chunkType.makeResettableWritableChunk();
    }

    public void close() {
        this.context.close();
        this.writableChunk.close();
        this.resettableWritableChunk.close();
    }

    public WritableChunk<ATTR> getWritableChunk() {
        return this.resettableWritableChunk.resetFromChunk(this.writableChunk, 0, this.writableChunk.size());
    }

    public ResettableChunk<ATTR> getResettableChunk() {
        return this.resettableWritableChunk;
    }

    public CONTEXT getContext() {
        return this.context;
    }

    public static <CONTEXT extends Context> CONTEXT getContext(@NotNull Context context) {
        return ((ContextWithChunk)context).context;
    }

    public void ensureLength(int length) {
        if (this.writableChunk.size() < length) {
            if (this.writableChunk.capacity() < length) {
                WritableChunk<ATTR> oldWritableChunk = this.writableChunk;
                this.writableChunk = this.writableChunk.getChunkType().makeWritableChunk(length);
                oldWritableChunk.close();
            }
            this.writableChunk.setSize(length);
        }
    }

    public static <ATTR extends Any, WRITABLE_CHUNK extends WritableChunk<ATTR>> WRITABLE_CHUNK getWritableChunk(@NotNull Context context) {
        WritableChunk<ATTR> writableChunk = ((ContextWithChunk)context).getWritableChunk();
        writableChunk.setSize(0);
        return (WRITABLE_CHUNK)writableChunk;
    }

    public static <ATTR extends Any, RESETTABLE_WRITABLE_CHUNK extends ResettableWritableChunk<ATTR>> RESETTABLE_WRITABLE_CHUNK getResettableChunk(@NotNull Context context) {
        return (RESETTABLE_WRITABLE_CHUNK)((ResettableWritableChunk)((ContextWithChunk)context).getResettableChunk());
    }

    public static <ATTR extends Any, CHUNK extends Chunk<ATTR>> CHUNK resetChunkFromArray(@NotNull Context context, Object array, int offset, int length) {
        ContextWithChunk getContext = (ContextWithChunk)context;
        if (array == null) {
            WritableChunk<ATTR> writableChunk = getContext.getWritableChunk();
            writableChunk.setSize(length);
            writableChunk.fillWithNullValue(0, length);
            return (CHUNK)writableChunk;
        }
        return (CHUNK)getContext.getResettableChunk().resetFromArray(array, offset, length);
    }

    public static <ATTR extends Any> boolean isMyWritableChunk(@NotNull Context context, Chunk<ATTR> chunk) {
        return chunk.isAlias(((ContextWithChunk)context).writableChunk);
    }

    public static <ATTR extends Any> boolean isMyResettableChunk(@NotNull Context context, Chunk<ATTR> chunk) {
        ContextWithChunk getContext = (ContextWithChunk)context;
        return !chunk.isAlias(getContext.writableChunk) && chunk.isAlias(getContext.resettableWritableChunk);
    }
}

