/**********************************************************************************
* DO NOT EDIT THIS FILE.
* This code was auto-generated from src/templates/Basic.ftl by CodeGenerator.
* Manual changes to this file will be lost.
***********************************************************************************/

/*
 * Copyright (c) 2016-2021 Deephaven Data Labs and Patent Pending
 */

package io.deephaven.function;

import io.deephaven.vector.*;
import io.deephaven.engine.primitive.iterator.*;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.QueryConstants;
import gnu.trove.list.array.*;
import gnu.trove.set.*;
import gnu.trove.set.hash.*;
import org.apache.commons.lang3.ArrayUtils;
import java.lang.reflect.Array;

import java.util.*;

import static io.deephaven.util.QueryConstants.*;

/**
 * Basic functions that can be applied to primitive types.
 */
public class Basic {

    //////////////////////////// Object ////////////////////////////

    /**
     * Returns the null value in the Deephaven convention that corresponds to type T.
     * @param clazz The type.
     * @return The corresponding null value in the Deephaven convention if T is one of the
     *   Deephaven types with a distinguished null value. Otherwise, null,
     */
    @SuppressWarnings("unchecked")
    static public <T> T nullValueFor(Class<T> clazz) {
        if (clazz == Byte.class) {
            return (T)NULL_BYTE_BOXED;
        }

        if (clazz == Character.class) {
            return (T)NULL_CHAR_BOXED;
        }

        if (clazz == Short.class) {
            return (T)NULL_SHORT_BOXED;
        }

        if (clazz == Integer.class) {
            return (T)NULL_INT_BOXED;
        }

        if (clazz == Float.class) {
            return (T)NULL_FLOAT_BOXED;
        }

        if (clazz == Long.class) {
            return (T)NULL_LONG_BOXED;
        }

        if (clazz == Double.class) {
            return (T)NULL_DOUBLE_BOXED;
        }

        return null;
    }

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public <T> boolean isNull(T value) {
        return value == null ||
                (value instanceof Byte && (Byte)value == NULL_BYTE) ||
                (value instanceof Character && (Character)value == NULL_CHAR) ||
                (value instanceof Short && (Short)value == NULL_SHORT) ||
                (value instanceof Integer && (Integer)value == NULL_INT) ||
                (value instanceof Float && (Float)value == NULL_FLOAT) ||
                (value instanceof Long && (Long)value == NULL_LONG) ||
                (value instanceof Double && (Double)value == NULL_DOUBLE);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public <T> T replaceIfNull(T value, T replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public <T> T[] replaceIfNull(T[] values, T replacement) {
        final T[] result = Arrays.copyOf(values, values.length);

        for (int i = 0; i < result.length; i++) {
            result[i] = replaceIfNull(result[i], replacement);
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public <T> T[] replaceIfNull(ObjectVector<T> values, T replacement) {
        final T[] result = values.copyToArray();

        for (int i = 0; i < result.length; i++) {
            result[i] = replaceIfNull(result[i], replacement);
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public <T> long len(T[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(LongSizedDataStructure values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.size();
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    @SafeVarargs
    static public <T> long countObj(T... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countObj(new ObjectVectorDirect<>(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public <T> long countObj(ObjectVector<T> values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseableIterator<T> vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final T c = vi.next();

                if (!isNull(c)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    @SafeVarargs
    static public <T> T lastObj(T... values) {
        if (values == null || values.length == 0) {
            return null;
        }

        return values[values.length - 1];
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public <T> T lastObj(ObjectVector<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }

        return values.get(values.size() - 1);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    @SafeVarargs
    static public <T> T firstObj(T... values) {
        if (values == null || values.length == 0) {
            return null;
        }

        return values[0];
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public <T> T firstObj(ObjectVector<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }

        return values.get(0);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    @SafeVarargs
    static public <T> T nthObj(long index, T... values) {
        if (values == null || index < 0 || index >= values.length) {
            return null;
        }

        return values[(int)index];
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public <T> T nthObj(long index, ObjectVector<T> values) {
        if (values == null || index < 0 || index >= values.size()) {
            return null;
        }

        return values.get(index);
    }

    /**
     * Converts a Deephaven vector to an array that may be freely mutated by the caller.
     *
     * @param values A Deephaven vector
     * @return The result array, which may be freely mutated by the caller
     */
    public static <T> T[] arrayObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts an array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    @SafeVarargs
    public static <T> ObjectVector<T> vecObj(T... values) {
        if (values == null) {
            return null;
        }

        return new ObjectVectorDirect<>(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public <T extends Comparable<? super T>> boolean inRange(T testedValue, T lowInclusiveValue, T highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue.compareTo(lowInclusiveValue) >= 0 && testedValue.compareTo(highInclusiveValue) <= 0;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValue tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    @SafeVarargs
    static public <T> boolean inObj(T testedValue, T... possibleValues) {
        return inObj(testedValue, new ObjectVectorDirect<>(possibleValues));
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValue tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public <T> boolean inObj(T testedValue, ObjectVector<T> possibleValues) {
        final boolean testedIsNull = isNull(testedValue);

        try (final CloseableIterator<T> vi = possibleValues.iterator()) {
            while ( vi.hasNext() ) {
                final T possibleValue = vi.next();
                final boolean possibleIsNull = isNull(possibleValue);

                if (testedIsNull == possibleIsNull && (testedIsNull || testedValue.equals(possibleValue))) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static <T extends Comparable<? super T>> long countDistinctObj(final ObjectVector<T> values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinctObj(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> long countDistinctObj(T... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinctObj(new ObjectVectorDirect<>(values), false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static <T extends Comparable<? super T>> long countDistinctObj(final T[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinctObj(new ObjectVectorDirect<>(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    @SuppressWarnings("SuspiciousMethodCalls")
    public static <T extends Comparable<? super T>> long countDistinctObj(final ObjectVector<T> values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && isNull(values.get(0)) ? 0 : 1;
        }

        final THashSet<T> keys = new THashSet<>();

        try (final CloseableIterator<T> vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final T v = vi.next();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(null);
            keys.remove(NULL_BOOLEAN);
            keys.remove(NULL_CHAR_BOXED);
            keys.remove(NULL_BYTE_BOXED);
            keys.remove(NULL_SHORT_BOXED);
            keys.remove(NULL_INT_BOXED);
            keys.remove(NULL_LONG_BOXED);
            keys.remove(NULL_FLOAT_BOXED);
            keys.remove(NULL_DOUBLE_BOXED);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T[] distinctObj(T... values) {
        if (values == null) {
            return null;
        }

        return distinctObj(new ObjectVectorDirect<>(values), false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static <T extends Comparable<? super T>> T[] distinctObj(final ObjectVector<T> values) {
        if (values == null) {
            return null;
        }

        return distinctObj(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static <T extends Comparable<? super T>> T[] distinctObj(final T[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        return distinctObj(new ObjectVectorDirect<>(values), includeNull);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    @SuppressWarnings({"unchecked"})
    public static <T extends Comparable<? super T>> T[] distinctObj(final ObjectVector<T> values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();
        final T[] empty = (T[])Array.newInstance(values.getComponentType(), 0);

        if (n == 0) {
            return empty;
        }

        if (n == 1) {
            return !includeNull && isNull(values.get(0)) ? empty : values.copyToArray();
        }

        final List<T> orderedList = new ArrayList<>();
        final THashSet<T> counts = new THashSet<>();

        try (final CloseableIterator<T> vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final T val = vi.next();
                if ((includeNull || !isNull(val)) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray(empty);
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than or equal to zero, an empty array is returned.
     */
    @SuppressWarnings({"unchecked"})
    public static <T> T[] repeat(T value, int size) {
        if ( size < 0 ) {
            throw new IllegalArgumentException("Negative size: size=" + size);
        }

        final T[] array = (T[])Array.newInstance(value.getClass(), size);

        for (int i = 0; i < size; i++) {
            array[i] = value;
        }

        return array;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    @SafeVarargs
    @SuppressWarnings({"unchecked"})
    public static <T> T[] concat(T[]... values) {

        int n = 0;

        for (T[] v : values) {
            if (v != null) {
                n += v.length;
            }
        }

        final T[] result = (T[])Array.newInstance(values.getClass().getComponentType().getComponentType(), n);
        int idx = 0;

        for (T[] v : values) {
            if (v != null) {
                for (T t : v) {
                    result[idx] = t;
                    idx++;
                }
            }
        }

        return result;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    @SafeVarargs
    @SuppressWarnings({"unchecked"})
    public static <T> T[] concat(ObjectVector<T>... values) {

        if (values.length == 0) {
            return (T[])Array.newInstance(Object.class, 0);
        }

        int n = 0;
        ObjectVector<T> nonNullValues = null;

        for (ObjectVector<T> v : values) {
            if (v != null) {
                n += v.size();
                nonNullValues = v;
            }
        }

        final T[] result = (T[])Array.newInstance(nonNullValues == null ? Object.class : nonNullValues.getComponentType(), n);
        int idx = 0;

        for (ObjectVector<T> v : values) {
            if (v != null) {
                try (final CloseableIterator<T> vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final T vv = vi.next();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    @SafeVarargs
    public static <T> T[] reverseObj(T... values) {
        if (values == null) {
            return null;
        }

        final T[] result = Arrays.copyOf(values, values.length);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static <T> T[] reverseObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }

        final T[] result = values.copyToArray();
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    @SafeVarargs
    public static <T> long firstIndexOfObj(T val, T... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOfObj(val, new ObjectVectorDirect<>(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static <T> long firstIndexOfObj(T val, ObjectVector<T> values) {
        if (values == null) {
            return NULL_LONG;
        }

        final boolean isNullVal = isNull(val);
        long i = 0;

        try (final CloseableIterator<T> vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final T c = vi.next();
                final boolean isnullc = isNull(c);

                if ((isnullc && isNullVal) || (!isnullc && c.equals(val)) ) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or null if condition is null.
     */
    public static <T> T ifelseObj(Boolean condition, T trueCase, T falseCase) {
        if (condition == null) {
            return null;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of T whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or null if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static <T> T[] ifelseObj(ObjectVector<Boolean> condition, ObjectVector<T> trueCase, ObjectVector<T> falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        if (!trueCase.getComponentType().equals(falseCase.getComponentType())) {
            throw new IllegalArgumentException("Input vectors have different element types. trueCase=" + trueCase.getComponentType() + " falseCase=" + falseCase.getComponentType());
        }

        @SuppressWarnings("unchecked") final T[] result = (T[])Array.newInstance(trueCase.getComponentType(), n_c);
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseableIterator<T> ti = trueCase.iterator();
            final CloseableIterator<T> fi = falseCase.iterator()
        ) {
            while ( ci.hasNext() ) {
                final Boolean c = ci.next();
                final T t = ti.next();
                final T f = fi.next();
                result[i] = c == null ? null : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of T whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or null if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static <T> T[] ifelseObj(Boolean[] condition, T[] trueCase, T[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelseObj(new ObjectVectorDirect<>(condition), new ObjectVectorDirect<>(trueCase), new ObjectVectorDirect<>(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of T whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or null if the condition element is null.
     *         Returns null if condition is null.
     */
    public static <T> T[] ifelseObj(ObjectVector<Boolean> condition, T trueCase, T falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final T typeToUse = trueCase != null ? trueCase : falseCase;

        if (typeToUse == null) {
            throw new IllegalArgumentException("trueCase and falseCase are null.  Can not resolve a return type.");
        }

        if (trueCase != null && falseCase != null && trueCase.getClass() != falseCase.getClass()) {
            throw new IllegalArgumentException("Inputs have different types. trueCase=" + trueCase.getClass() + " falseCase=" + falseCase.getClass());
        }

        @SuppressWarnings("unchecked") final T[] result = (T[])Array.newInstance(typeToUse.getClass(), n_c);
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? null : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of T whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or null if the condition element is null.
     *         Returns null if condition is null.
     */
    public static <T> T[] ifelseObj(Boolean[] condition, T trueCase, T falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelseObj(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the specified
     *         array is null, returns null.
     */
    @SafeVarargs
    public static <T> T[] forwardFillObj(final T... values) {
        if (values == null) {
            return null;
        }

        final T[] result = Arrays.copyOf(values, values.length);

        T lastGood = null;
        for (int ii = 0; ii < result.length; ii++) {
            if (!isNull(result[ii])) {
                lastGood = result[ii];
            }

            result[ii] = lastGood;
        }
        return result;
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the specified
     *         array is null, returns null.
     */
    public static <T> T[] forwardFillObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }

        final T[] result = values.copyToArray();

        T lastGood = null;
        for (int ii = 0; ii < result.length; ii++) {
            if (!isNull(result[ii])) {
                lastGood = result[ii];
            }

            result[ii] = lastGood;
        }
        return result;
    }

    
    //////////////////////////// char ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(char value) {
        return value == QueryConstants.NULL_CHAR;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static char[] unbox(Character... values) {
        if (values == null) {
            return null;
        }

        char[] result = new char[values.length];

        for (int i=0; i<values.length; i++) {
            Character v = values[i];

            if (v == null || isNull(v.charValue())) {
                result[i] = QueryConstants.NULL_CHAR;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public char replaceIfNull(char value, char replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public char[] replaceIfNull(char[] values, char replacement) {
        return replaceIfNull(new CharVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public char[] replaceIfNull(CharVector values, char replacement) {
        final int n = values.intSize("replaceIfNull");
        char[] result = new char[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char v = vi.nextChar();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(char[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(char... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new CharVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(CharVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char v = vi.nextChar();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public char last(CharVector values) {
        if (values == null) {
            return QueryConstants.NULL_CHAR;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_CHAR;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public char last(char... values) {
        if (values == null) {
            return QueryConstants.NULL_CHAR;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public char first(CharVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_CHAR;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public char first(char... values) {
        if (values == null) {
            return QueryConstants.NULL_CHAR;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public char nth(long index, CharVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_CHAR;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public char nth(long index, char... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static char[] array(CharVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static CharVector vec(char... values) {
        return new CharVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(char testedValue,char lowInclusiveValue,char highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(char testedValues,char... possibleValues) {
        for (char possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final char... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new CharVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final CharVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final char[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new CharVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final CharVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_CHAR ? 0 : 1;
        }

        final TCharSet keys = new TCharHashSet();

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char v = vi.nextChar();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_CHAR);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static char[] distinct(final char... values) {
        if (values == null) {
            return null;
        }

        return distinct(new CharVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static char[] distinct(final CharVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static char[] distinct(final char[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new char[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_CHAR ? new char[0] : new char[] { values[0] };
        }

        final TCharArrayList orderedList = new TCharArrayList();
        final TCharSet counts = new TCharHashSet();

        for (char val : values) {
            if ((includeNull || val != QueryConstants.NULL_CHAR) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static char[] distinct(final CharVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new char[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_CHAR ? new char[0] : values.copyToArray();
        }

        final TCharArrayList orderedList = new TCharArrayList();
        final TCharSet counts = new TCharHashSet();

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char val = vi.nextChar();
                if ((includeNull || val != QueryConstants.NULL_CHAR) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static char[] repeat(char value, int size) {
        if (size < 0) {
            return new char[0];
        }

        final char[] result = new char[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static char[] enlist(char... values) {
        if (values == null) {
            return new char[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static char[] concat(char[]... values) {
        if (values == null) {
            return new char[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new CharVectorDirect(e)).toArray(CharVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static char[] concat(CharVector... values) {
        if (values == null) {
            return new char[0];
        }

        int n = 0;

        for (CharVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final char[] result = new char[n];
        int idx = 0;

        for (CharVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfChar vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final char vv = vi.nextChar();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static char[] reverse(char... values) {
        if (values == null) {
            return null;
        }

        return reverse(new CharVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static char[] reverse(CharVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final char[] result = new char[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char v = vi.nextChar();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(char val, char... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new CharVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(char val, CharVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char c = vi.nextChar();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static char ifelse(Boolean condition, char trueCase, char falseCase) {
        if (condition == null) {
            return NULL_CHAR;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of char whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static char[] ifelse(ObjectVector<Boolean> condition, CharVector trueCase, CharVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final char[] result = new char[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfChar ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfChar fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final char t = ti.nextChar();
                final char f = fi.nextChar();
                result[i] = c == null ? NULL_CHAR : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of char whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static char[] ifelse(Boolean[] condition, char[] trueCase, char[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new CharVectorDirect(trueCase), new CharVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of char whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static char[] ifelse(ObjectVector<Boolean> condition, char trueCase, char falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final char[] result = new char[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_CHAR : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of char whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static char[] ifelse(Boolean[] condition, char trueCase, char falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static char[] forwardFill(char... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new CharVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static char[] forwardFill(CharVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final char[] result = new char[n];
        int ii = 0;
        char lastGood = QueryConstants.NULL_CHAR;

        try (final CloseablePrimitiveIteratorOfChar vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final char v = vi.nextChar();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// byte ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(byte value) {
        return value == QueryConstants.NULL_BYTE;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static byte[] unbox(Byte... values) {
        if (values == null) {
            return null;
        }

        byte[] result = new byte[values.length];

        for (int i=0; i<values.length; i++) {
            Byte v = values[i];

            if (v == null || isNull(v.byteValue())) {
                result[i] = QueryConstants.NULL_BYTE;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public byte replaceIfNull(byte value, byte replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public byte[] replaceIfNull(byte[] values, byte replacement) {
        return replaceIfNull(new ByteVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public byte[] replaceIfNull(ByteVector values, byte replacement) {
        final int n = values.intSize("replaceIfNull");
        byte[] result = new byte[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(byte[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new ByteVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public byte last(ByteVector values) {
        if (values == null) {
            return QueryConstants.NULL_BYTE;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_BYTE;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public byte last(byte... values) {
        if (values == null) {
            return QueryConstants.NULL_BYTE;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public byte first(ByteVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_BYTE;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public byte first(byte... values) {
        if (values == null) {
            return QueryConstants.NULL_BYTE;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public byte nth(long index, ByteVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_BYTE;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public byte nth(long index, byte... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static byte[] array(ByteVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static ByteVector vec(byte... values) {
        return new ByteVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(byte testedValue,byte lowInclusiveValue,byte highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(byte testedValues,byte... possibleValues) {
        for (byte possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final byte... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new ByteVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final ByteVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final byte[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new ByteVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final ByteVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_BYTE ? 0 : 1;
        }

        final TByteSet keys = new TByteHashSet();

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_BYTE);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static byte[] distinct(final byte... values) {
        if (values == null) {
            return null;
        }

        return distinct(new ByteVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static byte[] distinct(final ByteVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static byte[] distinct(final byte[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_BYTE ? new byte[0] : new byte[] { values[0] };
        }

        final TByteArrayList orderedList = new TByteArrayList();
        final TByteSet counts = new TByteHashSet();

        for (byte val : values) {
            if ((includeNull || val != QueryConstants.NULL_BYTE) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static byte[] distinct(final ByteVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new byte[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_BYTE ? new byte[0] : values.copyToArray();
        }

        final TByteArrayList orderedList = new TByteArrayList();
        final TByteSet counts = new TByteHashSet();

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte val = vi.nextByte();
                if ((includeNull || val != QueryConstants.NULL_BYTE) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static byte[] repeat(byte value, int size) {
        if (size < 0) {
            return new byte[0];
        }

        final byte[] result = new byte[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static byte[] enlist(byte... values) {
        if (values == null) {
            return new byte[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static byte[] concat(byte[]... values) {
        if (values == null) {
            return new byte[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new ByteVectorDirect(e)).toArray(ByteVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static byte[] concat(ByteVector... values) {
        if (values == null) {
            return new byte[0];
        }

        int n = 0;

        for (ByteVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final byte[] result = new byte[n];
        int idx = 0;

        for (ByteVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfByte vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final byte vv = vi.nextByte();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static byte[] reverse(byte... values) {
        if (values == null) {
            return null;
        }

        return reverse(new ByteVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static byte[] reverse(ByteVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final byte[] result = new byte[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(byte val, byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new ByteVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(byte val, ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static byte ifelse(Boolean condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return NULL_BYTE;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of byte whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static byte[] ifelse(ObjectVector<Boolean> condition, ByteVector trueCase, ByteVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final byte[] result = new byte[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfByte ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfByte fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final byte t = ti.nextByte();
                final byte f = fi.nextByte();
                result[i] = c == null ? NULL_BYTE : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of byte whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static byte[] ifelse(Boolean[] condition, byte[] trueCase, byte[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new ByteVectorDirect(trueCase), new ByteVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of byte whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static byte[] ifelse(ObjectVector<Boolean> condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final byte[] result = new byte[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_BYTE : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of byte whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static byte[] ifelse(Boolean[] condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static byte[] forwardFill(byte... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new ByteVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static byte[] forwardFill(ByteVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final byte[] result = new byte[n];
        int ii = 0;
        byte lastGood = QueryConstants.NULL_BYTE;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// short ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(short value) {
        return value == QueryConstants.NULL_SHORT;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static short[] unbox(Short... values) {
        if (values == null) {
            return null;
        }

        short[] result = new short[values.length];

        for (int i=0; i<values.length; i++) {
            Short v = values[i];

            if (v == null || isNull(v.shortValue())) {
                result[i] = QueryConstants.NULL_SHORT;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public short replaceIfNull(short value, short replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public short[] replaceIfNull(short[] values, short replacement) {
        return replaceIfNull(new ShortVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public short[] replaceIfNull(ShortVector values, short replacement) {
        final int n = values.intSize("replaceIfNull");
        short[] result = new short[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(short[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new ShortVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public short last(ShortVector values) {
        if (values == null) {
            return QueryConstants.NULL_SHORT;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_SHORT;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public short last(short... values) {
        if (values == null) {
            return QueryConstants.NULL_SHORT;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public short first(ShortVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_SHORT;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public short first(short... values) {
        if (values == null) {
            return QueryConstants.NULL_SHORT;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public short nth(long index, ShortVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_SHORT;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public short nth(long index, short... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static short[] array(ShortVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static ShortVector vec(short... values) {
        return new ShortVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(short testedValue,short lowInclusiveValue,short highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(short testedValues,short... possibleValues) {
        for (short possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final short... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new ShortVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final ShortVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final short[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new ShortVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final ShortVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_SHORT ? 0 : 1;
        }

        final TShortSet keys = new TShortHashSet();

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_SHORT);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static short[] distinct(final short... values) {
        if (values == null) {
            return null;
        }

        return distinct(new ShortVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static short[] distinct(final ShortVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static short[] distinct(final short[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_SHORT ? new short[0] : new short[] { values[0] };
        }

        final TShortArrayList orderedList = new TShortArrayList();
        final TShortSet counts = new TShortHashSet();

        for (short val : values) {
            if ((includeNull || val != QueryConstants.NULL_SHORT) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static short[] distinct(final ShortVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new short[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_SHORT ? new short[0] : values.copyToArray();
        }

        final TShortArrayList orderedList = new TShortArrayList();
        final TShortSet counts = new TShortHashSet();

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short val = vi.nextShort();
                if ((includeNull || val != QueryConstants.NULL_SHORT) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static short[] repeat(short value, int size) {
        if (size < 0) {
            return new short[0];
        }

        final short[] result = new short[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static short[] enlist(short... values) {
        if (values == null) {
            return new short[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static short[] concat(short[]... values) {
        if (values == null) {
            return new short[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new ShortVectorDirect(e)).toArray(ShortVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static short[] concat(ShortVector... values) {
        if (values == null) {
            return new short[0];
        }

        int n = 0;

        for (ShortVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final short[] result = new short[n];
        int idx = 0;

        for (ShortVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfShort vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final short vv = vi.nextShort();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static short[] reverse(short... values) {
        if (values == null) {
            return null;
        }

        return reverse(new ShortVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static short[] reverse(ShortVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final short[] result = new short[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(short val, short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new ShortVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(short val, ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static short ifelse(Boolean condition, short trueCase, short falseCase) {
        if (condition == null) {
            return NULL_SHORT;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of short whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static short[] ifelse(ObjectVector<Boolean> condition, ShortVector trueCase, ShortVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final short[] result = new short[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfShort ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfShort fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final short t = ti.nextShort();
                final short f = fi.nextShort();
                result[i] = c == null ? NULL_SHORT : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of short whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static short[] ifelse(Boolean[] condition, short[] trueCase, short[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new ShortVectorDirect(trueCase), new ShortVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of short whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static short[] ifelse(ObjectVector<Boolean> condition, short trueCase, short falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final short[] result = new short[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_SHORT : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of short whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static short[] ifelse(Boolean[] condition, short trueCase, short falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static short[] forwardFill(short... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new ShortVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static short[] forwardFill(ShortVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final short[] result = new short[n];
        int ii = 0;
        short lastGood = QueryConstants.NULL_SHORT;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// int ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(int value) {
        return value == QueryConstants.NULL_INT;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static int[] unbox(Integer... values) {
        if (values == null) {
            return null;
        }

        int[] result = new int[values.length];

        for (int i=0; i<values.length; i++) {
            Integer v = values[i];

            if (v == null || isNull(v.intValue())) {
                result[i] = QueryConstants.NULL_INT;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public int replaceIfNull(int value, int replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public int[] replaceIfNull(int[] values, int replacement) {
        return replaceIfNull(new IntVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public int[] replaceIfNull(IntVector values, int replacement) {
        final int n = values.intSize("replaceIfNull");
        int[] result = new int[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(int[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new IntVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public int last(IntVector values) {
        if (values == null) {
            return QueryConstants.NULL_INT;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_INT;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public int last(int... values) {
        if (values == null) {
            return QueryConstants.NULL_INT;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public int first(IntVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_INT;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public int first(int... values) {
        if (values == null) {
            return QueryConstants.NULL_INT;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public int nth(long index, IntVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_INT;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public int nth(long index, int... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static int[] array(IntVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static IntVector vec(int... values) {
        return new IntVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(int testedValue,int lowInclusiveValue,int highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(int testedValues,int... possibleValues) {
        for (int possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final int... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new IntVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final IntVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final int[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new IntVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final IntVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_INT ? 0 : 1;
        }

        final TIntSet keys = new TIntHashSet();

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_INT);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static int[] distinct(final int... values) {
        if (values == null) {
            return null;
        }

        return distinct(new IntVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static int[] distinct(final IntVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static int[] distinct(final int[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_INT ? new int[0] : new int[] { values[0] };
        }

        final TIntArrayList orderedList = new TIntArrayList();
        final TIntSet counts = new TIntHashSet();

        for (int val : values) {
            if ((includeNull || val != QueryConstants.NULL_INT) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static int[] distinct(final IntVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new int[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_INT ? new int[0] : values.copyToArray();
        }

        final TIntArrayList orderedList = new TIntArrayList();
        final TIntSet counts = new TIntHashSet();

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int val = vi.nextInt();
                if ((includeNull || val != QueryConstants.NULL_INT) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static int[] repeat(int value, int size) {
        if (size < 0) {
            return new int[0];
        }

        final int[] result = new int[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static int[] enlist(int... values) {
        if (values == null) {
            return new int[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static int[] concat(int[]... values) {
        if (values == null) {
            return new int[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new IntVectorDirect(e)).toArray(IntVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static int[] concat(IntVector... values) {
        if (values == null) {
            return new int[0];
        }

        int n = 0;

        for (IntVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final int[] result = new int[n];
        int idx = 0;

        for (IntVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfInt vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final int vv = vi.nextInt();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static int[] reverse(int... values) {
        if (values == null) {
            return null;
        }

        return reverse(new IntVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static int[] reverse(IntVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final int[] result = new int[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(int val, int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new IntVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(int val, IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static int ifelse(Boolean condition, int trueCase, int falseCase) {
        if (condition == null) {
            return NULL_INT;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of int whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static int[] ifelse(ObjectVector<Boolean> condition, IntVector trueCase, IntVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final int[] result = new int[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfInt ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfInt fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final int t = ti.nextInt();
                final int f = fi.nextInt();
                result[i] = c == null ? NULL_INT : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of int whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static int[] ifelse(Boolean[] condition, int[] trueCase, int[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new IntVectorDirect(trueCase), new IntVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of int whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static int[] ifelse(ObjectVector<Boolean> condition, int trueCase, int falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final int[] result = new int[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_INT : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of int whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static int[] ifelse(Boolean[] condition, int trueCase, int falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static int[] forwardFill(int... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new IntVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static int[] forwardFill(IntVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final int[] result = new int[n];
        int ii = 0;
        int lastGood = QueryConstants.NULL_INT;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// long ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(long value) {
        return value == QueryConstants.NULL_LONG;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static long[] unbox(Long... values) {
        if (values == null) {
            return null;
        }

        long[] result = new long[values.length];

        for (int i=0; i<values.length; i++) {
            Long v = values[i];

            if (v == null || isNull(v.longValue())) {
                result[i] = QueryConstants.NULL_LONG;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public long replaceIfNull(long value, long replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public long[] replaceIfNull(long[] values, long replacement) {
        return replaceIfNull(new LongVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public long[] replaceIfNull(LongVector values, long replacement) {
        final int n = values.intSize("replaceIfNull");
        long[] result = new long[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(long[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new LongVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public long last(LongVector values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_LONG;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public long last(long... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public long first(LongVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_LONG;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public long first(long... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public long nth(long index, LongVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_LONG;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public long nth(long index, long... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static long[] array(LongVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static LongVector vec(long... values) {
        return new LongVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(long testedValue,long lowInclusiveValue,long highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(long testedValues,long... possibleValues) {
        for (long possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final long... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new LongVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final LongVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final long[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new LongVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final LongVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_LONG ? 0 : 1;
        }

        final TLongSet keys = new TLongHashSet();

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_LONG);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static long[] distinct(final long... values) {
        if (values == null) {
            return null;
        }

        return distinct(new LongVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static long[] distinct(final LongVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static long[] distinct(final long[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_LONG ? new long[0] : new long[] { values[0] };
        }

        final TLongArrayList orderedList = new TLongArrayList();
        final TLongSet counts = new TLongHashSet();

        for (long val : values) {
            if ((includeNull || val != QueryConstants.NULL_LONG) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static long[] distinct(final LongVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new long[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_LONG ? new long[0] : values.copyToArray();
        }

        final TLongArrayList orderedList = new TLongArrayList();
        final TLongSet counts = new TLongHashSet();

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long val = vi.nextLong();
                if ((includeNull || val != QueryConstants.NULL_LONG) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static long[] repeat(long value, int size) {
        if (size < 0) {
            return new long[0];
        }

        final long[] result = new long[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static long[] enlist(long... values) {
        if (values == null) {
            return new long[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static long[] concat(long[]... values) {
        if (values == null) {
            return new long[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new LongVectorDirect(e)).toArray(LongVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static long[] concat(LongVector... values) {
        if (values == null) {
            return new long[0];
        }

        int n = 0;

        for (LongVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final long[] result = new long[n];
        int idx = 0;

        for (LongVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfLong vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final long vv = vi.nextLong();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static long[] reverse(long... values) {
        if (values == null) {
            return null;
        }

        return reverse(new LongVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static long[] reverse(LongVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final long[] result = new long[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(long val, long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new LongVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(long val, LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static long ifelse(Boolean condition, long trueCase, long falseCase) {
        if (condition == null) {
            return NULL_LONG;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of long whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static long[] ifelse(ObjectVector<Boolean> condition, LongVector trueCase, LongVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final long[] result = new long[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfLong ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfLong fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final long t = ti.nextLong();
                final long f = fi.nextLong();
                result[i] = c == null ? NULL_LONG : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of long whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static long[] ifelse(Boolean[] condition, long[] trueCase, long[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new LongVectorDirect(trueCase), new LongVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of long whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static long[] ifelse(ObjectVector<Boolean> condition, long trueCase, long falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final long[] result = new long[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_LONG : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of long whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static long[] ifelse(Boolean[] condition, long trueCase, long falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static long[] forwardFill(long... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new LongVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static long[] forwardFill(LongVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final long[] result = new long[n];
        int ii = 0;
        long lastGood = QueryConstants.NULL_LONG;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// float ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(float value) {
        return value == QueryConstants.NULL_FLOAT;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static float[] unbox(Float... values) {
        if (values == null) {
            return null;
        }

        float[] result = new float[values.length];

        for (int i=0; i<values.length; i++) {
            Float v = values[i];

            if (v == null || isNull(v.floatValue())) {
                result[i] = QueryConstants.NULL_FLOAT;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public float replaceIfNull(float value, float replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNull(float[] values, float replacement) {
        return replaceIfNull(new FloatVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNull(FloatVector values, float replacement) {
        final int n = values.intSize("replaceIfNull");
        float[] result = new float[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(float[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new FloatVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public float last(FloatVector values) {
        if (values == null) {
            return QueryConstants.NULL_FLOAT;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_FLOAT;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public float last(float... values) {
        if (values == null) {
            return QueryConstants.NULL_FLOAT;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public float first(FloatVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_FLOAT;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public float first(float... values) {
        if (values == null) {
            return QueryConstants.NULL_FLOAT;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public float nth(long index, FloatVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_FLOAT;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public float nth(long index, float... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static float[] array(FloatVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static FloatVector vec(float... values) {
        return new FloatVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(float testedValue,float lowInclusiveValue,float highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(float testedValues,float... possibleValues) {
        for (float possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final float... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new FloatVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final FloatVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final float[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new FloatVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final FloatVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_FLOAT ? 0 : 1;
        }

        final TFloatSet keys = new TFloatHashSet();

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_FLOAT);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static float[] distinct(final float... values) {
        if (values == null) {
            return null;
        }

        return distinct(new FloatVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static float[] distinct(final FloatVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static float[] distinct(final float[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_FLOAT ? new float[0] : new float[] { values[0] };
        }

        final TFloatArrayList orderedList = new TFloatArrayList();
        final TFloatSet counts = new TFloatHashSet();

        for (float val : values) {
            if ((includeNull || val != QueryConstants.NULL_FLOAT) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static float[] distinct(final FloatVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new float[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_FLOAT ? new float[0] : values.copyToArray();
        }

        final TFloatArrayList orderedList = new TFloatArrayList();
        final TFloatSet counts = new TFloatHashSet();

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float val = vi.nextFloat();
                if ((includeNull || val != QueryConstants.NULL_FLOAT) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static float[] repeat(float value, int size) {
        if (size < 0) {
            return new float[0];
        }

        final float[] result = new float[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static float[] enlist(float... values) {
        if (values == null) {
            return new float[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static float[] concat(float[]... values) {
        if (values == null) {
            return new float[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new FloatVectorDirect(e)).toArray(FloatVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static float[] concat(FloatVector... values) {
        if (values == null) {
            return new float[0];
        }

        int n = 0;

        for (FloatVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final float[] result = new float[n];
        int idx = 0;

        for (FloatVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfFloat vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final float vv = vi.nextFloat();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static float[] reverse(float... values) {
        if (values == null) {
            return null;
        }

        return reverse(new FloatVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static float[] reverse(FloatVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final float[] result = new float[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(float val, float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new FloatVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(float val, FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static float ifelse(Boolean condition, float trueCase, float falseCase) {
        if (condition == null) {
            return NULL_FLOAT;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of float whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static float[] ifelse(ObjectVector<Boolean> condition, FloatVector trueCase, FloatVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final float[] result = new float[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfFloat ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfFloat fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final float t = ti.nextFloat();
                final float f = fi.nextFloat();
                result[i] = c == null ? NULL_FLOAT : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of float whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static float[] ifelse(Boolean[] condition, float[] trueCase, float[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new FloatVectorDirect(trueCase), new FloatVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of float whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static float[] ifelse(ObjectVector<Boolean> condition, float trueCase, float falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final float[] result = new float[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_FLOAT : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of float whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static float[] ifelse(Boolean[] condition, float trueCase, float falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static float[] forwardFill(float... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new FloatVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static float[] forwardFill(FloatVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final float[] result = new float[n];
        int ii = 0;
        float lastGood = QueryConstants.NULL_FLOAT;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }


    //////////////////////////// double ////////////////////////////

    /**
     * Determines if a value is considered by the Deephaven convention to be null. In the Deephaven convention, every
     * simple type T has a special distinguished value NULL_T which is used to represent the null value for that type.
     * These values are enumerated in the {@link QueryConstants} class.
     *
     * @param value value.
     * @return true if the value is null according to the Deephaven convention, and false otherwise.
     */
    static public boolean isNull(double value) {
        return value == QueryConstants.NULL_DOUBLE;
    }

    /**
     * Unboxes an array of values.
     *
     * @param values values.
     * @return unboxed array of values.
     */
    public static double[] unbox(Double... values) {
        if (values == null) {
            return null;
        }

        double[] result = new double[values.length];

        for (int i=0; i<values.length; i++) {
            Double v = values[i];

            if (v == null || isNull(v.doubleValue())) {
                result[i] = QueryConstants.NULL_DOUBLE;
            } else {
                result[i] = v;
            }
        }

        return result;
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public double replaceIfNull(double value, double replacement) {
        if (isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNull(double[] values, double replacement) {
        return replaceIfNull(new DoubleVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is null according to Deephaven convention.
     * @return array containing value, if value is not null according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNull(DoubleVector values, double replacement) {
        final int n = values.intSize("replaceIfNull");
        double[] result = new double[n];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = replaceIfNull(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the length of the input.
     *
     * @param values values.
     * @return length of the input or the Deephaven null constant for null inputs.
     */
    static public long len(double[] values) {
        if (values == null) {
            return NULL_LONG;
        }

        return values.length;
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return count(new DoubleVectorDirect(values));
    }

    /**
     * Counts the number of non-null values.
     *
     * @param values values.
     * @return number of non-null values.
     */
    static public long count(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                if (!isNull(v)) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public double last(DoubleVector values) {
        if (values == null) {
            return QueryConstants.NULL_DOUBLE;
        }

        final long n = values.size();

        if (n == 0) {
            return QueryConstants.NULL_DOUBLE;
        }

        return values.get(n - 1);
    }

    /**
     * Returns the last value from an array.
     *
     * @param values values.
     * @return last value from the array.
     */
    static public double last(double... values) {
        if (values == null) {
            return QueryConstants.NULL_DOUBLE;
        }

        return last(vec(values));
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public double first(DoubleVector values) {
        if (values == null || values.isEmpty()) {
            return QueryConstants.NULL_DOUBLE;
        }

        return values.get(0);
    }

    /**
     * Returns the first value from an array.
     *
     * @param values values.
     * @return first value from the array.
     */
    static public double first(double... values) {
        if (values == null) {
            return QueryConstants.NULL_DOUBLE;
        }

        return first(vec(values));
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public double nth(long index, DoubleVector values) {
        if (index < 0 || index >= values.size()) {
            return QueryConstants.NULL_DOUBLE;
        }

        return values.get(index);
    }

    /**
     * Returns the nth value from an array.
     *
     * @param index index of the value to return.
     * @param values values.
     * @return nth value from the array or null, if the index is outside of the array's index range.
     */
    static public double nth(long index, double... values) {
        return nth(index, vec(values));
    }

    /**
     * Converts a Deephaven vector to a primitive array that may be freely mutated by the caller.
     *
     * @param values Deephaven vector
     * @return primitive array, which may be freely mutated by the caller
     */
    public static double[] array(DoubleVector values) {
        if (values == null) {
            return null;
        }

        return values.copyToArray();
    }

    /**
     * Converts a primitive array to a Deephaven vector.
     *
     * @param values primitive array
     * @return Deephaven vector.
     */
    public static DoubleVector vec(double... values) {
        return new DoubleVectorDirect(values);
    }

    /**
     * Checks if a value is within a range.
     *
     * @param testedValue tested value.
     * @param lowInclusiveValue lower inclusive bound of the range.
     * @param highInclusiveValue upper inclusive bound of the range.
     * @return true if the tested value is within the range, and false if the tested value is not in the range or is null.
     */
    static public boolean inRange(double testedValue,double lowInclusiveValue,double highInclusiveValue) {
        if (isNull(testedValue)) {
            return false;
        }

        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    /**
     * Checks if a value is within a discrete set of possible values.
     *
     * @param testedValues tested value.
     * @param possibleValues possible values.
     * @return true if the tested value is contained in the possible values, and false otherwise.
     */
    static public boolean in(double testedValues,double... possibleValues) {
        for (double possibleValue : possibleValues) {
            if (testedValues == possibleValue) {
                return true;
            }
        }

        return false;
    }


    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final double... values) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new DoubleVectorDirect(values));
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @return number of distinct non-null values.
     */
    public static long countDistinct(final DoubleVector values) {
        return countDistinct(values, false);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final double[] values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        return countDistinct(new DoubleVectorDirect(values), countNull);
    }

    /**
     * Counts the number of distinct elements in the array.
     *
     * @param values values.
     * @param countNull true to count null values, and false to exclude null values.
     * @return number of distinct values.
     */
    public static long countDistinct(final DoubleVector values, boolean countNull) {
        if (values == null) {
            return QueryConstants.NULL_LONG;
        }

        final long n = values.size();

        if (n == 0) {
            return 0;
        }

        if (n == 1) {
            return !countNull && values.get(0) == QueryConstants.NULL_DOUBLE ? 0 : 1;
        }

        final TDoubleSet keys = new TDoubleHashSet();

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                keys.add(v);
            }
        }

        if (!countNull) {
            keys.remove(QueryConstants.NULL_DOUBLE);
        }

        return keys.size();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static double[] distinct(final double... values) {
        if (values == null) {
            return null;
        }

        return distinct(new DoubleVectorDirect(values));
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @return unsorted array containing only distinct non-null items from arr.
     */
    public static double[] distinct(final DoubleVector values) {
        return distinct(values, false);
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static double[] distinct(final double[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[0];
        }

        if (values.length == 1) {
            return !includeNull && values[0] == QueryConstants.NULL_DOUBLE ? new double[0] : new double[] { values[0] };
        }

        final TDoubleArrayList orderedList = new TDoubleArrayList();
        final TDoubleSet counts = new TDoubleHashSet();

        for (double val : values) {
            if ((includeNull || val != QueryConstants.NULL_DOUBLE) && counts.add(val)) {
                orderedList.add(val);
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array containing only the distinct values from the input.
     *
     * @param values values.
     * @param includeNull true to include null values, and false to exclude null values.
     * @return array containing only distinct items from arr.
     */
    public static double[] distinct(final DoubleVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }

        final long n = values.size();

        if (n == 0) {
            return new double[0];
        }

        if (n == 1) {
            return !includeNull && values.get(0) == QueryConstants.NULL_DOUBLE ? new double[0] : values.copyToArray();
        }

        final TDoubleArrayList orderedList = new TDoubleArrayList();
        final TDoubleSet counts = new TDoubleHashSet();

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double val = vi.nextDouble();
                if ((includeNull || val != QueryConstants.NULL_DOUBLE) && counts.add(val)) {
                    orderedList.add(val);
                }
            }
        }

        return orderedList.toArray();
    }

    /**
     * Returns an array with a value repeated.
     *
     * @param value value.
     * @param size number of times to repeat the value.
     * @return array of repeated values.  If {@code size} is less than zero, an empty array is returned.
     */
    public static double[] repeat(double value, int size) {
        if (size < 0) {
            return new double[0];
        }

        final double[] result = new double[size];

        for (int i=0; i<size; i++) {
            result[i] = value;
        }

        return result;
    }

    /**
     * Returns a list containing its arguments.
     *
     * @param values values.
     * @return list containing values.
     */
    public static double[] enlist(double... values) {
        if (values == null) {
            return new double[0];
        }

        return values;
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static double[] concat(double[]... values) {
        if (values == null) {
            return new double[0];
        }

        return concat(Arrays.stream(values).map(e->e==null?null:new DoubleVectorDirect(e)).toArray(DoubleVector[]::new));
    }

    /**
     * Returns the concatenation of multiple arrays into a single array.
     *
     * @param values values.
     * @return concatenation of multiple arrays into a single array.
     */
    public static double[] concat(DoubleVector... values) {
        if (values == null) {
            return new double[0];
        }

        int n = 0;

        for (DoubleVector v : values) {
            if (v != null) {
                n += v.size();
            }
        }

        final double[] result = new double[n];
        int idx = 0;

        for (DoubleVector v : values) {
            if (v != null) {
                try (final CloseablePrimitiveIteratorOfDouble vi = v.iterator()) {
                    while ( vi.hasNext() ) {
                        final double vv = vi.nextDouble();
                        result[idx] = vv;
                        idx++;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static double[] reverse(double... values) {
        if (values == null) {
            return null;
        }

        return reverse(new DoubleVectorDirect(values));
    }

    /**
     * Returns an array with the values reversed.
     *
     * @param values values.
     * @return array with the values reversed.
     */
    public static double[] reverse(DoubleVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("reverse");
        final double[] result = new double[n];
        int i = n-1;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = v;
                i--;
            }
        }

        return result;
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(double val, double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return firstIndexOf(val, new DoubleVectorDirect(values));
    }

    /**
     * Returns the first index containing the value.
     *
     * @param values values.
     * @param val value to search for.
     * @return first index containing the value or null, if the value is not present.
     */
    public static long firstIndexOf(double val, DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long i = 0;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (c == val) {
                    return i;
                }

                i++;
            }
        }

        return NULL_LONG;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return trueCase value if condition is true, falseCase value if condition is false, or the Deephaven null constant if condition is null.
     */
    public static double ifelse(Boolean condition, double trueCase, double falseCase) {
        if (condition == null) {
            return NULL_DOUBLE;
        }

        return condition ? trueCase : falseCase;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of double whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static double[] ifelse(ObjectVector<Boolean> condition, DoubleVector trueCase, DoubleVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");
        final int n_t = trueCase.intSize("trueCase");
        final int n_f = falseCase.intSize("falseCase");

        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }

        final double[] result = new double[n_c];
        int i = 0;

        try (
            final CloseableIterator<Boolean> ci = condition.iterator();
            final CloseablePrimitiveIteratorOfDouble ti = trueCase.iterator();
            final CloseablePrimitiveIteratorOfDouble fi = falseCase.iterator()
        ) {
            while (ci.hasNext()) {
                final Boolean c = ci.next();
                final double t = ti.nextDouble();
                final double f = fi.nextDouble();
                result[i] = c == null ? NULL_DOUBLE : (c ? t : f);
                i++;
             }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of double whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be the trueCase element if the condition element is true;
     *         the falseCase element if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if any of the inputs is null.
     */
    public static double[] ifelse(Boolean[] condition, double[] trueCase, double[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), new DoubleVectorDirect(trueCase), new DoubleVectorDirect(falseCase));
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of double whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static double[] ifelse(ObjectVector<Boolean> condition, double trueCase, double falseCase) {
        if (condition == null) {
            return null;
        }

        final int n_c = condition.intSize("condition");

        final double[] result = new double[n_c];
        int i = 0;

        try (final CloseableIterator<Boolean> vi = condition.iterator()) {
            while ( vi.hasNext() ) {
                final Boolean c = vi.next();
                result[i] = c == null ? NULL_DOUBLE : (c ? trueCase : falseCase);
                i++;
            }
        }

        return result;
    }

    /**
     * Returns elements from either trueCase or falseCase, depending on condition.
     *
     * @param condition a boolean value used to select output values.
     * @param trueCase value returned when condition is true.
     * @param falseCase value returned when condition is false.
     * @return An array of double whose values are determined by the corresponding elements of condition, trueCase, and falseCase.
     *         The result element will be trueCase if the condition element is true;
     *         falseCase if the condition element is false; or the Deephaven null constant if the condition element is null.
     *         Returns null if condition is null.
     */
    public static double[] ifelse(Boolean[] condition, double trueCase, double falseCase) {
        if (condition == null) {
            return null;
        }

        return ifelse(new ObjectVectorDirect<>(condition), trueCase, falseCase);
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static double[] forwardFill(double... values) {
        if (values == null) {
            return null;
        }

        return forwardFill(new DoubleVectorDirect(values));
    }

    /**
     * Copies the specified array, replacing elements that represent null in the Deephaven convention by the most
     * recently encountered non-null value if one exists. Otherwise (if no such value exists), replaces those elements
     * with Deephaven null.
     *
     * @param values values.
     * @return A copy of the specified array, with Deephaven null elements replaced as described above. If the
     *         specified array is null, returns null.
     */
    public static double[] forwardFill(DoubleVector values) {
        if (values == null) {
            return null;
        }

        final int n = values.intSize("forwardFill");
        final double[] result = new double[n];
        int ii = 0;
        double lastGood = QueryConstants.NULL_DOUBLE;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                if (!isNull(v)) {
                    lastGood = v;
                }

                result[ii] = lastGood;
                ii++;
            }
        }

        return result;
    }

}
