/**********************************************************************************
* DO NOT EDIT THIS FILE.
* This code was auto-generated from src/templates/Numeric.ftl by CodeGenerator.
* Manual changes to this file will be lost.
***********************************************************************************/


package io.deephaven.function;

import io.deephaven.base.verify.Require;
import io.deephaven.vector.*;
import io.deephaven.engine.primitive.iterator.*;
import io.deephaven.util.datastructures.LongSizedDataStructure;

import java.util.Arrays;

import static io.deephaven.base.CompareUtils.compare;
import static io.deephaven.util.QueryConstants.*;
import static io.deephaven.function.Basic.*;
import static io.deephaven.function.Cast.castDouble;

/**
 * A set of commonly used numeric functions that can be applied to numeric types.
 */
@SuppressWarnings({"RedundantCast", "unused", "ManualMinMaxCalculation"})
public class Numeric {


    //////////////////////////// Object ////////////////////////////


    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    static public <T extends Comparable<T>> T maxObj(ObjectVector<T> values) {
        final long idx = indexOfMaxObj(values);
        return idx == NULL_LONG ? null : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    @SafeVarargs
    static public <T extends Comparable<T>> T maxObj(final T... values) {
        if (values == null || values.length == 0) {
            return null;
        }

        return maxObj(new ObjectVectorDirect<>(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    static public <T extends Comparable<T>> T minObj(ObjectVector<T> values) {
        final long idx = indexOfMinObj(values);
        return idx == NULL_LONG ? null : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    @SafeVarargs
    public static <T extends Comparable<T>> T minObj(final T... values) {
        if (values == null || values.length == 0) {
            return null;
        }

        return minObj(new ObjectVectorDirect<>(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    @SafeVarargs
    public static <T extends Comparable<T>> long indexOfMaxObj(T... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMaxObj(new ObjectVectorDirect<>(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static <T extends Comparable<T>> long indexOfMaxObj(ObjectVector<T> values) {
        if (values == null) {
            return NULL_LONG;
        }

        T val = null;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try (final CloseableIterator<T> vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final T c = vi.next();
                if (!isNull(c) && ( val == null || c.compareTo(val) > 0)) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    @SafeVarargs
    public static <T extends Comparable<T>> long indexOfMinObj(T... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMinObj(new ObjectVectorDirect<>(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static <T extends Comparable<T>> long indexOfMinObj(ObjectVector<T> values) {
        if (values == null) {
            return NULL_LONG;
        }

        T val = null;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseableIterator<T> vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final T c = vi.next();
                if (!isNull(c) && ( val == null || c.compareTo(val) < 0)) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }


    
    //////////////////////////// byte ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Byte[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new ByteVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Byte[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new ByteVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Byte[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new ByteVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Byte[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new ByteVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Byte[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new ByteVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Byte[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new ByteVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Byte[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new ByteVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Byte[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new ByteVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Byte[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new ByteVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static byte max(ByteVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_BYTE : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static byte max(byte... values) {
        if (values == null) {
            return NULL_BYTE;
        }

        return max(new ByteVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static byte max(Byte[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_BYTE : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static byte min(ByteVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_BYTE : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static byte min(byte... values) {
        if (values == null) {
            return NULL_BYTE;
        }

        return min(new ByteVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static byte min(Byte[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_BYTE : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Byte[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new ByteVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        byte val = MIN_BYTE;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Byte[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(byte... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new ByteVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(ByteVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        byte val = MAX_BYTE;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Byte[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(byte... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new ByteVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(ByteVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            byte[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, byte... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new ByteVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, ByteVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        byte[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(byte[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ByteVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(byte[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ByteVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ByteVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final byte v0 = v0i.nextByte();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static byte sum(ByteVector values) {
        if (values == null) {
            return NULL_BYTE;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (byte) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static byte sum(byte... values) {
        if (values == null) {
            return NULL_BYTE;
        }

        return sum(new ByteVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static byte product(ByteVector values) {
        if (values == null) {
            return NULL_BYTE;
        }

        byte prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final byte c = vi.nextByte();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_BYTE;
        }

        return (byte) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static byte product(byte... values) {
        if (values == null) {
            return NULL_BYTE;
        }

        return product(new ByteVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static byte[] cummin(Byte[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static byte[] cummin(byte... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[0];
        }

        byte[] result = new byte[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (byte)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static byte[] cummin(ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new byte[0];
        }

        final int n = values.intSize("cummin");
        byte[] result = new byte[n];

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            result[0] = vi.nextByte();
            int i = 1;

            while (vi.hasNext()) {
                final byte v = vi.nextByte();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (byte)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static byte[] cummax(Byte[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static byte[] cummax(byte... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[0];
        }

        byte[] result = new byte[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static byte[] cummax(ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new byte[0];
        }

        final int n = values.intSize("cummax");
        byte[] result = new byte[n];

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            result[0] = vi.nextByte();
            int i = 1;
    
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static byte[] cumsum(Byte[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static byte[] cumsum(byte... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[0];
        }

        byte[] result = new byte[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (byte) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static byte[] cumsum(ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new byte[0];
        }

        final int n = values.intSize("cumsum");
        byte[] result = new byte[n];

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            result[0] = vi.nextByte();
            int i = 1;
    
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (byte) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static byte[] cumprod(Byte[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static byte[] cumprod(byte... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[0];
        }

        byte[] result = new byte[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (byte) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static byte[] cumprod(ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new byte[0];
        }

        final int n = values.intSize("cumprod");
        byte[] result = new byte[n];

        try ( final CloseablePrimitiveIteratorOfByte vi = values.iterator() ) {
            result[0] = vi.nextByte();
            int i = 1;
    
            while (vi.hasNext()) {
                final byte v = vi.nextByte();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (byte) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static byte abs(byte value) {
        if (isNull(value)) {
            return NULL_BYTE;
        }

        return (byte) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(byte a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(byte value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(byte value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(byte value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
   public static byte lowerBin(byte value, byte interval) {
        if (value == NULL_BYTE || interval == NULL_BYTE) {
            return NULL_BYTE;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long d = ((long)value) / ((long)interval);
        final long m = ((long)value) % ((long)interval);
        final long r = (m != 0 && value < 0) ? d - 1 : d;
        return (byte) (interval * r);
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static byte lowerBin(byte value, byte interval, byte offset) {
        if (value == NULL_BYTE || interval == NULL_BYTE) {
            return NULL_BYTE;
        }

        return (byte)(lowerBin((byte)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static byte upperBin(byte value, byte interval) {
        if (value == NULL_BYTE || interval == NULL_BYTE) {
            return NULL_BYTE;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long r = ((long)value) / ((long)interval) + (value % interval > 0 ? 1 : 0);
        return (byte) (interval * r);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static byte upperBin(byte value, byte interval, byte offset) {
        if (value == NULL_BYTE || interval == NULL_BYTE) {
            return NULL_BYTE;
        }

        return (byte)(upperBin((byte)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static byte clamp(byte value, byte min, byte max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_BYTE;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ByteVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfByte vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final byte c = vi.nextByte();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static byte[] sequence(byte start, byte end, byte step) {
        if (step == 0) {
            return new byte[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new byte[0];
        }

        final byte[] result = new byte[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (byte)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Byte value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(byte value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Byte value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(byte value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Byte value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(byte value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(byte) finite}; {@code false} otherwise.
     * @see #isFinite(byte)
     */
    static public boolean containsNonFinite(Byte[] values) {
        for (Byte v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(byte) finite}; {@code false} otherwise.
     * @see #isFinite(byte)
     */
    static public boolean containsNonFinite(byte... values) {
        for (byte v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }




    //////////////////////////// short ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Short[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new ShortVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Short[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new ShortVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Short[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new ShortVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Short[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new ShortVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Short[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new ShortVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Short[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new ShortVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Short[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new ShortVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Short[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new ShortVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Short[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new ShortVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static short max(ShortVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_SHORT : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static short max(short... values) {
        if (values == null) {
            return NULL_SHORT;
        }

        return max(new ShortVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static short max(Short[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_SHORT : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static short min(ShortVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_SHORT : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static short min(short... values) {
        if (values == null) {
            return NULL_SHORT;
        }

        return min(new ShortVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static short min(Short[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_SHORT : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Short[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new ShortVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        short val = MIN_SHORT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Short[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(short... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new ShortVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(ShortVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        short val = MAX_SHORT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Short[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(short... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new ShortVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(ShortVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            short[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, short... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new ShortVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, ShortVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        short[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(short[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(ShortVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(short[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new ShortVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(ShortVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final short v0 = v0i.nextShort();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static short sum(ShortVector values) {
        if (values == null) {
            return NULL_SHORT;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (short) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static short sum(short... values) {
        if (values == null) {
            return NULL_SHORT;
        }

        return sum(new ShortVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static short product(ShortVector values) {
        if (values == null) {
            return NULL_SHORT;
        }

        short prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final short c = vi.nextShort();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_SHORT;
        }

        return (short) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static short product(short... values) {
        if (values == null) {
            return NULL_SHORT;
        }

        return product(new ShortVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static short[] cummin(Short[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static short[] cummin(short... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[0];
        }

        short[] result = new short[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (short)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static short[] cummin(ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new short[0];
        }

        final int n = values.intSize("cummin");
        short[] result = new short[n];

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            result[0] = vi.nextShort();
            int i = 1;

            while (vi.hasNext()) {
                final short v = vi.nextShort();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (short)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static short[] cummax(Short[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static short[] cummax(short... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[0];
        }

        short[] result = new short[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static short[] cummax(ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new short[0];
        }

        final int n = values.intSize("cummax");
        short[] result = new short[n];

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            result[0] = vi.nextShort();
            int i = 1;
    
            while (vi.hasNext()) {
                final short v = vi.nextShort();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static short[] cumsum(Short[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static short[] cumsum(short... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[0];
        }

        short[] result = new short[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (short) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static short[] cumsum(ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new short[0];
        }

        final int n = values.intSize("cumsum");
        short[] result = new short[n];

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            result[0] = vi.nextShort();
            int i = 1;
    
            while (vi.hasNext()) {
                final short v = vi.nextShort();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (short) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static short[] cumprod(Short[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static short[] cumprod(short... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[0];
        }

        short[] result = new short[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (short) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static short[] cumprod(ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new short[0];
        }

        final int n = values.intSize("cumprod");
        short[] result = new short[n];

        try ( final CloseablePrimitiveIteratorOfShort vi = values.iterator() ) {
            result[0] = vi.nextShort();
            int i = 1;
    
            while (vi.hasNext()) {
                final short v = vi.nextShort();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (short) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static short abs(short value) {
        if (isNull(value)) {
            return NULL_SHORT;
        }

        return (short) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(short a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(short value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(short value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(short value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
   public static short lowerBin(short value, short interval) {
        if (value == NULL_SHORT || interval == NULL_SHORT) {
            return NULL_SHORT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long d = ((long)value) / ((long)interval);
        final long m = ((long)value) % ((long)interval);
        final long r = (m != 0 && value < 0) ? d - 1 : d;
        return (short) (interval * r);
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static short lowerBin(short value, short interval, short offset) {
        if (value == NULL_SHORT || interval == NULL_SHORT) {
            return NULL_SHORT;
        }

        return (short)(lowerBin((short)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static short upperBin(short value, short interval) {
        if (value == NULL_SHORT || interval == NULL_SHORT) {
            return NULL_SHORT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long r = ((long)value) / ((long)interval) + (value % interval > 0 ? 1 : 0);
        return (short) (interval * r);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static short upperBin(short value, short interval, short offset) {
        if (value == NULL_SHORT || interval == NULL_SHORT) {
            return NULL_SHORT;
        }

        return (short)(upperBin((short)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static short clamp(short value, short min, short max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_SHORT;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new ShortVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfShort vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final short c = vi.nextShort();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static short[] sequence(short start, short end, short step) {
        if (step == 0) {
            return new short[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new short[0];
        }

        final short[] result = new short[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (short)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Short value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(short value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Short value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(short value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Short value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(short value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(short) finite}; {@code false} otherwise.
     * @see #isFinite(short)
     */
    static public boolean containsNonFinite(Short[] values) {
        for (Short v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(short) finite}; {@code false} otherwise.
     * @see #isFinite(short)
     */
    static public boolean containsNonFinite(short... values) {
        for (short v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }




    //////////////////////////// int ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Integer[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new IntVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Integer[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new IntVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Integer[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new IntVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Integer[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new IntVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Integer[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new IntVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Integer[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new IntVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Integer[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new IntVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Integer[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new IntVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Integer[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new IntVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static int max(IntVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_INT : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static int max(int... values) {
        if (values == null) {
            return NULL_INT;
        }

        return max(new IntVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static int max(Integer[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_INT : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static int min(IntVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_INT : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static int min(int... values) {
        if (values == null) {
            return NULL_INT;
        }

        return min(new IntVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static int min(Integer[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_INT : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Integer[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new IntVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        int val = MIN_INT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Integer[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(int... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new IntVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(IntVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        int val = MAX_INT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Integer[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(int... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new IntVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(IntVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            int[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, int... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new IntVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, IntVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        int[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(int[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(IntVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(int[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new IntVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(IntVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final int v0 = v0i.nextInt();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static int sum(IntVector values) {
        if (values == null) {
            return NULL_INT;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (int) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static int sum(int... values) {
        if (values == null) {
            return NULL_INT;
        }

        return sum(new IntVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static int product(IntVector values) {
        if (values == null) {
            return NULL_INT;
        }

        int prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final int c = vi.nextInt();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_INT;
        }

        return (int) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static int product(int... values) {
        if (values == null) {
            return NULL_INT;
        }

        return product(new IntVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static int[] cummin(Integer[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static int[] cummin(int... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        int[] result = new int[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (int)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static int[] cummin(IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        final int n = values.intSize("cummin");
        int[] result = new int[n];

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            result[0] = vi.nextInt();
            int i = 1;

            while (vi.hasNext()) {
                final int v = vi.nextInt();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (int)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static int[] cummax(Integer[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static int[] cummax(int... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        int[] result = new int[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static int[] cummax(IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        final int n = values.intSize("cummax");
        int[] result = new int[n];

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            result[0] = vi.nextInt();
            int i = 1;
    
            while (vi.hasNext()) {
                final int v = vi.nextInt();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static int[] cumsum(Integer[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static int[] cumsum(int... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        int[] result = new int[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (int) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static int[] cumsum(IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        final int n = values.intSize("cumsum");
        int[] result = new int[n];

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            result[0] = vi.nextInt();
            int i = 1;
    
            while (vi.hasNext()) {
                final int v = vi.nextInt();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (int) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static int[] cumprod(Integer[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static int[] cumprod(int... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        int[] result = new int[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (int) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static int[] cumprod(IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        final int n = values.intSize("cumprod");
        int[] result = new int[n];

        try ( final CloseablePrimitiveIteratorOfInt vi = values.iterator() ) {
            result[0] = vi.nextInt();
            int i = 1;
    
            while (vi.hasNext()) {
                final int v = vi.nextInt();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (int) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static int abs(int value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return (int) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(int a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(int value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(int value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(int value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
   public static int lowerBin(int value, int interval) {
        if (value == NULL_INT || interval == NULL_INT) {
            return NULL_INT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long d = ((long)value) / ((long)interval);
        final long m = ((long)value) % ((long)interval);
        final long r = (m != 0 && value < 0) ? d - 1 : d;
        return (int) (interval * r);
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static int lowerBin(int value, int interval, int offset) {
        if (value == NULL_INT || interval == NULL_INT) {
            return NULL_INT;
        }

        return (int)(lowerBin((int)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static int upperBin(int value, int interval) {
        if (value == NULL_INT || interval == NULL_INT) {
            return NULL_INT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long r = ((long)value) / ((long)interval) + (value % interval > 0 ? 1 : 0);
        return (int) (interval * r);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static int upperBin(int value, int interval, int offset) {
        if (value == NULL_INT || interval == NULL_INT) {
            return NULL_INT;
        }

        return (int)(upperBin((int)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static int clamp(int value, int min, int max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_INT;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new IntVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfInt vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final int c = vi.nextInt();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static int[] sequence(int start, int end, int step) {
        if (step == 0) {
            return new int[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new int[0];
        }

        final int[] result = new int[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (int)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Integer value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(int value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Integer value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(int value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Integer value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(int value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(int) finite}; {@code false} otherwise.
     * @see #isFinite(int)
     */
    static public boolean containsNonFinite(Integer[] values) {
        for (Integer v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(int) finite}; {@code false} otherwise.
     * @see #isFinite(int)
     */
    static public boolean containsNonFinite(int... values) {
        for (int v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }




    //////////////////////////// long ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Long[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new LongVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Long[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new LongVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Long[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new LongVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Long[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new LongVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Long[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new LongVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Long[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new LongVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Long[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new LongVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Long[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new LongVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Long[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new LongVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static long max(LongVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_LONG : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static long max(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return max(new LongVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static long max(Long[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_LONG : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static long min(LongVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_LONG : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static long min(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return min(new LongVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static long min(Long[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_LONG : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Long[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new LongVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long val = MIN_LONG;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Long[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new LongVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long val = MAX_LONG;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Long[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(long... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new LongVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(LongVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            long[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, long... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new LongVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, LongVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        long[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(long[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(LongVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(long[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new LongVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(LongVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final long v0 = v0i.nextLong();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static long sum(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (long) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static long sum(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return sum(new LongVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static long product(LongVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final long c = vi.nextLong();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_LONG;
        }

        return (long) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static long product(long... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return product(new LongVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static long[] cummin(Long[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static long[] cummin(long... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[0];
        }

        long[] result = new long[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (long)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static long[] cummin(LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new long[0];
        }

        final int n = values.intSize("cummin");
        long[] result = new long[n];

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            result[0] = vi.nextLong();
            int i = 1;

            while (vi.hasNext()) {
                final long v = vi.nextLong();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (long)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static long[] cummax(Long[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static long[] cummax(long... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[0];
        }

        long[] result = new long[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static long[] cummax(LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new long[0];
        }

        final int n = values.intSize("cummax");
        long[] result = new long[n];

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            result[0] = vi.nextLong();
            int i = 1;
    
            while (vi.hasNext()) {
                final long v = vi.nextLong();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static long[] cumsum(Long[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static long[] cumsum(long... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[0];
        }

        long[] result = new long[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (long) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static long[] cumsum(LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new long[0];
        }

        final int n = values.intSize("cumsum");
        long[] result = new long[n];

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            result[0] = vi.nextLong();
            int i = 1;
    
            while (vi.hasNext()) {
                final long v = vi.nextLong();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (long) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static long[] cumprod(Long[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static long[] cumprod(long... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[0];
        }

        long[] result = new long[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (long) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static long[] cumprod(LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new long[0];
        }

        final int n = values.intSize("cumprod");
        long[] result = new long[n];

        try ( final CloseablePrimitiveIteratorOfLong vi = values.iterator() ) {
            result[0] = vi.nextLong();
            int i = 1;
    
            while (vi.hasNext()) {
                final long v = vi.nextLong();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (long) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static long abs(long value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return (long) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(long a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(long value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(long value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(long value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
   public static long lowerBin(long value, long interval) {
        if (value == NULL_LONG || interval == NULL_LONG) {
            return NULL_LONG;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long d = ((long)value) / ((long)interval);
        final long m = ((long)value) % ((long)interval);
        final long r = (m != 0 && value < 0) ? d - 1 : d;
        return (long) (interval * r);
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static long lowerBin(long value, long interval, long offset) {
        if (value == NULL_LONG || interval == NULL_LONG) {
            return NULL_LONG;
        }

        return (long)(lowerBin((long)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static long upperBin(long value, long interval) {
        if (value == NULL_LONG || interval == NULL_LONG) {
            return NULL_LONG;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        final long r = ((long)value) / ((long)interval) + (value % interval > 0 ? 1 : 0);
        return (long) (interval * r);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static long upperBin(long value, long interval, long offset) {
        if (value == NULL_LONG || interval == NULL_LONG) {
            return NULL_LONG;
        }

        return (long)(upperBin((long)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static long clamp(long value, long min, long max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_LONG;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new LongVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfLong vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final long c = vi.nextLong();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static long[] sequence(long start, long end, long step) {
        if (step == 0) {
            return new long[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new long[0];
        }

        final long[] result = new long[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (long)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Long value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(long value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Long value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(long value) {
        return false;
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Long value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(long value) {
        return !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(long) finite}; {@code false} otherwise.
     * @see #isFinite(long)
     */
    static public boolean containsNonFinite(Long[] values) {
        for (Long v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(long) finite}; {@code false} otherwise.
     * @see #isFinite(long)
     */
    static public boolean containsNonFinite(long... values) {
        for (long v1 : values) {
            if (isNull(v1)) {
                return true;
            }
        }

        return false;
    }




    //////////////////////////// float ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Float[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new FloatVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Float[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new FloatVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Float[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new FloatVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Float[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new FloatVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Float[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new FloatVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Float[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new FloatVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Float[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new FloatVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Float[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new FloatVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Float[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new FloatVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static float max(FloatVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_FLOAT : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static float max(float... values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        return max(new FloatVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static float max(Float[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_FLOAT : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static float min(FloatVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_FLOAT : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static float min(float... values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        return min(new FloatVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static float min(Float[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_FLOAT : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Float[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new FloatVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        float val = MIN_FLOAT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Float[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(float... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new FloatVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(FloatVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        float val = MAX_FLOAT;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Float[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(float... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new FloatVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(FloatVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            float[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, float... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new FloatVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, FloatVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        float[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(float[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(FloatVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(float[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new FloatVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(FloatVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final float v0 = v0i.nextFloat();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static float sum(FloatVector values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (float) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static float sum(float... values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        return sum(new FloatVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static float product(FloatVector values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        float prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float c = vi.nextFloat();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_FLOAT;
        }

        return (float) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static float product(float... values) {
        if (values == null) {
            return NULL_FLOAT;
        }

        return product(new FloatVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static float[] cummin(Float[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static float[] cummin(float... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[0];
        }

        float[] result = new float[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (float)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static float[] cummin(FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new float[0];
        }

        final int n = values.intSize("cummin");
        float[] result = new float[n];

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            result[0] = vi.nextFloat();
            int i = 1;

            while (vi.hasNext()) {
                final float v = vi.nextFloat();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (float)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static float[] cummax(Float[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static float[] cummax(float... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[0];
        }

        float[] result = new float[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static float[] cummax(FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new float[0];
        }

        final int n = values.intSize("cummax");
        float[] result = new float[n];

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            result[0] = vi.nextFloat();
            int i = 1;
    
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static float[] cumsum(Float[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static float[] cumsum(float... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[0];
        }

        float[] result = new float[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (float) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static float[] cumsum(FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new float[0];
        }

        final int n = values.intSize("cumsum");
        float[] result = new float[n];

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            result[0] = vi.nextFloat();
            int i = 1;
    
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (float) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static float[] cumprod(Float[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static float[] cumprod(float... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[0];
        }

        float[] result = new float[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (float) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static float[] cumprod(FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new float[0];
        }

        final int n = values.intSize("cumprod");
        float[] result = new float[n];

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            result[0] = vi.nextFloat();
            int i = 1;
    
            while (vi.hasNext()) {
                final float v = vi.nextFloat();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (float) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static float abs(float value) {
        if (isNull(value)) {
            return NULL_FLOAT;
        }

        return (float) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(float a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(float value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(float value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(float value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
    public static float lowerBin(float value, float interval) {
        if (value == NULL_FLOAT || interval == NULL_FLOAT) {
            return NULL_FLOAT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        return (float) (interval * Math.floor(value / interval));
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static float lowerBin(float value, float interval, float offset) {
        if (value == NULL_FLOAT || interval == NULL_FLOAT) {
            return NULL_FLOAT;
        }

        return (float)(lowerBin((float)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static float upperBin(float value, float interval) {
        if (value == NULL_FLOAT || interval == NULL_FLOAT) {
            return NULL_FLOAT;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        return (float) (interval * Math.ceil(value / interval));
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static float upperBin(float value, float interval, float offset) {
        if (value == NULL_FLOAT || interval == NULL_FLOAT) {
            return NULL_FLOAT;
        }

        return (float)(upperBin((float)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static float clamp(float value, float min, float max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_FLOAT;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new FloatVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfFloat vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final float c = vi.nextFloat();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static float[] sequence(float start, float end, float step) {
        if (step == 0) {
            return new float[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new float[0];
        }

        final float[] result = new float[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (float)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Float value) {
        return value != null && Float.isNaN(value);
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(float value) {
        return Float.isNaN(value);
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Float value) {
        return value != null && Float.isInfinite(value);
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(float value) {
        return Float.isInfinite(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Float value) {
        return isFinite(castDouble(value));
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(float value) {
        return Float.isFinite(value) && !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(float) finite}; {@code false} otherwise.
     * @see #isFinite(float)
     */
    static public boolean containsNonFinite(Float[] values) {
        return containsNonFinite(unbox(values));
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(float) finite}; {@code false} otherwise.
     * @see #isFinite(float)
     */
    static public boolean containsNonFinite(float... values) {
        for (float v1 : values) {
            if (!isFinite(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is NaN.
     * @return value, if value is not NaN, replacement otherwise.
     */
    static public float replaceIfNaN(float value, float replacement) {
        if (isNaN(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN.
     * @return array containing value, if value is not NaN, replacement otherwise.
     */
    static public float[] replaceIfNaN(float[] values, float replacement) {
        return replaceIfNaN(new FloatVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN.
     * @return array containing value, if value is not NaN, replacement otherwise.
     */
    static public float[] replaceIfNaN(FloatVector values, float replacement) {
        final int n = values.intSize("replaceIfNaN");
        float[] result = new float[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = replaceIfNaN(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public float replaceIfNullNaN(float value, float replacement) {
        if (isNaN(value) || isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return array containing value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNullNaN(float[] values, float replacement) {
        return replaceIfNullNaN(new FloatVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return array containing value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNullNaN(FloatVector values, float replacement) {
        final int n = values.intSize("replaceIfNullNaN");
        float[] result = new float[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = replaceIfNullNaN(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public float replaceIfNonFinite(float value, float replacement) {
        return isFinite(value) ? value : replacement;
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return array containing value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNonFinite(float[] values, float replacement) {
        return replaceIfNonFinite(new FloatVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return array containing value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public float[] replaceIfNonFinite(FloatVector values, float replacement) {
        final int n = values.intSize("replaceIfNonFinite");
        float[] result = new float[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfFloat vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = replaceIfNonFinite(v, replacement);
                i++;
            }
        }

        return result;
    }



    //////////////////////////// double ////////////////////////////


    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(Double[] values) {
        return countPos(unbox(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countPos(new DoubleVectorDirect(values));
    }

    /**
     * Counts the number of positive values.
     *
     * @param values values.
     * @return number of positive values.
     */
    public static long countPos(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c) && c > 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(Double[] values) {
        return countNeg(unbox(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countNeg(new DoubleVectorDirect(values));
    }

    /**
     * Counts the number of negative values.
     *
     * @param values values.
     * @return number of negative values.
     */
    public static long countNeg(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;
        final long n = values.size();

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c) && c < 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(Double[] values) {
        return countZero(unbox(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return countZero(new DoubleVectorDirect(values));
    }

    /**
     * Counts the number of zero values.
     *
     * @param values values.
     * @return number of zero values.
     */
    public static long countZero(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        long count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c) && c == 0) {
                    count++;
                }
            }
        }

        return count;
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(Double[] values) {
        return avg(unbox(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return avg(new DoubleVectorDirect(values));
    }

    /**
     * Returns the mean.  Null values are excluded.
     *
     * @param values values.
     * @return mean of non-null values.
     */
    public static double avg(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c)) {
                    sum += c;
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(Double[] values) {
        return absAvg(unbox(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return absAvg(new DoubleVectorDirect(values));
    }

    /**
     * Returns the mean of the absolute values of values.  Null values are excluded.
     *
     * @param values values.
     * @return mean of the absolute value of non-null values.
     */
    public static double absAvg(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c)) {
                    sum += Math.abs(c);
                    count++;
                }
            }
        }

        return sum / count;
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(Double[] values) {
        return var(unbox(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return var(new DoubleVectorDirect(values));
    }

    /**
     * Returns the variance.  Null values are excluded.
     *
     * @param values values.
     * @return variance of non-null values.
     */
    public static double var(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c)) {
                    sum += (double)c;
                    sum2 += (double)c * (double)c;
                    count++;
                }
            }
        }

        return sum2 / (count - 1) - sum * sum / count / (count - 1);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final byte w = wi.nextByte();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final short w = wi.nextShort();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final int w = wi.nextInt();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final long w = wi.nextLong();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final float w = wi.nextFloat();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }


    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wvar(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted variance.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted variance of non-null values.
     */
    public static double wvar(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double sum = 0;
        double sum2 = 0;
        double count = 0;
        double count2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final double w = wi.nextDouble();

                if (!isNull(c) && !isNull(w)) {
                    sum += w * c;
                    sum2 += w * c * c;
                    count += w;
                    count2 += w * w;
                }
            }
        }

        // For unbiased estimator derivation see https://en.wikipedia.org/wiki/Weighted_arithmetic_mean#Weighted_sample_variance
        // For unweighted statistics, there is a (N-1)/N = (1-1/N) Bessel correction.  
        // The analagous correction for weighted statistics is 1-count2/count/count, which yields an effective sample size of Neff = count*count/count2.
        // This yields an unbiased estimator of (sum2/count - sum*sum/count/count) * ((count*count/count2)/((count*count/count2)-1)).
        // This can be simplified to (count * sum2 - sum * sum) / (count * count - count2)
        return (count * sum2 - sum * sum) / (count * count - count2);
    }



    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(Double[] values) {
        return std(unbox(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return std(new DoubleVectorDirect(values));
    }

    /**
     * Returns the standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @return standard deviation of non-null values.
     */
    public static double std(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double v = var(values);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }


    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wstd(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard deviation.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard deviation of non-null values.
     */
    public static double wstd(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double v = wvar(values, weights);
        return v == NULL_DOUBLE ? NULL_DOUBLE : Math.sqrt(v);
    }



    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(Double[] values) {
        return ste(unbox(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return ste(new DoubleVectorDirect(values));
    }

    /**
     * Returns the standard error.  Null values are excluded.
     *
     * @param values values.
     * @return standard error of non-null values.
     */
    public static double ste(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double s = std(values);
        final long c = count(values);
        return s == NULL_DOUBLE || c == NULL_LONG ? NULL_DOUBLE : s / Math.sqrt(c);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final byte w = wi.nextByte();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final short w = wi.nextShort();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final int w = wi.nextInt();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final long w = wi.nextLong();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final float w = wi.nextFloat();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }


    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wste(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted standard error.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted standard error of non-null values.
     */
    public static double wste(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        // see https://stats.stackexchange.com/questions/25895/computing-standard-error-in-weighted-mean-estimation
        double sumw = 0;
        double sumw2 = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                final double w = wi.nextDouble();

                if (!isNull(v) && !isNull(w)) {
                    sumw += w;
                    sumw2 += w*w;
                }
            }
        }

        final double s = wstd(values, weights);
        return s == NULL_DOUBLE ? NULL_DOUBLE : s * Math.sqrt(sumw2/sumw/sumw);
    }



    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(Double[] values) {
        return tstat(unbox(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return tstat(new DoubleVectorDirect(values));
    }

    /**
     * Returns the t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @return t-statistic of non-null values.
     */
    public static double tstat(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        final double a = avg(values);
        final double s = ste(values);
        return a == NULL_DOUBLE || s == NULL_DOUBLE ? NULL_DOUBLE : avg(values) / ste(values);
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }


    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wtstat(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted t-statistic.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted t-statistic of non-null values.
     */
    public static double wtstat(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final double a = wavg(values, weights);
        final double s = wste(values, weights);
        return a / s;
    }



    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static double max(DoubleVector values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_DOUBLE : values.get(idx);
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static double max(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return max(new DoubleVectorDirect(values));
    }

    /**
     * Returns the maximum.  Null values are excluded.
     *
     * @param values values.
     * @return maximum of non-null values, or null if there are no non-null values.
     */
    public static double max(Double[] values) {
        final long idx = indexOfMax(values);
        return idx == NULL_LONG ? NULL_DOUBLE : values[LongSizedDataStructure.intSize("max",idx)];
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static double min(DoubleVector values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_DOUBLE : values.get(idx);
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static double min(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return min(new DoubleVectorDirect(values));
    }

    /**
     * Returns the minimum.  Null values are excluded.
     *
     * @param values values.
     * @return minimum of non-null values, or null if there are no non-null values.
     */
    public static double min(Double[] values) {
        final long idx = indexOfMin(values);
        return idx == NULL_LONG ? NULL_DOUBLE : values[LongSizedDataStructure.intSize("min",idx)];
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(Double[] values) {
        return indexOfMax(unbox(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMax(new DoubleVectorDirect(values));
    }

    /**
     * Returns the index of the maximum value.
     *
     * @param values values.
     * @return index of the maximum value.
     */
    public static long indexOfMax(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        double val = MIN_DOUBLE;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c) && (c > val || (c == val && count == 0))) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(Double[] values) {
        return indexOfMin(unbox(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(double... values) {
        if (values == null) {
            return NULL_LONG;
        }

        return indexOfMin(new DoubleVectorDirect(values));
    }

    /**
     * Returns the index of the minimum value.
     *
     * @param values values.
     * @return index of the minimum value.
     */
    public static long indexOfMin(DoubleVector values) {
        if (values == null) {
            return NULL_LONG;
        }

        double val = MAX_DOUBLE;
        long index = NULL_LONG;
        long count = 0;
        long i = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c) && (c < val || (c == val && count == 0) )) {
                    val = c;
                    index = i;
                    count++;
                }

                i++;
            }
        }

        return count == 0 ? NULL_LONG : index;
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(Double[] values) {
        return median(unbox(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return median(new DoubleVectorDirect(values));
    }

    /**
     * Returns the median.
     *
     * @param values values.
     * @return median.
     */
    public static double median(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        int n = values.intSize("median");

        if (n == 0) {
            return Double.NaN;
        } else {
            double[] copy = values.copyToArray();
            Arrays.sort(copy);
            if (n % 2 == 0)
                return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
            else return copy[n / 2];
        }
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, double... values) {
        if (values == null || values.length == 0) {
            return NULL_DOUBLE;
        }

        return percentile(percentile, new DoubleVectorDirect(values));
    }

    /**
     * Returns the percentile.
     *
     * @param percentile percentile to compute.
     * @param values values.
     * @return percentile, or null value in the Deephaven convention if values is null or empty.
     */
    public static double percentile(double percentile, DoubleVector values) {
        if (values == null || values.isEmpty()) {
            return NULL_DOUBLE;
        }

        if (percentile < 0 || percentile > 1) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }

        int n = values.intSize("percentile");
        double[] copy = values.copyToArray();
        Arrays.sort(copy);

        int idx = (int) Math.round(percentile * (n - 1));
        return copy[idx];
    }



    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ByteVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfByte v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final byte v1 = v1i.nextByte();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new ShortVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfShort v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final short v1 = v1i.nextShort();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new IntVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfInt v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final int v1 = v1i.nextInt();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new LongVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfLong v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final long v1 = v1i.nextLong();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new FloatVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfFloat v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final float v1 = v1i.nextFloat();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }


    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(double[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cov(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the covariance.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return covariance of non-null values.
     */
    public static double cov(DoubleVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum1 = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum1 += v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        return sum01 / count - sum0 * sum1 / count / count;
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(double[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(new DoubleVectorDirect(values0), values1);
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        return cor(values0, new DoubleVectorDirect(values1));
    }

    /**
     * Returns the correlation.  Null values are excluded.
     *
     * @param values0 1st set of values.
     * @param values1 2nd set of values.
     * @return correlation of non-null values.
     */
    public static double cor(DoubleVector values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return NULL_DOUBLE;
        }

        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }

        double sum0 = 0;
        double sum0Sq = 0;
        double sum1 = 0;
        double sum1Sq = 0;
        double sum01 = 0;
        double count = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
            final CloseablePrimitiveIteratorOfDouble v1i = values1.iterator()
        ) {
            while (v0i.hasNext()) {
                final double v0 = v0i.nextDouble();
                final double v1 = v1i.nextDouble();

                if (!isNull(v0) && !isNull(v1)) {
                    sum0 += v0;
                    sum0Sq += v0 * v0;
                    sum1 += v1;
                    sum1Sq += v1 * v1;
                    sum01 += v0 * v1;
                    count++;
                }
            }
        }

        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;

        return cov / Math.sqrt(var0 * var1);
    }



    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static double sum(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double sum = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c)) {
                    sum += c;
                }
            }
        }

        return (double) (sum);
    }

    /**
     * Returns the sum.  Null values are excluded.
     *
     * @param values values.
     * @return sum of non-null values.
     */
    public static double sum(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return sum(new DoubleVectorDirect(values));
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static double product(DoubleVector values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        double prod = 1;
        int count = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double c = vi.nextDouble();
                if (!isNull(c)) {
                    count++;
                    prod *= c;
                }
            }
        }

        if (count == 0) {
            return NULL_DOUBLE;
        }

        return (double) (prod);
    }

    /**
     * Returns the product.  Null values are excluded.
     *
     * @param values values.
     * @return product of non-null values.
     */
    public static double product(double... values) {
        if (values == null) {
            return NULL_DOUBLE;
        }

        return product(new DoubleVectorDirect(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static double[] cummin(Double[] values) {
        return cummin(unbox(values));
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static double[] cummin(double... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[0];
        }

        double[] result = new double[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (double)Math.min(result[i - 1],  values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative minimum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative min of non-null values.
     */
    public static double[] cummin(DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new double[0];
        }

        final int n = values.intSize("cummin");
        double[] result = new double[n];

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            result[0] = vi.nextDouble();
            int i = 1;

            while (vi.hasNext()) {
                final double v = vi.nextDouble();

                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (double)Math.min(result[i - 1],  v);
                }

                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static double[] cummax(Double[] values) {
        return cummax(unbox(values));
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static double[] cummax(double... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[0];
        }

        double[] result = new double[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            result[i] = compare(result[i-1], values[i]) > 0 ? result[i-1] : values[i];
        }

        return result;
    }

    /**
     * Returns the cumulative maximum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative max of non-null values.
     */
    public static double[] cummax(DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new double[0];
        }

        final int n = values.intSize("cummax");
        double[] result = new double[n];

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            result[0] = vi.nextDouble();
            int i = 1;
    
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
                result[i] = compare(result[i-1], v) > 0 ? result[i-1] : v;
                i++;
            }
        }

        return result;
    }

   /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static double[] cumsum(Double[] values) {
        return cumsum(unbox(values));
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static double[] cumsum(double... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[0];
        }

        double[] result = new double[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (double) (result[i - 1] + values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative sum.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative sum of non-null values.
     */
    public static double[] cumsum(DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new double[0];
        }

        final int n = values.intSize("cumsum");
        double[] result = new double[n];

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            result[0] = vi.nextDouble();
            int i = 1;
    
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (double) (result[i - 1] + v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static double[] cumprod(Double[] values) {
        return cumprod(unbox(values));
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static double[] cumprod(double... values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[0];
        }

        double[] result = new double[values.length];
        result[0] = values[0];

        for (int i = 1; i < values.length; i++) {
            if (isNull(result[i - 1])) {
                result[i] = values[i];
            } else if (isNull(values[i])) {
                result[i] = result[i - 1];
            } else {
                result[i] = (double) (result[i - 1] * values[i]);
            }
        }

        return result;
    }

    /**
     * Returns the cumulative product.  Null values are excluded.
     *
     * @param values values.
     * @return cumulative product of non-null values.
     */
    public static double[] cumprod(DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new double[0];
        }

        final int n = values.intSize("cumprod");
        double[] result = new double[n];

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            result[0] = vi.nextDouble();
            int i = 1;
    
            while (vi.hasNext()) {
                final double v = vi.nextDouble();
    
                if (isNull(result[i - 1])) {
                    result[i] = v;
                } else if (isNull(v)) {
                    result[i] = result[i - 1];
                } else {
                    result[i] = (double) (result[i - 1] * v);
                }
    
                i++;
            }
        }

        return result;
    }

    /**
     * Returns the absolute value.
     *
     * @param value value.
     * @return absolute value.
     */
    public static double abs(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return (double) Math.abs(value);
    }

    /**
     * Returns the arc cosine.
     *
     * @param value value.
     * @return arc cosine.
     */
    public static double acos(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.acos(value);
    }

    /**
     * Returns the arc sine.
     *
     * @param value value.
     * @return arc sine.
     */
    public static double asin(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.asin(value);
    }

    /**
     * Returns the arc tangent.
     *
     * @param value value.
     * @return arc tangent.
     */
    public static double atan(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.atan(value);
    }

    /**
     * Returns the ceiling.  This is the smallest integer, which is greater than or equal to the value.
     *
     * @param value value.
     * @return ceiling.
     */
    public static double ceil(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.ceil(value);
    }

    /**
     * Returns the cosine.
     *
     * @param value value.
     * @return cosine.
     */
    public static double cos(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.cos(value);
    }

    /**
     * Returns Euler's number <i>e</i> raised to a power.
     *
     * @param value value.
     * @return Euler's number <i>e</i> raised to a power.
     */
    public static double exp(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.exp(value);
    }

    /**
     * Returns the floor.  This is the largest integer, which is less than or equal to the value.
     *
     * @param value value.
     * @return floor.
     */
    public static double floor(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.floor(value);
    }

    /**
     * Returns the natural logarithm (base <i>e</i>).
     *
     * @param value value.
     * @return natural logarithm (base <i>e</i>).
     */
    public static double log(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.log(value);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, byte b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, short b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, int b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, long b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, float b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the value of the first argument raised to the second argument.
     *
     * @param   a   the base.
     * @param   b   the exponent.
     * @return {@code a} raised to the {@code b} power.
     */
    public static double pow(double a, double b) {
        if (isNull(a) || isNull(b)) {
            return NULL_DOUBLE;
        }

        return Math.pow(a, b);
    }


    /**
     * Returns the integer closest to the input value.
     *
     * @param value value.
     * @return integer closes to the input value.
     */
    public static double rint(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.rint(value);
    }

    /**
     * Returns the closest integer to the argument.  If the argument is NaN, the result is 0.  If the argument is greater
     * than {@code Integer.MIN_VALUE}, {@code Integer.MIN_VALUE} is returned.  If the argument is less than {@code Integer.MAX_VALUE},
     * {@code Integer.MAX_VALUE} is returned.
     *
     * @param value value.
     */
    public static long round(double value) {
        if (isNull(value)) {
            return NULL_LONG;
        }

        return Math.round(value);
    }

    /**
     * Returns the signum function.
     *
     * @param value value.
     * @return signum function.
     */
    public static int signum(double value) {
        if (isNull(value)) {
            return NULL_INT;
        }

        return Integer.signum((int)value);
    }

    /**
     * Returns the sine.
     *
     * @param value value.
     * @return sine.
     */
    public static double sin(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sin(value);
    }

    /**
     * Returns the square root.
     *
     * @param value value.
     * @return square root.
     */
    public static double sqrt(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.sqrt(value);
    }

    /**
     * Returns the tangent.
     *
     * @param value value.
     * @return tangent.
     */
    public static double tan(double value) {
        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        return Math.tan(value);
    }



    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return lower bound of the bin containing the value.
     */
    public static double lowerBin(double value, double interval) {
        if (value == NULL_DOUBLE || interval == NULL_DOUBLE) {
            return NULL_DOUBLE;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        return (double) (interval * Math.floor(value / interval));
    }


    /**
     * Returns the lower bound of the bin containing the value.
     *
     * The lower bound of the bin containing the value is equal to <code>interval * floor((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return lower bound of the bin containing the value.
     */
    public static double lowerBin(double value, double interval, double offset) {
        if (value == NULL_DOUBLE || interval == NULL_DOUBLE) {
            return NULL_DOUBLE;
        }

        return (double)(lowerBin((double)(value-offset),interval) + offset);
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil(value / interval)</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @return upper bound of the bin containing the value.
     */
    public static double upperBin(double value, double interval) {
        if (value == NULL_DOUBLE || interval == NULL_DOUBLE) {
            return NULL_DOUBLE;
        }

        if ( interval <= 0 ) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }

        return (double) (interval * Math.ceil(value / interval));
    }


    /**
     * Returns the upper bound of the bin containing the value.
     *
     * The upper bound of the bin containing the value is equal to <code>interval * ceil((value-offset) / interval) + offset</code>.
     *
     * @param value value.
     * @param interval bin width.
     * @param offset interval offset
     * @return upper bound of the bin containing the value.
     */
    public static double upperBin(double value, double interval, double offset) {
        if (value == NULL_DOUBLE || interval == NULL_DOUBLE) {
            return NULL_DOUBLE;
        }

        return (double)(upperBin((double)(value-offset),interval) + offset);
    }

    /**
     * Constrains the value to be on the {@code [min,max]} range.  If the value is less than {@code min}, {@code min} is returned.
     * If the value is greater than {@code max}, {@code max} is returned.
     *
     * @param value value.
     * @param min minimum value.
     * @param max maximum value.
     * @return value constrained to be in the {@code [min,max]} range.
     */
    public static double clamp(double value, double min, double max) {
        Require.leq(min, "min", max, "max");

        if (isNull(value)) {
            return NULL_DOUBLE;
        }

        if (value < min) {
            return min;
        } else if (value > max) {
            return max;
        } else {
            return value;
        }
    }



    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ByteVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfByte wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final byte w = wi.nextByte();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new ShortVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfShort wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final short w = wi.nextShort();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new IntVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfInt wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final int w = wi.nextInt();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new LongVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfLong wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final long w = wi.nextLong();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new FloatVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfFloat wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final float w = wi.nextFloat();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }


    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wsum(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted sum.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted sum of non-null values.
     */
    public static double wsum(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                }
            }
        }

        return vsum;
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(new DoubleVectorDirect(values), weights);
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        return wavg(values, new DoubleVectorDirect(weights));
    }

    /**
     * Returns the weighted average.  Null values are excluded.
     *
     * @param values values.
     * @param weights weights
     * @return weighted average of non-null values.
     */
    public static double wavg(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return NULL_DOUBLE;
        }

        final long n = values.size();

        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }

        double vsum = 0;
        double wsum = 0;

        try (
            final CloseablePrimitiveIteratorOfDouble vi = values.iterator();
            final CloseablePrimitiveIteratorOfDouble wi = weights.iterator()
        ) {
            while (vi.hasNext()) {
                final double c = vi.nextDouble();
                final double w = wi.nextDouble();
    
                if (!isNull(c) && !isNull(w)) {
                    vsum += c * w;
                    wsum += w;
                }
            }
        }

        return vsum / wsum;
    }



    /**
     * Returns a sequence of values.
     *
     * @param start starting value.
     * @param end terminal value.
     * @param step step size.
     * @return sequence of values from start to end.
     */
    public static double[] sequence(double start, double end, double step) {
        if (step == 0) {
            return new double[0];
        }

        final int n = (int)((end-start)/step);

        if (n < 0) {
            return new double[0];
        }

        final double[] result = new double[n+1];

        for (int i=0; i<=n; i++) {
            result[i] = (double)(start + i*step);
        }

        return result;
    }



    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(Double value) {
        return value != null && Double.isNaN(value);
    }

    /**
     * Returns {@code true} if the value is NaN and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is NaN and {@code false} otherwise.
     */
    static public boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(Double value) {
        return value != null && Double.isInfinite(value);
    }

    /**
     * Returns {@code true} if the value is infinite and {@code false} otherwise.
     *
     * @param value value.
     * @return {@code true} if the value is infinite and {@code false} otherwise.
     */
    static public boolean isInf(double value) {
        return Double.isInfinite(value);
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(Double value) {
        return isFinite(castDouble(value));
    }

    /**
     * Returns {@code true} if the value is finite, where "finite" is defined as not infinite, not NaN, and not null.
     *
     * @param value value.
     * @return {@code true} if the value is not infinite, NaN, nor null; {@code false} otherwise
     */
    static public boolean isFinite(double value) {
        return Double.isFinite(value) && !isNull(value);
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(double) finite}; {@code false} otherwise.
     * @see #isFinite(double)
     */
    static public boolean containsNonFinite(Double[] values) {
        return containsNonFinite(unbox(values));
    }

    /**
     * Returns {@code true} if the values contains any non-finite value, where "finite" is defined as
     * not infinite, not NaN, and not null.
     *
     * @param values values.
     * @return {@code true} if any value is not {@link #isFinite(double) finite}; {@code false} otherwise.
     * @see #isFinite(double)
     */
    static public boolean containsNonFinite(double... values) {
        for (double v1 : values) {
            if (!isFinite(v1)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is NaN.
     * @return value, if value is not NaN, replacement otherwise.
     */
    static public double replaceIfNaN(double value, double replacement) {
        if (isNaN(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN.
     * @return array containing value, if value is not NaN, replacement otherwise.
     */
    static public double[] replaceIfNaN(double[] values, double replacement) {
        return replaceIfNaN(new DoubleVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are NaN with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN.
     * @return array containing value, if value is not NaN, replacement otherwise.
     */
    static public double[] replaceIfNaN(DoubleVector values, double replacement) {
        final int n = values.intSize("replaceIfNaN");
        double[] result = new double[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = replaceIfNaN(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public double replaceIfNullNaN(double value, double replacement) {
        if (isNaN(value) || isNull(value)) {
            return replacement;
        } else {
            return value;
        }
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return array containing value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNullNaN(double[] values, double replacement) {
        return replaceIfNullNaN(new DoubleVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are NaN or null according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is NaN or null according to Deephaven convention.
     * @return array containing value, if value is neither NaN nor null according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNullNaN(DoubleVector values, double replacement) {
        final int n = values.intSize("replaceIfNullNaN");
        double[] result = new double[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = replaceIfNullNaN(v, replacement);
                i++;
            }
        }

        return result;
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param value value.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public double replaceIfNonFinite(double value, double replacement) {
        return isFinite(value) ? value : replacement;
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return array containing value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNonFinite(double[] values, double replacement) {
        return replaceIfNonFinite(new DoubleVectorDirect(values), replacement);
    }

    /**
     * Replaces values that are not finite according to Deephaven convention with a specified value.
     *
     * @param values the values.
     * @param replacement replacement to use when value is not finite according to Deephaven convention.
     * @return array containing value, if value is finite according to Deephaven convention, replacement otherwise.
     */
    static public double[] replaceIfNonFinite(DoubleVector values, double replacement) {
        final int n = values.intSize("replaceIfNonFinite");
        double[] result = new double[n];
        int i = 0;

        try ( final CloseablePrimitiveIteratorOfDouble vi = values.iterator() ) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = replaceIfNonFinite(v, replacement);
                i++;
            }
        }

        return result;
    }


}
