/**********************************************************************************
* DO NOT EDIT THIS FILE.
* This code was auto-generated from src/templates/Sort.ftl by CodeGenerator.
* Manual changes to this file will be lost.
***********************************************************************************/


package io.deephaven.function;

import io.deephaven.vector.*;
import io.deephaven.function.comparators.NullNaNAwareComparator;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;
import java.util.Comparator;

import static io.deephaven.util.QueryConstants.*;
import static io.deephaven.function.Basic.isNull;

/**
 * Functions for sorting primitive types.
 */
public class Sort {

    //////////////////////////// Object ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }

        final T[] vs = values.copyToArray();
        Arrays.sort(vs, comparator);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final ObjectVector<T> values) {
        return sortObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        final T[] copy = Arrays.copyOf(values, values.length);
        if (copy.length == 0) {
            return copy;
        }

        Arrays.sort(copy, comparator);
        return copy;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> T[] sortObj(final T... values) {
        return sortObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final T[] vs = values.copyToArray();
        Arrays.sort(vs, comparator.reversed());
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final ObjectVector<T> values) {
        return sortDescendingObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        return sortDescendingObj(new ObjectVectorDirect<>(values), comparator);
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final T... values) {
        return sortDescendingObj(values, new NullNaNAwareComparator<>());
    }

    
    //////////////////////////// byte ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final byte[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final byte... values) {
        if (values == null) {
            return null;
        }

        return sort(new ByteVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final Byte[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[]{};
        }

        final byte[] vs = new byte[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_BYTE : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final byte[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final byte... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new ByteVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final Byte[] values) {
        if (values == null) {
            return null;
        }

        final byte[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }



    //////////////////////////// short ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final short[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final short... values) {
        if (values == null) {
            return null;
        }

        return sort(new ShortVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final Short[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[]{};
        }

        final short[] vs = new short[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_SHORT : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final short[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final short... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new ShortVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final Short[] values) {
        if (values == null) {
            return null;
        }

        final short[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }



    //////////////////////////// int ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final int[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final int... values) {
        if (values == null) {
            return null;
        }

        return sort(new IntVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final Integer[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[]{};
        }

        final int[] vs = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_INT : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final int[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final int... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new IntVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final Integer[] values) {
        if (values == null) {
            return null;
        }

        final int[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }



    //////////////////////////// long ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final long[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final long... values) {
        if (values == null) {
            return null;
        }

        return sort(new LongVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final Long[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[]{};
        }

        final long[] vs = new long[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_LONG : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final long[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final long... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new LongVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final Long[] values) {
        if (values == null) {
            return null;
        }

        final long[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }



    //////////////////////////// float ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final float[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final float... values) {
        if (values == null) {
            return null;
        }

        return sort(new FloatVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final Float[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[]{};
        }

        final float[] vs = new float[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_FLOAT : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final float[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final float... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new FloatVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final Float[] values) {
        if (values == null) {
            return null;
        }

        final float[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }



    //////////////////////////// double ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final double[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final double... values) {
        if (values == null) {
            return null;
        }

        return sort(new DoubleVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final Double[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[]{};
        }

        final double[] vs = new double[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_DOUBLE : values[i];
        }

        Arrays.sort(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final double[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse(vs);

        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final double... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new DoubleVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final Double[] values) {
        if (values == null) {
            return null;
        }

        final double[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }


}
