//
// Copyright (c) 2016-2024 Deephaven Data Labs and Patent Pending
//
// ****** AUTO-GENERATED CLASS - DO NOT EDIT MANUALLY
// ****** Edit src/templates/BinSearch.ftl and run "./gradlew :engine-function:compileJava" to regenerate
//
// @formatter:off

package io.deephaven.function;

import io.deephaven.vector.*;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.QueryConstants;

import static io.deephaven.util.QueryConstants.*;
import static io.deephaven.function.Basic.isNull;

/**
 * Functions for performing binary searches.
 */
@SuppressWarnings("SameParameterValue")
public class BinSearch {

    //////////////////////////// Object ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    static public <T extends Comparable<? super T>> int binSearchIndex(T[] values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return QueryConstants.NULL_INT;
        }

        return binSearchIndex(new ObjectVectorDirect<>(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    static public <T extends Comparable<? super T>> int binSearchIndex(ObjectVector<T> values, T key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == QueryConstants.NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    static public <T extends Comparable<? super T>> int rawBinSearchIndex(T[] values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return QueryConstants.NULL_INT;
        }

        return rawBinSearchIndex(new ObjectVectorDirect<>(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    static public <T extends Comparable<? super T>> int rawBinSearchIndex(ObjectVector<T> values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return QueryConstants.NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, LongSizedDataStructure.intSize("rawBinSearchIndex", values.size()), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, LongSizedDataStructure.intSize("rawBinSearchIndex", values.size()), key);
        }
    }

    static private <T extends Comparable<? super T>> int binarySearch0(ObjectVector<T> array, int fromIndex, int toIndex, T key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            T midVal = array.get(mid);
            if (midVal == null) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            int cmp = key.compareTo(midVal);
            if (cmp > 0) {
                low = mid + 1;
            } else if (cmp < 0) {
                high = mid - 1;
            } else {
                return mid;
            }
        }
        return -(low + 1);  // key not found.
    }

    static private <T extends Comparable<? super T>> int binarySearch0Modified(ObjectVector<T> array, int fromIndex, int toIndex, T key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final T lowVal = array.get(low);
        final T highVal = array.get(high);
        final boolean isNullLow = isNull(lowVal);
        final boolean isNullHigh = isNull(highVal);

        if (highestOrLowest) {
            if (high >= low && !isNullHigh && key.compareTo(highVal) == 0) {
                return high;
            }
        } else if (low <= high && !isNullLow && key.compareTo(lowVal) == 0) {
            return low;
        }

        if (isNullLow) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (isNullHigh) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            T midVal = array.get(mid);

            if (isNull(midVal)) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            int cmp = key.compareTo(midVal);
            if (cmp > 0) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key.compareTo(array.get(low)) == 0) {
                        return low;
                    }
                }
            } else if (cmp < 0) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key.compareTo(array.get(high)) == 0) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }



    //////////////////////////// char ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(char[] values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new CharVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(CharVector values, char key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(char[] values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new CharVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(CharVector values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_CHAR) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(CharVector array, int fromIndex, int toIndex, char key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            char midVal = array.get(mid);
            if (midVal == NULL_CHAR) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(CharVector array, int fromIndex, int toIndex, char key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final char lowVal = array.get(low);
        final char highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_CHAR) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_CHAR) {
            return low;
        }

        if (lowVal == NULL_CHAR) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_CHAR) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            char midVal = array.get(mid);

            if (midVal == NULL_CHAR) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// byte ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(byte[] values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new ByteVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(ByteVector values, byte key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(byte[] values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new ByteVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(ByteVector values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_BYTE) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(ByteVector array, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            byte midVal = array.get(mid);
            if (midVal == NULL_BYTE) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(ByteVector array, int fromIndex, int toIndex, byte key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final byte lowVal = array.get(low);
        final byte highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_BYTE) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_BYTE) {
            return low;
        }

        if (lowVal == NULL_BYTE) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_BYTE) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            byte midVal = array.get(mid);

            if (midVal == NULL_BYTE) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// short ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(short[] values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new ShortVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(ShortVector values, short key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(short[] values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new ShortVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(ShortVector values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_SHORT) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(ShortVector array, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            short midVal = array.get(mid);
            if (midVal == NULL_SHORT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(ShortVector array, int fromIndex, int toIndex, short key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final short lowVal = array.get(low);
        final short highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_SHORT) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_SHORT) {
            return low;
        }

        if (lowVal == NULL_SHORT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_SHORT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            short midVal = array.get(mid);

            if (midVal == NULL_SHORT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// int ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(int[] values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new IntVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(IntVector values, int key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(int[] values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new IntVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(IntVector values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_INT) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(IntVector array, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            int midVal = array.get(mid);
            if (midVal == NULL_INT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(IntVector array, int fromIndex, int toIndex, int key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final int lowVal = array.get(low);
        final int highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_INT) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_INT) {
            return low;
        }

        if (lowVal == NULL_INT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_INT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            int midVal = array.get(mid);

            if (midVal == NULL_INT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// long ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(long[] values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new LongVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(LongVector values, long key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(long[] values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new LongVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(LongVector values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_LONG) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(LongVector array, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            long midVal = array.get(mid);
            if (midVal == NULL_LONG) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(LongVector array, int fromIndex, int toIndex, long key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final long lowVal = array.get(low);
        final long highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_LONG) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_LONG) {
            return low;
        }

        if (lowVal == NULL_LONG) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_LONG) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            long midVal = array.get(mid);

            if (midVal == NULL_LONG) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// float ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(float[] values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new FloatVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(FloatVector values, float key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(float[] values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new FloatVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(FloatVector values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_FLOAT) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(FloatVector array, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            float midVal = array.get(mid);
            if (midVal == NULL_FLOAT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(FloatVector array, int fromIndex, int toIndex, float key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final float lowVal = array.get(low);
        final float highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_FLOAT) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_FLOAT) {
            return low;
        }

        if (lowVal == NULL_FLOAT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_FLOAT) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            float midVal = array.get(mid);

            if (midVal == NULL_FLOAT) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }


    //////////////////////////// double ////////////////////////////


    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index immediately before where the key would be inserted.
     */
    public static int binSearchIndex(double[] values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return binSearchIndex(new DoubleVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, the index of where the key would be inserted.
     */
    public static int binSearchIndex(DoubleVector values, double key, BinSearchAlgo choiceWhenEquals) {
        int index = rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == NULL_INT) {
            return index;
        }

        if (index < 0) {
            return -index - 1;
        } else {
            return index;
        }
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(double[] values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return NULL_INT;
        }

        return rawBinSearchIndex(new DoubleVectorDirect(values), key, choiceWhenEquals);
    }

    /**
     * Performs a binary search to find a key.
     *
     * @param values sorted values to search.  Null values are not supported.
     * @param key key to search for.  Null keys are not supported.
     * @param choiceWhenEquals algorithm used to resolve ties when performing a binary search.
     * @return index of the search key, if it is contained in the array; otherwise, {@code (-(insertion point) - 1)}.
     */
    public static int rawBinSearchIndex(DoubleVector values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == NULL_DOUBLE) {
            return NULL_INT;
        }

        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        } else {
            return binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
        }
    }

    static private int binarySearch0(DoubleVector array, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            int mid = (low + high) >>> 1;
            double midVal = array.get(mid);
            if (midVal == NULL_DOUBLE) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (midVal < key)
                low = mid + 1;
            else if (midVal > key)
                high = mid - 1;
            else
                return mid; // key found
        }
        return -(low + 1);  // key not found.
    }

    static private int binarySearch0Modified(DoubleVector array, int fromIndex, int toIndex, double key, boolean highestOrLowest) {
        if(array.isEmpty()){
            return -1;
        }

        int low = fromIndex;
        int high = toIndex - 1;

        final double lowVal = array.get(low);
        final double highVal = array.get(high);

        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != NULL_DOUBLE) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != NULL_DOUBLE) {
            return low;
        }

        if (lowVal == NULL_DOUBLE) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        if (highVal == NULL_DOUBLE) {
            throw new RuntimeException("Can't have a null in the array!");
        }

        while (low <= high) {
            int mid = highestOrLowest ? (low + high + 1) >>> 1 : (low + high) >>> 1;
            double midVal = array.get(mid);

            if (midVal == NULL_DOUBLE) {
                throw new RuntimeException("Can't have a null in the array!");
            }

            if (key > midVal) {
                low = mid + 1;
                if (low <= high) {
                    if (!highestOrLowest && key == array.get(low)) {
                        return low;
                    }
                }
            } else if (key < midVal) {
                high = mid - 1;
                if (high >= low) {
                    if (highestOrLowest && key == array.get(high)) {
                        return high;
                    }
                }
            } else {
                if (highestOrLowest) {
                    low = mid;
                } else {
                    high = mid;
                }
            }
        }

        return -(low + 1);  // key not found.
    }

}
