//
// Copyright (c) 2016-2024 Deephaven Data Labs and Patent Pending
//
// ****** AUTO-GENERATED CLASS - DO NOT EDIT MANUALLY
// ****** Edit src/templates/Cast.ftl and run "./gradlew :engine-function:compileJava" to regenerate
//
// @formatter:off

package io.deephaven.function;

import io.deephaven.vector.*;
import io.deephaven.engine.primitive.iterator.*;

import static io.deephaven.util.QueryConstants.*;

/**
 * Functions for casting between types.
 */
@SuppressWarnings("unused")
public class Cast {

    /**
     * Cast can not preserve the value.
     */
    public static class CastDoesNotPreserveValue extends UnsupportedOperationException {

        private static final long serialVersionUID = 5998276378465685974L;

        /**
         * Creates a new exception.
         *
         * @param message error message.
         */
        public CastDoesNotPreserveValue(final String message) {
            super(message);
        }
    }

    private static boolean isLosingPrecisionDouble(final long v) {
        return v > 9007199254740992L || v < -9007199254740992L;
    }

    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static int castInt(byte value, boolean checkFidelity) {
        return value == NULL_BYTE ? NULL_INT : value;
    }

    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static int castInt(short value, boolean checkFidelity) {
        return value == NULL_SHORT ? NULL_INT : value;
    }

    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static int castInt(int value, boolean checkFidelity) {
        return value;
    }

    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static int castInt(long value, boolean checkFidelity) {
        if( value == NULL_LONG ){
            return NULL_INT;
        }

        if (checkFidelity && value == NULL_INT) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", represents the null integer sentinel and therefore cannot be cast to int.");
        }

        if(checkFidelity && (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE)) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", overflows while being cast to int.");
        }

        return (int) value;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static long castLong(byte value, boolean checkFidelity) {
        return value == NULL_BYTE ? NULL_LONG : value;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static long castLong(short value, boolean checkFidelity) {
        return value == NULL_SHORT ? NULL_LONG : value;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static long castLong(int value, boolean checkFidelity) {
        return value == NULL_INT ? NULL_LONG : value;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static long castLong(long value, boolean checkFidelity) {
        return value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(byte value, boolean checkFidelity) {
        return value == NULL_BYTE ? NULL_DOUBLE : value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(short value, boolean checkFidelity) {
        return value == NULL_SHORT ? NULL_DOUBLE : value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(int value, boolean checkFidelity) {
        return value == NULL_INT ? NULL_DOUBLE : value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(long value, boolean checkFidelity) {
        if (value == NULL_LONG) {
            return NULL_DOUBLE;
        }

        if (checkFidelity && isLosingPrecisionDouble(value)) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", overflows while being cast to double.");
        }

        return value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(float value, boolean checkFidelity) {
        return value == NULL_FLOAT ? NULL_DOUBLE : value;
    }

    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast value.
     */
    public static double castDouble(double value, boolean checkFidelity) {
        return value;
    }




    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @return cast value.
     */
    public static int castInt(byte value) {
        return castInt(value, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(byte... values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(byte[] values, boolean checkFidelity) {
        return values == null ? null : castInt(new ByteVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(ByteVector values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                result[i] = castInt(v, checkFidelity);
                i++;
            }
        }

        return result;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @return cast value.
     */
    public static long castLong(byte value) {
        return castLong(value, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(byte... values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(byte[] values, boolean checkFidelity) {
        return values == null ? null : castLong(new ByteVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(ByteVector values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                result[i] = castLong(v, checkFidelity);
                i++;
            }
        }

        return result;
    }


    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(byte value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(byte... values) {
        return values == null ? null : castDouble(new ByteVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(byte[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new ByteVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(ByteVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfByte vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final byte v = vi.nextByte();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }



    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @return cast value.
     */
    public static int castInt(short value) {
        return castInt(value, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(short... values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(short[] values, boolean checkFidelity) {
        return values == null ? null : castInt(new ShortVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(ShortVector values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                result[i] = castInt(v, checkFidelity);
                i++;
            }
        }

        return result;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @return cast value.
     */
    public static long castLong(short value) {
        return castLong(value, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(short... values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(short[] values, boolean checkFidelity) {
        return values == null ? null : castLong(new ShortVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(ShortVector values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                result[i] = castLong(v, checkFidelity);
                i++;
            }
        }

        return result;
    }


    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(short value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(short... values) {
        return values == null ? null : castDouble(new ShortVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(short[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new ShortVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(ShortVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfShort vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final short v = vi.nextShort();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }



    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @return cast value.
     */
    public static int castInt(int value) {
        return castInt(value, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(int... values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(int[] values, boolean checkFidelity) {
        return values == null ? null : castInt(new IntVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(IntVector values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                result[i] = castInt(v, checkFidelity);
                i++;
            }
        }

        return result;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @return cast value.
     */
    public static long castLong(int value) {
        return castLong(value, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(int... values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(int[] values, boolean checkFidelity) {
        return values == null ? null : castLong(new IntVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(IntVector values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                result[i] = castLong(v, checkFidelity);
                i++;
            }
        }

        return result;
    }


    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(int value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(int... values) {
        return values == null ? null : castDouble(new IntVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(int[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new IntVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(IntVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfInt vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final int v = vi.nextInt();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }



    /**
     * Casts a value to an {@code int}.
     *
     * @param value value
     * @return cast value.
     */
    public static int castInt(long value) {
        return castInt(value, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(long... values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(long[] values, boolean checkFidelity) {
        return values == null ? null : castInt(new LongVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @return cast array.
     */
    public static int[] castInt(LongVector values){
        return castInt(values, true);
    }

    /**
     * Casts an array to an {@code int} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static int[] castInt(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                result[i] = castInt(v, checkFidelity);
                i++;
            }
        }

        return result;
    }

    /**
     * Casts a value to a {@code long}.
     *
     * @param value value
     * @return cast value.
     */
    public static long castLong(long value) {
        return castLong(value, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(long... values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(long[] values, boolean checkFidelity) {
        return values == null ? null : castLong(new LongVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @return cast array.
     */
    public static long[] castLong(LongVector values){
        return castLong(values, true);
    }

    /**
     * Casts an array to a {@code long} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static long[] castLong(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                result[i] = castLong(v, checkFidelity);
                i++;
            }
        }

        return result;
    }


    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(long value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(long... values) {
        return values == null ? null : castDouble(new LongVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(long[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new LongVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(LongVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfLong vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final long v = vi.nextLong();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }



    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(float value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(float... values) {
        return values == null ? null : castDouble(new FloatVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(float[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new FloatVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(FloatVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(FloatVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfFloat vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final float v = vi.nextFloat();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }



    /**
     * Casts a value to a {@code double}.
     *
     * @param value value
     * @return cast value.
     */
    public static double castDouble(double value) {
        return castDouble(value, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(double... values) {
        return values == null ? null : castDouble(new DoubleVectorDirect(values));
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(double[] values, boolean checkFidelity) {
        return values == null ? null : castDouble(new DoubleVectorDirect(values), checkFidelity);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @return cast array.
     */
    public static double[] castDouble(DoubleVector values) {
        return castDouble(values, true);
    }

    /**
     * Casts an array to a {@code double} array.
     *
     * @param values values
     * @param checkFidelity check to see if the cast preserves the value.
     * @return cast array.
     */
    public static double[] castDouble(DoubleVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }

        final int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;

        try (final CloseablePrimitiveIteratorOfDouble vi = values.iterator()) {
            while ( vi.hasNext() ) {
                final double v = vi.nextDouble();
                result[i] = castDouble(v, checkFidelity);
                i++;
            }
        }

        return result;
    }

}
