//
// Copyright (c) 2016-2024 Deephaven Data Labs and Patent Pending
//
// ****** AUTO-GENERATED CLASS - DO NOT EDIT MANUALLY
// ****** Edit src/templates/Sort.ftl and run "./gradlew :engine-function:compileJava" to regenerate
//
// @formatter:off

package io.deephaven.function;

import io.deephaven.vector.*;
import io.deephaven.function.comparators.NullNaNAwareComparator;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.IntStream;

import static io.deephaven.util.QueryConstants.*;
import static io.deephaven.function.Basic.isNull;
import static io.deephaven.function.Numeric.compare;

/**
 * Functions for sorting primitive types.
 */
public class Sort {

    //////////////////////////// Object ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }

        final T[] vs = values.copyToArray();
        Arrays.sort(vs, comparator);
        return vs;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final ObjectVector<T> values) {
        return sortObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        final T[] copy = Arrays.copyOf(values, values.length);
        if (copy.length == 0) {
            return copy;
        }

        Arrays.sort(copy, comparator);
        return copy;
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> T[] sortObj(final T... values) {
        return sortObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> comparator.compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankObj(final ObjectVector<T> values) {
        return rankObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        return IntStream.range(0, values.length)
            .boxed().sorted((i, j) -> comparator.compare(values[i], values[j]))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> int[] rankObj(final T... values) {
        return rankObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final T[] vs = values.copyToArray();
        Arrays.sort(vs, comparator.reversed());
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final ObjectVector<T> values) {
        return sortDescendingObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted values.
     */
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        return sortDescendingObj(new ObjectVectorDirect<>(values), comparator);
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> T[] sortDescendingObj(final T... values) {
        return sortDescendingObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankDescendingObj(final ObjectVector<T> values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> comparator.compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankDescendingObj(final ObjectVector<T> values) {
        return rankDescendingObj(values, new NullNaNAwareComparator<>());
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @param comparator value comparator.
     * @return sorted indices.
     */
    static public <T extends Comparable<? super T>> int[] rankDescendingObj(final T[] values, final Comparator<T> comparator) {
        if (values == null) {
            return null;
        }

        return rankDescendingObj(new ObjectVectorDirect<>(values), comparator);
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    @SafeVarargs
    static public <T extends Comparable<? super T>> int[] rankDescendingObj(final T... values) {
        return rankDescendingObj(values, new NullNaNAwareComparator<>());
    }


    //////////////////////////// byte ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Byte[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final byte... values) {
        if (values == null) {
            return null;
        }

        return sort(new ByteVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sort(final Byte[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new byte[]{};
        }

        final Byte[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final byte... values) {
        if (values == null) {
            return null;
        }

        return rank(new ByteVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Byte[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final byte[] vs = new byte[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_BYTE : values[i];
        }

        return rank(new ByteVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final byte[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final byte... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new ByteVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static byte[] sortDescending(final Byte[] values) {
        if (values == null) {
            return null;
        }

        final byte[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final ByteVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final byte... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new ByteVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Byte[] values) {
        if (values == null) {
            return null;
        }

        final byte[] vs = new byte[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_BYTE : values[i];
        }

        return rankDescending(new ByteVectorDirect(vs));
    }


    //////////////////////////// short ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Short[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final short... values) {
        if (values == null) {
            return null;
        }

        return sort(new ShortVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sort(final Short[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new short[]{};
        }

        final Short[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final short... values) {
        if (values == null) {
            return null;
        }

        return rank(new ShortVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Short[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final short[] vs = new short[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_SHORT : values[i];
        }

        return rank(new ShortVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final short[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final short... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new ShortVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static short[] sortDescending(final Short[] values) {
        if (values == null) {
            return null;
        }

        final short[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final ShortVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final short... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new ShortVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Short[] values) {
        if (values == null) {
            return null;
        }

        final short[] vs = new short[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_SHORT : values[i];
        }

        return rankDescending(new ShortVectorDirect(vs));
    }


    //////////////////////////// int ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Integer[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final int... values) {
        if (values == null) {
            return null;
        }

        return sort(new IntVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sort(final Integer[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[]{};
        }

        final Integer[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final int... values) {
        if (values == null) {
            return null;
        }

        return rank(new IntVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Integer[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final int[] vs = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_INT : values[i];
        }

        return rank(new IntVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final int[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final int... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new IntVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static int[] sortDescending(final Integer[] values) {
        if (values == null) {
            return null;
        }

        final int[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final IntVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final int... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new IntVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Integer[] values) {
        if (values == null) {
            return null;
        }

        final int[] vs = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_INT : values[i];
        }

        return rankDescending(new IntVectorDirect(vs));
    }


    //////////////////////////// long ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Long[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final long... values) {
        if (values == null) {
            return null;
        }

        return sort(new LongVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sort(final Long[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new long[]{};
        }

        final Long[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final long... values) {
        if (values == null) {
            return null;
        }

        return rank(new LongVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Long[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final long[] vs = new long[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_LONG : values[i];
        }

        return rank(new LongVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final long[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final long... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new LongVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static long[] sortDescending(final Long[] values) {
        if (values == null) {
            return null;
        }

        final long[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final LongVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final long... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new LongVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Long[] values) {
        if (values == null) {
            return null;
        }

        final long[] vs = new long[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_LONG : values[i];
        }

        return rankDescending(new LongVectorDirect(vs));
    }


    //////////////////////////// float ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Float[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final float... values) {
        if (values == null) {
            return null;
        }

        return sort(new FloatVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sort(final Float[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new float[]{};
        }

        final Float[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final float... values) {
        if (values == null) {
            return null;
        }

        return rank(new FloatVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Float[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final float[] vs = new float[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_FLOAT : values[i];
        }

        return rank(new FloatVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final float[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final float... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new FloatVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static float[] sortDescending(final Float[] values) {
        if (values == null) {
            return null;
        }

        final float[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final FloatVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final float... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new FloatVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Float[] values) {
        if (values == null) {
            return null;
        }

        final float[] vs = new float[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_FLOAT : values[i];
        }

        return rankDescending(new FloatVectorDirect(vs));
    }


    //////////////////////////// double ////////////////////////////


    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final Double[] vb = ArrayUtils.toObject(values.toArray());
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final double... values) {
        if (values == null) {
            return null;
        }

        return sort(new DoubleVectorDirect(values));
    }

    /**
     * Returns sorted values from smallest to largest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sort(final Double[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new double[]{};
        }

        final Double[] vb = values.clone();
        Arrays.sort(vb, Numeric::compare);
        return ArrayUtils.toPrimitive(vb);
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(i), values.get(j)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final double... values) {
        if (values == null) {
            return null;
        }

        return rank(new DoubleVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from smallest to largest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rank(final Double[] values) {
        if (values == null) {
            return null;
        }

        if (values.length == 0) {
            return new int[0];
        }

        final double[] vs = new double[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_DOUBLE : values[i];
        }

        return rank(new DoubleVectorDirect(vs));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return values.toArray();
        }

        final double[] vs = sort(values);
        ArrayUtils.reverse(vs);
        return vs;
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final double... values) {
        if (values == null) {
            return null;
        }

        return sortDescending(new DoubleVectorDirect(values));
    }

    /**
     * Returns sorted values from largest to smallest.
     *
     * @param values values.
     * @return sorted values.
     */
    public static double[] sortDescending(final Double[] values) {
        if (values == null) {
            return null;
        }

        final double[] result = sort(values);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final DoubleVector values) {
        if (values == null) {
            return null;
        }

        if (values.isEmpty()) {
            return new int[0];
        }

        return IntStream.range(0, values.intSize("rank"))
            .boxed().sorted((i, j) -> compare(values.get(j), values.get(i)))
            .mapToInt(ele -> ele).toArray();
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final double... values) {
        if (values == null) {
            return null;
        }

        return rankDescending(new DoubleVectorDirect(values));
    }

    /**
     * Returns the indices of values sorted from largest to smallest.
     *
     * @param values values.
     * @return sorted indices.
     */
    public static int[] rankDescending(final Double[] values) {
        if (values == null) {
            return null;
        }

        final double[] vs = new double[values.length];
        for (int i = 0; i < values.length; i++) {
            vs[i] = isNull(values[i]) ? NULL_DOUBLE : values[i];
        }

        return rankDescending(new DoubleVectorDirect(vs));
    }

}
