/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.testutil.TstUtils;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import io.deephaven.engine.testutil.sources.ImmutableColumnHolder;
import java.time.Instant;
import java.util.Arrays;
import java.util.Random;

public class ColumnInfo<T, U> {
    final Class<T> type;
    final Class<U> dataType;
    final Class<?> componentType;
    final TestDataGenerator<T, U> generator;
    final String name;
    final boolean immutable;
    final boolean grouped;
    static final ColAttributes[] ZERO_LENGTH_COLUMN_ATTRIBUTES_ARRAY = new ColAttributes[0];

    public ColumnInfo(TestDataGenerator<T, U> generator, String name, ColAttributes ... colAttributes) {
        this.dataType = generator.getType();
        this.type = generator.getColumnType();
        this.componentType = this.type.getComponentType();
        this.generator = generator;
        this.name = name;
        this.immutable = Arrays.asList(colAttributes).contains((Object)ColAttributes.Immutable);
        this.grouped = Arrays.asList(colAttributes).contains((Object)ColAttributes.Grouped);
    }

    public ColumnHolder<?> generateInitialColumn(RowSet rowSet, Random random) {
        Chunk<Values> initialData = this.generator.populateChunk(rowSet, random);
        if (this.dataType == Long.class && this.type == Instant.class) {
            Require.eqFalse((boolean)this.immutable, (String)"immutable");
            Require.eqFalse((boolean)this.grouped, (String)"grouped");
            return ColumnHolder.getInstantColumnHolder((String)this.name, (boolean)false, initialData);
        }
        if (this.immutable) {
            return new ImmutableColumnHolder<T>(this.name, this.type, this.componentType, this.grouped, initialData);
        }
        if (this.grouped) {
            return TstUtils.groupedColumnHolderForChunk(this.name, this.type, this.componentType, initialData);
        }
        return TstUtils.columnHolderForChunk(this.name, this.type, this.componentType, initialData);
    }

    public void remove(RowSet rowKeys) {
        this.generator.onRemove(rowKeys);
    }

    public void shift(long start, long end, long delta) {
        this.generator.shift(start, end, delta);
    }

    public ColumnHolder<T> generateUpdateColumnHolder(RowSet keysToModify, Random random) {
        Chunk<Values> chunk = this.generator.populateChunk(keysToModify, random);
        if (this.grouped) {
            return TstUtils.groupedColumnHolderForChunk(this.name, this.type, this.componentType, chunk);
        }
        return TstUtils.columnHolderForChunk(this.name, this.type, this.componentType, chunk);
    }

    public static enum ColAttributes {
        None,
        Immutable,
        Grouped;

    }
}

