/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.base.Pair;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableListener;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.TableUpdateListener;
import io.deephaven.engine.table.impl.InstrumentedTableUpdateListener;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.TableUpdateValidator;
import io.deephaven.engine.testutil.EvalNuggetInterface;
import io.deephaven.engine.testutil.TstUtils;
import io.deephaven.engine.testutil.testcase.RefreshingTableTestCase;
import io.deephaven.engine.util.TableDiff;
import io.deephaven.engine.util.TableTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class EvalNugget
implements EvalNuggetInterface {
    private final String description;
    public final Table originalValue = this.e();
    private Table recomputedTable = null;
    private Throwable exception = null;
    private final TableUpdateListener failureListener = new FailureListener();
    private final TableUpdateValidator validator;
    private final TableUpdateListener validationFailureListener;

    public static EvalNugget from(final Supplier<Table> makeTable) {
        return new EvalNugget(){

            @Override
            protected Table e() {
                return (Table)makeTable.get();
            }
        };
    }

    public EvalNugget() {
        this(null);
    }

    public EvalNugget(String description) {
        if (this.originalValue instanceof QueryTable) {
            ((QueryTable)this.originalValue).addUpdateListener(this.failureListener);
        }
        if (this.originalValue instanceof QueryTable && ((QueryTable)this.originalValue).isRefreshing()) {
            this.validator = TableUpdateValidator.make((QueryTable)((QueryTable)this.originalValue));
            this.validationFailureListener = new ValidationFailureListener();
            this.validator.getResultTable().addUpdateListener(this.validationFailureListener);
        } else {
            this.validator = null;
            this.validationFailureListener = null;
        }
        this.description = description;
        if (RefreshingTableTestCase.printTableUpdates) {
            this.showResult("Original Table:", this.originalValue);
            System.out.println();
        }
    }

    protected abstract Table e();

    public EvalNugget hasUnstableColumns(String ... columnNames) {
        if (this.validator != null) {
            this.validator.dontValidateColumns(columnNames);
        }
        return this;
    }

    @Override
    public void validate(String msg) {
        if (this.validator != null) {
            this.validator.validate();
        }
        Assert.assertNull((Object)this.exception);
        if (this.recomputedTable == null) {
            this.recomputedTable = this.e();
        }
        this.checkDifferences(msg, this.recomputedTable);
    }

    public void showResult(String label, Table e) {
        System.out.println(label);
        TableTools.showWithRowSet((Table)e, (long)100L, (String[])new String[0]);
    }

    protected void checkDifferences(String msg, Table recomputed) {
        TstUtils.assertTableEquals(msg, this.forComparison(recomputed), this.forComparison(this.originalValue), this.diffItems());
    }

    @NotNull
    protected EnumSet<TableDiff.DiffItems> diffItems() {
        return EnumSet.of(TableDiff.DiffItems.DoublesExact);
    }

    protected Table forComparison(Table t) {
        return t;
    }

    @Override
    public void show() {
        this.recomputedTable = this.e();
        Table recomputedForComparison = this.forComparison(this.recomputedTable);
        Table originalForComparison = this.forComparison(this.originalValue);
        int maxLines = 100;
        Pair diffPair = TableTools.diffPair((Table)originalForComparison, (Table)recomputedForComparison, (long)100L, this.diffItems());
        if (((String)diffPair.getFirst()).equals("")) {
            this.showResult("Recomputed Table:", this.recomputedTable);
        } else if (!((String)diffPair.getFirst()).equals("")) {
            long numTableRows = Math.min(100L, Math.max(originalForComparison.size(), recomputedForComparison.size()));
            long firstRow = Math.max(0L, (Long)diffPair.getSecond() - 5L);
            long lastRow = Math.min(firstRow + numTableRows, Math.min(firstRow + 100L, (Long)diffPair.getSecond() + 5L));
            System.out.println("Recomputed Table Differs:\n" + (String)diffPair.getFirst() + "\nRecomputed Table Rows [" + firstRow + ", " + lastRow + "]:");
            TableTools.showWithRowSet((Table)recomputedForComparison, (long)firstRow, (long)(lastRow + 1L), (String[])new String[0]);
            System.out.println("Incremental Table Rows [" + firstRow + ", " + lastRow + "]:");
            TableTools.showWithRowSet((Table)originalForComparison, (long)firstRow, (long)(lastRow + 1L), (String[])new String[0]);
            if (recomputedForComparison != this.recomputedTable) {
                this.showResult("Recomputed Table (unmodified):", this.recomputedTable);
            }
            if (originalForComparison != this.originalValue) {
                this.showResult("Incremental Table (unmodified):", this.originalValue);
            }
        }
    }

    @Override
    public void releaseRecomputed() {
        if (this.recomputedTable != null && this.recomputedTable != this.originalValue && this.recomputedTable.tryRetainReference()) {
            this.recomputedTable.dropReference();
            throw new IllegalStateException("Recomputed table " + this.recomputedTable + " is still live upon release");
        }
        this.recomputedTable = null;
    }

    public static abstract class Sorted
    extends EvalNugget {
        private final String[] sortColumns;

        public Sorted(String ... sortColumns) {
            this.sortColumns = sortColumns;
        }

        public Sorted(String description, String ... sortColumns) {
            super(description);
            this.sortColumns = sortColumns;
        }

        @Override
        protected Table forComparison(Table t) {
            return (Table)t.sort(this.sortColumns);
        }

        public static EvalNugget from(final Supplier<Table> makeTable, String ... sortColumns) {
            return new Sorted(sortColumns){

                @Override
                protected Table e() {
                    return (Table)makeTable.get();
                }
            };
        }
    }

    class ValidationFailureListener
    extends InstrumentedTableUpdateListener {
        ValidationFailureListener() {
            super("Failure Listener");
        }

        public void onUpdate(TableUpdate upstream) {
        }

        public void onFailureInternal(Throwable originalException, TableListener.Entry sourceEntry) {
            EvalNugget.this.exception = originalException;
            StringWriter errors = new StringWriter();
            if (EvalNugget.this.description != null) {
                errors.write("Failure updating " + EvalNugget.this.description + "\n");
            }
            originalException.printStackTrace(new PrintWriter(errors));
            EvalNugget.this.showResult("Incremental Table at Failure State:", EvalNugget.this.originalValue);
            TestCase.fail((String)errors.toString());
        }
    }

    class FailureListener
    extends ValidationFailureListener {
        FailureListener() {
        }

        @Override
        public void onUpdate(TableUpdate upstream) {
            if (RefreshingTableTestCase.printTableUpdates) {
                System.out.println("Incremental Table Update:");
                System.out.println(upstream);
            }
        }
    }
}

