/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.testutil.EvalNugget;
import io.deephaven.engine.util.TableTools;
import io.deephaven.tuple.ArrayTuple;
import io.deephaven.util.SafeCloseable;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;

public abstract class EvalNuggetSet
extends EvalNugget {
    public EvalNuggetSet(String description) {
        super(description);
    }

    @Override
    public void validate(String msg) {
        try (SafeCloseable ignored = LivenessScopeStack.open();){
            int i;
            Object[] key;
            long next;
            Table expected = this.e();
            try {
                TableTools.show((Table)expected, (String[])new String[0]);
                TableTools.show((Table)this.originalValue, (String[])new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Collection sources = this.originalValue.getColumnSources();
            HashMap<ArrayTuple, Long> originalSet = new HashMap<ArrayTuple, Long>();
            Assert.assertEquals((long)expected.size(), (long)this.originalValue.size());
            try (RowSet.Iterator iterator = this.originalValue.getRowSet().iterator();){
                while (iterator.hasNext()) {
                    next = iterator.nextLong();
                    key = new Object[sources.size()];
                    i = 0;
                    for (ColumnSource source : sources) {
                        key[i++] = source.get(next);
                    }
                    ArrayTuple k = new ArrayTuple(key);
                    Assert.assertNull((String)(msg + " k = " + k), (Object)originalSet.put(k, next));
                }
            }
            sources = expected.getColumnSources();
            iterator = expected.getRowSet().iterator();
            while (iterator.hasNext()) {
                next = iterator.nextLong();
                key = new Object[sources.size()];
                i = 0;
                for (ColumnSource source : sources) {
                    key[i++] = source.get(next);
                }
                Assert.assertNotSame((String)msg, originalSet.remove(new ArrayTuple(key)), null);
            }
        }
    }
}

