/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.base.verify.Assert;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.RowSetShiftData;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.ModifiedColumnSet;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.TableUpdateImpl;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.testutil.ColumnInfo;
import io.deephaven.engine.testutil.TstUtils;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.testutil.testcase.RefreshingTableTestCase;
import io.deephaven.engine.util.TableTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.mutable.MutableLong;

public class GenerateTableUpdates {
    public static final SimulationProfile DEFAULT_PROFILE = new SimulationProfile();
    public static final SimulationProfile NO_SHIFT_PROFILE = new SimulationProfile(){
        {
            this.SHIFT_10_PERCENT_KEY_SPACE = 0;
            this.SHIFT_10_PERCENT_POS_SPACE = 0;
            this.SHIFT_AGGRESSIVELY = 0;
        }
    };

    public static void generateTableUpdates(int size, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfo) {
        RowSet[] result = GenerateTableUpdates.computeTableUpdates(size, random, table, columnInfo);
        table.notifyListeners(result[0], result[1], result[2]);
    }

    public static void generateAppends(int size, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfos) {
        long firstKey = table.getRowSet().lastRowKey() + 1L;
        int randomSize = 1 + random.nextInt(size);
        WritableRowSet keysToAdd = RowSetFactory.fromRange((long)firstKey, (long)(firstKey + (long)randomSize - 1L));
        ColumnHolder[] columnAdditions = new ColumnHolder[columnInfos.length];
        for (int i = 0; i < columnAdditions.length; ++i) {
            columnAdditions[i] = columnInfos[i].generateUpdateColumnHolder((RowSet)keysToAdd, random);
        }
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println();
        }
        TstUtils.addToTable((Table)table, (RowSet)keysToAdd, columnAdditions);
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println("Add: " + (RowSet)keysToAdd);
            try {
                System.out.println("Updated Table:" + table.size());
                TableTools.showWithRowSet((Table)table, (long)100L, (String[])new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        table.notifyListeners((RowSet)keysToAdd, (RowSet)RowSetFactory.empty(), (RowSet)RowSetFactory.empty());
    }

    public static RowSet[] computeTableUpdates(int size, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfo) {
        return GenerateTableUpdates.computeTableUpdates(size, random, table, columnInfo, true, true, true);
    }

    public static RowSet[] computeTableUpdates(int size, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfo, boolean add, boolean remove, boolean modify) {
        int i;
        WritableRowSet keysToRemove = remove && table.getRowSet().size() > 0L ? TstUtils.selectSubIndexSet(random.nextInt(table.getRowSet().intSize() + 1), (RowSet)table.getRowSet(), random) : TstUtils.i(new long[0]);
        WritableRowSet keysToAdd = add ? TstUtils.newIndex(random.nextInt(size / 2 + 1), (RowSet)table.getRowSet(), random) : TstUtils.i(new long[0]);
        TstUtils.removeRows((Table)table, (RowSet)keysToRemove);
        for (ColumnInfo<?, ?> info : columnInfo) {
            info.remove((RowSet)keysToRemove);
        }
        WritableRowSet keysToModify = modify && table.getRowSet().size() > 0L ? TstUtils.selectSubIndexSet(random.nextInt((int)table.getRowSet().size()), (RowSet)table.getRowSet(), random) : TstUtils.i(new long[0]);
        ColumnHolder[] columnAdditions = new ColumnHolder[columnInfo.length];
        for (i = 0; i < columnAdditions.length; ++i) {
            columnAdditions[i] = columnInfo[i].generateUpdateColumnHolder((RowSet)keysToModify, random);
        }
        TstUtils.addToTable((Table)table, (RowSet)keysToModify, columnAdditions);
        for (i = 0; i < columnAdditions.length; ++i) {
            columnAdditions[i] = columnInfo[i].generateUpdateColumnHolder((RowSet)keysToAdd, random);
        }
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println();
        }
        TstUtils.addToTable((Table)table, (RowSet)keysToAdd, columnAdditions);
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println("Add: " + (RowSet)keysToAdd);
            System.out.println("Remove: " + (RowSet)keysToRemove);
            System.out.println("Modify: " + (RowSet)keysToModify);
            try {
                System.out.println("Updated Table: " + table.size());
                TableTools.showWithRowSet((Table)table, (long)100L, (String[])new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new RowSet[]{keysToAdd, keysToRemove, keysToModify};
    }

    public static void generateShiftAwareTableUpdates(SimulationProfile profile, int targetUpdateSize, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfo) {
        profile.validate();
        try (WritableRowSet rowSet = table.getRowSet().copy();){
            ColumnInfo[] mutableColumns = (ColumnInfo[])Arrays.stream(columnInfo).filter(ci -> !ci.immutable).toArray(ColumnInfo[]::new);
            boolean hasImmutableColumns = columnInfo.length > mutableColumns.length;
            TableUpdateImpl update = new TableUpdateImpl();
            if (rowSet.isNonempty()) {
                update.removed = TstUtils.selectSubIndexSet(Math.min(rowSet.intSize(), random.nextInt(targetUpdateSize)), (RowSet)rowSet, random);
                rowSet.remove(update.removed());
            } else {
                update.removed = TstUtils.i(new long[0]);
            }
            RowSetShiftData.Builder shiftBuilder = new RowSetShiftData.Builder();
            if (!hasImmutableColumns) {
                MutableLong lastDest = new MutableLong();
                BiConsumer<Long, Long> shiftConsumer = (first, last) -> {
                    long maxShift;
                    long minShift;
                    if (first < 0L || last < 0L || last < first) {
                        return;
                    }
                    long len = last - first + 1L;
                    if (shiftBuilder.nonempty()) {
                        minShift = lastDest.longValue() + 1L - first;
                        maxShift = Math.max(minShift, random.nextInt(100) < profile.SHIFT_LIMIT_50_PERCENT ? (len + 1L) / 2L : 2L * len);
                    } else {
                        maxShift = random.nextInt(100) < profile.SHIFT_LIMIT_50_PERCENT ? (len + 1L) / 2L : 2L * len;
                        minShift = -maxShift;
                    }
                    long shiftDelta = 0L;
                    while (shiftDelta == 0L) {
                        shiftDelta = Math.max(-first.longValue(), minShift + GenerateTableUpdates.nextLong(random, maxShift - minShift + 1L));
                    }
                    lastDest.setValue(last + shiftDelta);
                    shiftBuilder.shiftRange(first.longValue(), last.longValue(), shiftDelta);
                };
                int shiftStrategy = random.nextInt(100);
                if (shiftStrategy < profile.SHIFT_10_PERCENT_KEY_SPACE && rowSet.isNonempty()) {
                    long startKey = GenerateTableUpdates.nextLong(random, rowSet.lastRowKey() + 1L);
                    long lastKey = Math.min(startKey + (long)((double)rowSet.lastRowKey() * 0.1), rowSet.lastRowKey());
                    shiftConsumer.accept(startKey, lastKey);
                }
                if ((shiftStrategy -= profile.SHIFT_10_PERCENT_KEY_SPACE) >= 0 && shiftStrategy < profile.SHIFT_10_PERCENT_POS_SPACE && rowSet.isNonempty()) {
                    long startIdx = GenerateTableUpdates.nextLong(random, rowSet.size());
                    long lastIdx = Math.min(rowSet.size() - 1L, startIdx + rowSet.size() / 10L);
                    shiftConsumer.accept(rowSet.get(startIdx), rowSet.get(lastIdx));
                }
                if ((shiftStrategy -= profile.SHIFT_10_PERCENT_POS_SPACE) >= 0 && shiftStrategy < profile.SHIFT_AGGRESSIVELY && rowSet.isNonempty()) {
                    long currIdx = 0L;
                    while (currIdx < rowSet.size()) {
                        long startIdx = currIdx + GenerateTableUpdates.nextLong(random, rowSet.size() - currIdx);
                        long lastIdx = startIdx + (long)Math.sqrt(GenerateTableUpdates.nextLong(random, rowSet.size() - startIdx));
                        shiftConsumer.accept(rowSet.get(startIdx), rowSet.get(lastIdx));
                        currIdx = 1L + lastIdx + (long)Math.sqrt(GenerateTableUpdates.nextLong(random, rowSet.size() - lastIdx));
                    }
                }
                shiftStrategy -= profile.SHIFT_AGGRESSIVELY;
            }
            update.shifted = shiftBuilder.build();
            int preShiftIndexSize = rowSet.intSize();
            update.shifted().apply((start, end, delta) -> {
                long blatStart = delta < 0L ? start + delta : end;
                long blatEnd = delta < 0L ? start - 1L : end + delta;
                try (WritableRowSet blattedRows = rowSet.extract((RowSet)RowSetFactory.fromRange((long)blatStart, (long)blatEnd));){
                    update.removed().writableCast().insert((RowSet)blattedRows);
                }
            });
            int numRowsBlattedByShift = preShiftIndexSize - rowSet.intSize();
            update.shifted().apply(rowSet);
            update.modified = rowSet.isNonempty() ? TstUtils.selectSubIndexSet(Math.min(rowSet.intSize(), random.nextInt(targetUpdateSize * 2)), (RowSet)rowSet, random) : TstUtils.i(new long[0]);
            if (update.modified().isEmpty()) {
                update.modifiedColumnSet = ModifiedColumnSet.EMPTY;
            } else {
                ArrayList<String> modifiedColumns = new ArrayList<String>();
                update.modifiedColumnSet = table.getModifiedColumnSetForUpdates();
                update.modifiedColumnSet.clear();
                String mustModifyColumn = mutableColumns.length == 0 ? null : mutableColumns[random.nextInt((int)mutableColumns.length)].name;
                for (ColumnInfo<?, ?> ci2 : columnInfo) {
                    if (!ci2.name.equals(mustModifyColumn) && (ci2.immutable || random.nextInt(100) >= profile.MOD_ADDITIONAL_COLUMN)) continue;
                    modifiedColumns.add(ci2.name);
                }
                update.modifiedColumnSet().setAll(modifiedColumns.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY));
            }
            update.added = TstUtils.newIndex(numRowsBlattedByShift + random.nextInt(targetUpdateSize), (RowSet)rowSet, random);
            GenerateTableUpdates.generateTableUpdates((TableUpdate)update, random, table, columnInfo);
        }
    }

    public static void generateTableUpdates(TableUpdate update, Random random, QueryTable table, ColumnInfo<?, ?>[] columnInfo) {
        TrackingWritableRowSet rowSet = table.getRowSet().writableCast();
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println();
            System.out.println("TrackingWritableRowSet: " + (WritableRowSet)rowSet);
        }
        TstUtils.removeRows((Table)table, update.removed());
        for (ColumnInfo<?, ?> info : columnInfo) {
            info.remove(update.removed());
        }
        rowSet.remove(update.removed());
        update.shifted().apply((start, end, delta) -> {
            for (ColumnInfo info : columnInfo) {
                info.shift(start, end, delta);
            }
            for (ColumnSource column : table.getColumnSources()) {
                if (!(column instanceof TestColumnSource)) continue;
                TestColumnSource testSource = (TestColumnSource)column;
                testSource.shift(start, end, delta);
            }
        });
        update.shifted().apply((WritableRowSet)rowSet);
        ColumnHolder[] cModsOnly = new ColumnHolder[columnInfo.length];
        ColumnHolder[] cAddsOnly = new ColumnHolder[columnInfo.length];
        BitSet dirtyColumns = update.modifiedColumnSet().extractAsBitSet();
        for (int i = 0; i < columnInfo.length; ++i) {
            ColumnInfo<?, ?> ci = columnInfo[i];
            RowSet keys = dirtyColumns.get(i) ? update.modified() : TstUtils.i(new long[0]);
            cModsOnly[i] = ci.generateUpdateColumnHolder(keys, random);
            cAddsOnly[i] = ci.generateUpdateColumnHolder(update.added(), random);
        }
        TstUtils.addToTable((Table)table, update.added(), cAddsOnly);
        TstUtils.addToTable((Table)table, update.modified(), cModsOnly);
        rowSet.insert(update.added());
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println("Add: " + update.added());
            System.out.println("Remove: " + update.removed());
            System.out.println("Modify: " + update.modified());
            System.out.println("Shift: " + update.shifted());
            System.out.println("ModifiedColumnSet: " + update.modifiedColumnSet());
            try {
                System.out.println("Updated Table: " + table.size());
                TableTools.showWithRowSet((Table)table, (long)100L, (String[])new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        table.notifyListeners(update);
    }

    private static long nextLong(Random random, long bound) {
        long next;
        while ((next = Math.abs(random.nextLong())) < 0L) {
        }
        return next % bound;
    }

    public static class SimulationProfile {
        protected int SHIFT_10_PERCENT_KEY_SPACE = 10;
        protected int SHIFT_10_PERCENT_POS_SPACE = 30;
        protected int SHIFT_AGGRESSIVELY = 10;
        protected int SHIFT_LIMIT_50_PERCENT = 80;
        protected int MOD_ADDITIONAL_COLUMN = 50;

        void validate() {
            this.validateGroup(this.SHIFT_10_PERCENT_KEY_SPACE, this.SHIFT_10_PERCENT_POS_SPACE, this.SHIFT_AGGRESSIVELY);
            this.validateGroup(this.SHIFT_LIMIT_50_PERCENT);
            this.validateGroup(this.MOD_ADDITIONAL_COLUMN);
        }

        private void validateGroup(int ... opts) {
            int sum = 0;
            for (int opt : opts) {
                sum += opt;
                Assert.geqZero((int)opt, (String)"Simulation Profile Percentage");
            }
            Assert.leq((int)sum, (String)"Simulation Profile Group Percentage", (int)100, (String)"100%");
        }
    }
}

