/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.ShiftObliviousInstrumentedListenerAdapter;
import io.deephaven.engine.table.impl.util.ShiftObliviousUpdateCoalescer;
import io.deephaven.engine.testutil.ColumnInfo;
import io.deephaven.engine.testutil.ControlledUpdateGraph;
import io.deephaven.engine.testutil.EvalNuggetInterface;
import io.deephaven.engine.testutil.GenerateTableUpdates;
import io.deephaven.engine.testutil.TstUtils;
import io.deephaven.engine.testutil.testcase.RefreshingTableTestCase;
import io.deephaven.engine.util.TableDiff;
import io.deephaven.engine.util.TableTools;
import java.text.SimpleDateFormat;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class QueryTableTestBase
extends RefreshingTableTestCase {
    public final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    public final JoinIncrement leftStep = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(GenerateTableUpdates.NO_SHIFT_PROFILE, this.toString(), leftSize, random, leftTable, leftColumnInfo, en);
        }

        public String toString() {
            return "Left Step";
        }
    };
    public final JoinIncrement leftStepShift = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(this.toString(), leftSize, random, leftTable, leftColumnInfo, en);
        }

        public String toString() {
            return "Left Shift Step";
        }
    };
    protected final JoinIncrement rightStep = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(GenerateTableUpdates.NO_SHIFT_PROFILE, this.toString(), rightSize, random, rightTable, rightColumnInfo, en);
        }

        public String toString() {
            return "Right Step";
        }
    };
    public final JoinIncrement rightStepShift = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(this.toString(), rightSize, random, rightTable, rightColumnInfo, en);
        }

        public String toString() {
            return "Right Shift Step";
        }
    };
    public final JoinIncrement leftRightStep = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(GenerateTableUpdates.NO_SHIFT_PROFILE, this.toString(), leftSize, random, leftTable, leftColumnInfo, en);
            RefreshingTableTestCase.simulateShiftAwareStep(GenerateTableUpdates.NO_SHIFT_PROFILE, this.toString(), rightSize, random, rightTable, rightColumnInfo, en);
        }

        public String toString() {
            return "Left and Right Step";
        }
    };
    public final JoinIncrement leftRightStepShift = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            RefreshingTableTestCase.simulateShiftAwareStep(this.toString(), leftSize, random, leftTable, leftColumnInfo, en);
            RefreshingTableTestCase.simulateShiftAwareStep(this.toString(), rightSize, random, rightTable, rightColumnInfo, en);
        }

        public String toString() {
            return "Left and Right Shift Step";
        }
    };
    public final JoinIncrement leftRightConcurrentStepShift = new JoinIncrement(){

        @Override
        public void step(int leftSize, int rightSize, QueryTable leftTable, QueryTable rightTable, ColumnInfo<?, ?>[] leftColumnInfo, ColumnInfo<?, ?>[] rightColumnInfo, EvalNuggetInterface[] en, Random random) {
            ControlledUpdateGraph updateGraph = (ControlledUpdateGraph)ExecutionContext.getContext().getUpdateGraph().cast();
            updateGraph.runWithinUnitTestCycle(() -> {
                GenerateTableUpdates.generateShiftAwareTableUpdates(GenerateTableUpdates.DEFAULT_PROFILE, leftSize, random, leftTable, leftColumnInfo);
                GenerateTableUpdates.generateShiftAwareTableUpdates(GenerateTableUpdates.DEFAULT_PROFILE, rightSize, random, rightTable, rightColumnInfo);
            });
        }

        public String toString() {
            return "Left and Right Concurrent Shift Step";
        }
    };
    public final JoinIncrement[] joinIncrementors = new JoinIncrement[]{this.leftStep, this.rightStep, this.leftRightStep};
    protected final JoinIncrement[] joinIncrementorsShift = new JoinIncrement[]{this.leftStep, this.rightStep, this.leftRightStep, this.leftStepShift, this.rightStepShift, this.leftRightStepShift, this.leftRightConcurrentStepShift};
    public RowSet added;
    public RowSet removed;
    public RowSet modified;

    public static int[] intColumn(Table table, String column) {
        int[] result = new int[table.intSize()];
        MutableInt pos = new MutableInt();
        table.integerColumnIterator(column).forEachRemaining(value -> {
            result[pos.getValue().intValue()] = value;
            pos.increment();
        });
        return result;
    }

    public ListenerWithGlobals newListenerWithGlobals(Table source) {
        return new ListenerWithGlobals(source);
    }

    public class ListenerWithGlobals
    extends ShiftObliviousInstrumentedListenerAdapter {
        int count;

        protected ListenerWithGlobals(Table source) {
            super(source, false);
            this.reset();
        }

        public int getCount() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
            QueryTableTestBase.this.added = null;
            QueryTableTestBase.this.modified = null;
            QueryTableTestBase.this.removed = null;
        }

        public void onUpdate(RowSet added, RowSet removed, RowSet modified) {
            QueryTableTestBase.this.added = added.copy();
            QueryTableTestBase.this.removed = removed.copy();
            QueryTableTestBase.this.modified = modified.copy();
            ++this.count;
        }
    }

    protected static class CoalescingListener
    extends ShiftObliviousInstrumentedListenerAdapter {
        RowSet lastAdded;
        RowSet lastModified;
        RowSet lastRemoved;
        public ShiftObliviousUpdateCoalescer indexUpdateCoalescer = new ShiftObliviousUpdateCoalescer();
        int count;

        public CoalescingListener(Table source) {
            super(source, false);
        }

        public int getCount() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
            this.lastAdded = null;
            this.lastRemoved = null;
            this.lastModified = null;
            this.indexUpdateCoalescer.reset();
        }

        public void onUpdate(RowSet added, RowSet removed, RowSet modified) {
            if (this.lastAdded != null) {
                this.lastAdded.close();
            }
            this.lastAdded = added.copy();
            if (this.lastRemoved != null) {
                this.lastRemoved.close();
            }
            this.lastRemoved = removed.copy();
            if (this.lastModified != null) {
                this.lastModified.close();
            }
            this.lastModified = modified.copy();
            this.indexUpdateCoalescer.update(this.lastAdded, this.lastRemoved, this.lastModified);
            ++this.count;
        }
    }

    public static class TableComparator
    implements EvalNuggetInterface {
        private final Table t1;
        private final Table t2;
        private String t1Name;
        private String t2Name;

        public TableComparator(Table t1, Table t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public TableComparator(Table t1, String t1Name, Table t2, String t2Name) {
            this.t1 = t1;
            this.t2 = t2;
            this.t1Name = t1Name;
            this.t2Name = t2Name;
            this.validate("Initial construction.");
        }

        @Override
        public void validate(String msg) {
            TstUtils.assertTableEquals(msg, this.t2, this.t1, TableDiff.DiffItems.DoublesExact);
        }

        @Override
        public void show() {
            System.out.println((Object)(this.t1Name != null ? this.t1Name : this.t1));
            TableTools.showWithRowSet((Table)this.t1, (String[])new String[0]);
            System.out.println((Object)(this.t2Name != null ? this.t2Name : this.t2));
            TableTools.showWithRowSet((Table)this.t2, (String[])new String[0]);
        }
    }

    public static interface JoinIncrement {
        public void step(int var1, int var2, QueryTable var3, QueryTable var4, ColumnInfo<?, ?>[] var5, ColumnInfo<?, ?>[] var6, EvalNuggetInterface[] var7, Random var8);
    }
}

