/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.base.Pair;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.ElementSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.NoSuchColumnException;
import io.deephaven.engine.table.impl.PrevColumnSource;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.select.Formula;
import io.deephaven.engine.table.impl.sources.RedirectedColumnSource;
import io.deephaven.engine.table.impl.sources.ViewColumnSource;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.table.impl.util.LongColumnSourceRowRedirection;
import io.deephaven.engine.table.impl.util.RowRedirection;
import io.deephaven.engine.testutil.ColumnInfo;
import io.deephaven.engine.testutil.EvalNuggetInterface;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import io.deephaven.engine.testutil.rowset.RowSetTstUtils;
import io.deephaven.engine.testutil.sources.ByteTestSource;
import io.deephaven.engine.testutil.sources.CharTestSource;
import io.deephaven.engine.testutil.sources.DoubleTestSource;
import io.deephaven.engine.testutil.sources.FloatTestSource;
import io.deephaven.engine.testutil.sources.ImmutableByteTestSource;
import io.deephaven.engine.testutil.sources.ImmutableCharTestSource;
import io.deephaven.engine.testutil.sources.ImmutableColumnHolder;
import io.deephaven.engine.testutil.sources.ImmutableDoubleTestSource;
import io.deephaven.engine.testutil.sources.ImmutableFloatTestSource;
import io.deephaven.engine.testutil.sources.ImmutableInstantTestSource;
import io.deephaven.engine.testutil.sources.ImmutableIntTestSource;
import io.deephaven.engine.testutil.sources.ImmutableLongTestSource;
import io.deephaven.engine.testutil.sources.ImmutableObjectTestSource;
import io.deephaven.engine.testutil.sources.ImmutableShortTestSource;
import io.deephaven.engine.testutil.sources.InstantTestSource;
import io.deephaven.engine.testutil.sources.IntTestSource;
import io.deephaven.engine.testutil.sources.LongTestSource;
import io.deephaven.engine.testutil.sources.ObjectTestSource;
import io.deephaven.engine.testutil.sources.ShortTestSource;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.testutil.testcase.RefreshingTableTestCase;
import io.deephaven.engine.util.TableDiff;
import io.deephaven.engine.util.TableTools;
import io.deephaven.stringset.HashStringSet;
import io.deephaven.stringset.StringSet;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.type.TypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

public class TstUtils {
    public static boolean SHORT_TESTS = Configuration.getInstance().getBooleanForClassWithDefault(TstUtils.class, "shortTests", false);

    public static int scaleToDesiredTestLength(int maxIter) {
        if (!SHORT_TESTS) {
            return maxIter;
        }
        double shortTestFactor = 0.2;
        return (int)Math.ceil((double)maxIter * 0.2);
    }

    public static <T> ColumnHolder<T> columnHolderForChunk(String name, Class<T> type, Class<?> componentType, Chunk<Values> chunkData) {
        return ColumnHolder.makeForChunk((String)name, type, componentType, (boolean)false, chunkData);
    }

    public static <T> ColumnHolder<T> groupedColumnHolderForChunk(String name, Class<T> type, Class<?> componentType, Chunk<Values> chunkData) {
        return ColumnHolder.makeForChunk((String)name, type, componentType, (boolean)true, chunkData);
    }

    public static WritableRowSet i(long ... keys) {
        return RowSetFactory.fromKeys((long[])keys);
    }

    public static void addToTable(Table table, RowSet rowSet, ColumnHolder<?> ... columnHolders) {
        if (rowSet.isEmpty()) {
            return;
        }
        Require.requirement((boolean)table.isRefreshing(), (String)"table.isRefreshing()");
        HashSet<String> usedNames = new HashSet<String>();
        for (ColumnHolder<?> columnHolder : columnHolders) {
            if (columnHolder == null) continue;
            if (!usedNames.add(columnHolder.name)) {
                throw new IllegalStateException("Added to the same column twice!");
            }
            ColumnSource columnSource = table.getColumnSource(columnHolder.name);
            if (columnHolder.size() == 0) continue;
            if (rowSet.size() != (long)columnHolder.size()) {
                throw new IllegalArgumentException(columnHolder.name + ": Invalid data addition: rowSet=" + rowSet.size() + ", arraySize=" + columnHolder.size());
            }
            if (!(columnSource instanceof InstantTestSource && columnHolder.dataType == Long.TYPE || columnSource.getType() == Boolean.class && columnHolder.dataType == Boolean.class || columnSource.getType() == TypeUtils.getUnboxedTypeIfBoxed((Class)columnHolder.dataType))) {
                throw new UnsupportedOperationException(columnHolder.name + ": Adding invalid type: source.getType()=" + columnSource.getType() + ", columnHolder=" + columnHolder.dataType);
            }
            if (columnSource instanceof TestColumnSource) {
                TestColumnSource testSource = (TestColumnSource)columnSource;
                testSource.add(rowSet, (Chunk<Values>)columnHolder.getChunk());
                continue;
            }
            throw new IllegalStateException("Can not add to tables with unknown column sources: " + columnSource.getClass());
        }
        NoSuchColumnException.throwIf(usedNames, (Collection)table.getDefinition().getColumnNameSet(), (String)"Not all columns were populated, missing [%s], available [%s]", (NoSuchColumnException.Type[])new NoSuchColumnException.Type[]{NoSuchColumnException.Type.MISSING, NoSuchColumnException.Type.AVAILABLE});
        table.getRowSet().writableCast().insert(rowSet);
        if (table.isFlat()) {
            Assert.assertion((boolean)table.getRowSet().isFlat(), (String)"table.build().isFlat()", (Object)table.getRowSet(), (String)"table.build()", (Object)rowSet, (String)"rowSet");
        }
    }

    public static void removeRows(Table table, RowSet rowSet) {
        Require.requirement((boolean)table.isRefreshing(), (String)"table.isRefreshing()");
        table.getRowSet().writableCast().remove(rowSet);
        if (table.isFlat()) {
            Assert.assertion((boolean)table.getRowSet().isFlat(), (String)"table.build().isFlat()", (Object)table.getRowSet(), (String)"table.build()", (Object)rowSet, (String)"rowSet");
        }
        for (ColumnSource columnSource : table.getColumnSources()) {
            if (columnSource instanceof TestColumnSource) {
                TestColumnSource testColumnSource = (TestColumnSource)columnSource;
                if (columnSource.isImmutable()) continue;
                testColumnSource.remove(rowSet);
                continue;
            }
            throw new IllegalStateException("Not a test column source: " + columnSource);
        }
    }

    @SafeVarargs
    public static <T> ColumnHolder<T> colGrouped(String name, T ... data) {
        return ColumnHolder.createColumnHolder((String)name, (boolean)true, (Object[])data);
    }

    public static ColumnHolder<String> getRandomStringCol(String colName, int size, Random random) {
        Object[] data = new String[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = Long.toString(random.nextLong(), 35);
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<String[]> getRandomStringArrayCol(String colName, int size, Random random, int maxSz) {
        String[][] data = new String[size][];
        for (int i = 0; i < data.length; ++i) {
            String[] v = new String[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = Long.toString(random.nextLong(), 35);
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<StringSet> getRandomStringSetCol(String colName, int size, Random random, int maxSz) {
        Object[] data = new StringSet[size];
        for (int i = 0; i < data.length; ++i) {
            String[] v = new String[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = Long.toString(random.nextLong(), 35);
            }
            data[i] = new HashStringSet(Arrays.asList(v));
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<Integer> getRandomIntCol(String colName, int size, Random random) {
        Object[] data = new Integer[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextInt(1000);
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<Double> getRandomDoubleCol(String colName, int size, Random random) {
        Object[] data = new Double[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextDouble();
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<Float> getRandomFloatCol(String colName, int size, Random random) {
        float[] data = new float[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextFloat();
        }
        return new ColumnHolder(colName, false, data);
    }

    public static ColumnHolder<Short> getRandomShortCol(String colName, int size, Random random) {
        short[] data = new short[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (short)random.nextInt(Short.MAX_VALUE);
        }
        return new ColumnHolder(colName, false, data);
    }

    public static ColumnHolder<Long> getRandomLongCol(String colName, int size, Random random) {
        long[] data = new long[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextLong();
        }
        return new ColumnHolder(colName, false, data);
    }

    public static ColumnHolder<Boolean> getRandomBooleanCol(String colName, int size, Random random) {
        Object[] data = new Boolean[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextBoolean();
        }
        return ColumnHolder.createColumnHolder((String)colName, (boolean)false, (Object[])data);
    }

    public static ColumnHolder<Character> getRandomCharCol(String colName, int size, Random random) {
        char[] data = new char[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)random.nextInt();
        }
        return new ColumnHolder(colName, false, data);
    }

    public static ColumnHolder<Byte> getRandomByteCol(String colName, int size, Random random) {
        byte[] data = new byte[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)random.nextInt();
        }
        return new ColumnHolder(colName, false, data);
    }

    public static ColumnHolder<byte[]> getRandomByteArrayCol(String colName, int size, Random random, int maxSz) {
        byte[][] data = new byte[size][];
        for (int i = 0; i < size; ++i) {
            byte[] b = new byte[random.nextInt(maxSz)];
            random.nextBytes(b);
            data[i] = b;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<Boolean[]> getRandomBooleanArrayCol(String colName, int size, Random random, int maxSz) {
        Boolean[][] data = new Boolean[size][];
        for (int i = 0; i < size; ++i) {
            Boolean[] v = new Boolean[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = random.nextBoolean();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<int[]> getRandomIntArrayCol(String colName, int size, Random random, int maxSz) {
        int[][] data = new int[size][];
        for (int i = 0; i < size; ++i) {
            int[] v = new int[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = random.nextInt();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<long[]> getRandomLongArrayCol(String colName, int size, Random random, int maxSz) {
        long[][] data = new long[size][];
        for (int i = 0; i < size; ++i) {
            long[] v = new long[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = random.nextLong();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<short[]> getRandomShortArrayCol(String colName, int size, Random random, int maxSz) {
        short[][] data = new short[size][];
        for (int i = 0; i < size; ++i) {
            short[] v = new short[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = (short)random.nextInt();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<double[]> getRandomDoubleArrayCol(String colName, int size, Random random, int maxSz) {
        double[][] data = new double[size][];
        for (int i = 0; i < size; ++i) {
            double[] v = new double[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = random.nextDouble();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<float[]> getRandomFloatArrayCol(String colName, int size, Random random, int maxSz) {
        float[][] data = new float[size][];
        for (int i = 0; i < size; ++i) {
            float[] v = new float[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = random.nextFloat();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<char[]> getRandomCharArrayCol(String colName, int size, Random random, int maxSz) {
        char[][] data = new char[size][];
        for (int i = 0; i < size; ++i) {
            char[] v = new char[random.nextInt(maxSz)];
            for (int j = 0; j < v.length; ++j) {
                v[j] = (char)random.nextInt();
            }
            data[i] = v;
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<BigDecimal> getRandomBigDecimalCol(String colName, int size, Random random) {
        Object[] data = new BigDecimal[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = BigDecimal.valueOf(random.nextDouble());
        }
        return TableTools.col((String)colName, (Object[])data);
    }

    public static ColumnHolder<Instant> getRandomInstantCol(String colName, int size, Random random) {
        Object[] data = new Instant[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DateTimeUtils.epochAutoToInstant((long)random.nextLong());
        }
        return ColumnHolder.createColumnHolder((String)colName, (boolean)false, (Object[])data);
    }

    public static void validate(EvalNuggetInterface[] en) {
        TstUtils.validate("", en);
    }

    public static void validate(String ctxt, EvalNuggetInterface[] en) {
        if (RefreshingTableTestCase.printTableUpdates) {
            System.out.println();
            System.out.println("================ NEXT ITERATION ================");
        }
        for (int i = 0; i < en.length; ++i) {
            try (SafeCloseable ignored = LivenessScopeStack.open();){
                if (RefreshingTableTestCase.printTableUpdates) {
                    if (i != 0) {
                        System.out.println("================ NUGGET (" + i + ") ================");
                    }
                    try {
                        en[i].show();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.out.println();
                }
                en[i].validate(ctxt + " en_i = " + i);
            }
            en[i].releaseRecomputed();
        }
    }

    static WritableRowSet getInitialIndex(int size, Random random) {
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        long firstKey = 10L;
        for (int i = 0; i < size; ++i) {
            firstKey = firstKey + 1L + (long)random.nextInt(3);
            builder.appendKey(firstKey);
        }
        return builder.build();
    }

    public static WritableRowSet selectSubIndexSet(int size, RowSet sourceRowSet, Random random) {
        Assert.assertion(((long)size <= sourceRowSet.size() ? 1 : 0) != 0, (String)"size <= sourceRowSet.size()", (Object)size, (String)"size", (Object)sourceRowSet, (String)"sourceRowSet.size()");
        Integer[] positions = new Integer[(int)sourceRowSet.size()];
        for (int ii = 0; ii < positions.length; ++ii) {
            positions[ii] = ii;
        }
        Collections.shuffle(Arrays.asList(positions), random);
        RowSetBuilderRandom resultBuilder = RowSetFactory.builderRandom();
        for (int ii = 0; ii < size; ++ii) {
            resultBuilder.addKey(sourceRowSet.get((long)positions[ii].intValue()));
        }
        return resultBuilder.build();
    }

    public static RowSet newIndex(int targetSize, RowSet sourceRowSet, Random random) {
        long maxKey = sourceRowSet.size() == 0L ? 0L : sourceRowSet.lastRowKey();
        long emptySlots = maxKey - sourceRowSet.size();
        int slotsToFill = Math.min(Math.min((int)(Math.max(0.0, random.nextGaussian() / 0.1 + 0.9) * (double)emptySlots), targetSize), (int)emptySlots);
        WritableRowSet fillIn = TstUtils.selectSubIndexSet(slotsToFill, (RowSet)RowSetFactory.fromRange((long)0L, (long)maxKey).minus(sourceRowSet), random);
        int endSlots = targetSize - (int)fillIn.size();
        double density = random.nextGaussian() / 0.25 + 0.5;
        density = Math.max(density, 0.1);
        density = Math.min(density, 1.0);
        long rangeSize = (long)(1.0 / density * (double)endSlots);
        WritableRowSet expansion = TstUtils.selectSubIndexSet(endSlots, (RowSet)RowSetFactory.fromRange((long)(maxKey + 1L), (long)(maxKey + rangeSize + 1L)), random);
        fillIn.insert((RowSet)expansion);
        Assert.assertion((fillIn.size() == (long)targetSize ? 1 : 0) != 0, (String)"fillIn.size() == targetSize", (Object)fillIn.size(), (String)"fillIn.size()", (Object)targetSize, (String)"targetSize", (Object)endSlots, (String)"endSlots", (Object)slotsToFill, (String)"slotsToFill");
        return fillIn;
    }

    public static ColumnInfo<?, ?>[] initColumnInfos(String[] names, TestDataGenerator<?, ?> ... generators) {
        if (names.length != generators.length) {
            throw new IllegalArgumentException("names and generator lengths mismatch: " + names.length + " != " + generators.length);
        }
        ColumnInfo[] result = new ColumnInfo[names.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ColumnInfo(generators[i], names[i], new ColumnInfo.ColAttributes[0]);
        }
        return result;
    }

    public static ColumnInfo<?, ?>[] initColumnInfos(String[] names, ColumnInfo.ColAttributes[] attributes, TestDataGenerator<?, ?> ... generators) {
        if (names.length != generators.length) {
            throw new IllegalArgumentException("names and generator lengths mismatch: " + names.length + " != " + generators.length);
        }
        ColumnInfo[] result = new ColumnInfo[names.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ColumnInfo(generators[i], names[i], attributes);
        }
        return result;
    }

    public static ColumnInfo<?, ?>[] initColumnInfos(String[] names, List<List<ColumnInfo.ColAttributes>> attributes, TestDataGenerator<?, ?> ... generators) {
        if (names.length != generators.length) {
            throw new IllegalArgumentException("names and generator lengths mismatch: " + names.length + " != " + generators.length);
        }
        ColumnInfo[] result = new ColumnInfo[names.length];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = new ColumnInfo(generators[ii], names[ii], attributes.get(ii).toArray(ColumnInfo.ZERO_LENGTH_COLUMN_ATTRIBUTES_ARRAY));
        }
        return result;
    }

    public static QueryTable getTable(int size, Random random, ColumnInfo<?, ?>[] columnInfos) {
        return TstUtils.getTable(true, size, random, columnInfos);
    }

    public static QueryTable getTable(boolean refreshing, int size, Random random, ColumnInfo<?, ?>[] columnInfos) {
        TrackingWritableRowSet rowSet = TstUtils.getInitialIndex(size, random).toTracking();
        ColumnHolder[] sources = new ColumnHolder[columnInfos.length];
        for (int i = 0; i < columnInfos.length; ++i) {
            sources[i] = columnInfos[i].generateInitialColumn((RowSet)rowSet, random);
        }
        if (refreshing) {
            return TstUtils.testRefreshingTable((TrackingRowSet)rowSet, sources);
        }
        return TstUtils.testTable((TrackingRowSet)rowSet, sources);
    }

    public static QueryTable testTable(ColumnHolder<?> ... columnHolders) {
        WritableRowSet rowSet = RowSetFactory.flat((long)columnHolders[0].size());
        return TstUtils.testTable((TrackingRowSet)rowSet.toTracking(), columnHolders);
    }

    public static QueryTable testTable(TrackingRowSet rowSet, ColumnHolder<?> ... columnHolders) {
        Map<String, ColumnSource<?>> columns = TstUtils.getColumnSourcesFromHolders(rowSet, columnHolders);
        QueryTable queryTable = new QueryTable(rowSet, columns);
        queryTable.setAttribute("TestSource", (Object)true);
        return queryTable;
    }

    @NotNull
    private static Map<String, ColumnSource<?>> getColumnSourcesFromHolders(TrackingRowSet rowSet, ColumnHolder<?>[] columnHolders) {
        LinkedHashMap columns = new LinkedHashMap();
        for (ColumnHolder<?> columnHolder : columnHolders) {
            columns.put(columnHolder.name, TstUtils.getTestColumnSource((RowSet)rowSet, columnHolder));
        }
        return columns;
    }

    public static QueryTable testRefreshingTable(TrackingRowSet rowSet, ColumnHolder<?> ... columnHolders) {
        QueryTable queryTable = TstUtils.testTable(rowSet, columnHolders);
        queryTable.setRefreshing(true);
        queryTable.setAttribute("TestSource", (Object)true);
        return queryTable;
    }

    public static QueryTable testFlatRefreshingTable(TrackingRowSet rowSet, ColumnHolder<?> ... columnHolders) {
        Assert.assertion((boolean)rowSet.isFlat(), (String)"rowSet.isFlat()", (Object)rowSet, (String)"rowSet");
        return new QueryTable(rowSet, TstUtils.getColumnSourcesFromHolders(rowSet, columnHolders)){
            {
                this.setRefreshing(true);
                this.setFlat();
            }
        };
    }

    public static QueryTable testRefreshingTable(ColumnHolder<?> ... columnHolders) {
        QueryTable queryTable = TstUtils.testTable(columnHolders);
        queryTable.setRefreshing(true);
        return queryTable;
    }

    public static ColumnSource<?> getTestColumnSource(RowSet rowSet, ColumnHolder<?> columnHolder) {
        return TstUtils.getTestColumnSourceFromChunk(rowSet, columnHolder, (Chunk<Values>)columnHolder.getChunk());
    }

    private static <T> ColumnSource<T> getTestColumnSourceFromChunk(RowSet rowSet, ColumnHolder<T> columnHolder, Chunk<Values> chunkData) {
        Class unboxedType;
        AbstractColumnSource result = columnHolder instanceof ImmutableColumnHolder ? ((unboxedType = TypeUtils.getUnboxedTypeIfBoxed((Class)columnHolder.dataType)) == Character.TYPE ? new ImmutableCharTestSource(rowSet, chunkData) : (unboxedType == Byte.TYPE ? new ImmutableByteTestSource(rowSet, chunkData) : (unboxedType == Short.TYPE ? new ImmutableShortTestSource(rowSet, chunkData) : (unboxedType == Integer.TYPE ? new ImmutableIntTestSource(rowSet, chunkData) : (unboxedType == Long.TYPE ? new ImmutableLongTestSource(rowSet, chunkData) : (unboxedType == Float.TYPE ? new ImmutableFloatTestSource(rowSet, chunkData) : (unboxedType == Double.TYPE ? new ImmutableDoubleTestSource(rowSet, chunkData) : (unboxedType == Instant.class ? new ImmutableInstantTestSource(rowSet, chunkData) : new ImmutableObjectTestSource(columnHolder.dataType, rowSet, chunkData))))))))) : ((unboxedType = TypeUtils.getUnboxedTypeIfBoxed((Class)columnHolder.dataType)) == Character.TYPE ? new CharTestSource(rowSet, chunkData) : (unboxedType == Byte.TYPE ? new ByteTestSource(rowSet, chunkData) : (unboxedType == Short.TYPE ? new ShortTestSource(rowSet, chunkData) : (unboxedType == Integer.TYPE ? new IntTestSource(rowSet, chunkData) : (unboxedType == Long.TYPE ? new LongTestSource(rowSet, chunkData) : (unboxedType == Float.TYPE ? new FloatTestSource(rowSet, chunkData) : (unboxedType == Double.TYPE ? new DoubleTestSource(rowSet, chunkData) : (unboxedType == Instant.class ? new InstantTestSource(rowSet, chunkData) : new ObjectTestSource(columnHolder.dataType, rowSet, chunkData)))))))));
        if (columnHolder.grouped) {
            result.setGroupToRange(result.getValuesMapping(rowSet));
        }
        return result;
    }

    public static Table prevTableColumnSources(Table table) {
        TrackingWritableRowSet rowSet = table.getRowSet().copyPrev().toTracking();
        LinkedHashMap columnSourceMap = new LinkedHashMap();
        table.getColumnSourceMap().forEach((k, cs) -> columnSourceMap.put(k, new PrevColumnSource(cs)));
        return new QueryTable((TrackingRowSet)rowSet, columnSourceMap);
    }

    public static Table prevTable(Table table) {
        WritableRowSet rowSet = table.getRowSet().copyPrev();
        ArrayList<ColumnHolder> cols = new ArrayList<ColumnHolder>();
        for (Map.Entry mapEntry : table.getColumnSourceMap().entrySet()) {
            Object value;
            String name = (String)mapEntry.getKey();
            ColumnSource columnSource = (ColumnSource)mapEntry.getValue();
            ArrayList<Object> data = new ArrayList<Object>();
            RowSet.Iterator it = rowSet.iterator();
            while (it.hasNext()) {
                long key = it.nextLong();
                Object item = columnSource.getPrev(key);
                data.add(item);
            }
            if (columnSource.getType() == Integer.TYPE) {
                cols.add(new ColumnHolder(name, false, data.stream().mapToInt(x -> x == null ? Integer.MIN_VALUE : (Integer)x).toArray()));
                continue;
            }
            if (columnSource.getType() == Long.TYPE) {
                cols.add(new ColumnHolder(name, false, data.stream().mapToLong(x -> x == null ? Long.MIN_VALUE : (Long)x).toArray()));
                continue;
            }
            if (columnSource.getType() == Boolean.TYPE) {
                cols.add(ColumnHolder.createColumnHolder((String)name, (boolean)false, (Object[])((Boolean[])data.stream().map(x -> (Boolean)x).toArray(Boolean[]::new))));
                continue;
            }
            if (columnSource.getType() == String.class) {
                cols.add(ColumnHolder.createColumnHolder((String)name, (boolean)false, (Object[])((String[])data.stream().map(x -> (String)x).toArray(String[]::new))));
                continue;
            }
            if (columnSource.getType() == Double.TYPE) {
                cols.add(new ColumnHolder(name, false, data.stream().mapToDouble(x -> x == null ? -1.7976931348623157E308 : (Double)x).toArray()));
                continue;
            }
            if (columnSource.getType() == Float.TYPE) {
                float[] floatArray = new float[data.size()];
                for (int ii = 0; ii < data.size(); ++ii) {
                    value = data.get(ii);
                    floatArray[ii] = value == null ? -3.4028235E38f : ((Float)value).floatValue();
                }
                cols.add(new ColumnHolder(name, false, floatArray));
                continue;
            }
            if (columnSource.getType() == Character.TYPE) {
                char[] charArray = new char[data.size()];
                for (int ii = 0; ii < data.size(); ++ii) {
                    value = data.get(ii);
                    charArray[ii] = value == null ? 65535 : (int)((Character)value).charValue();
                }
                cols.add(new ColumnHolder(name, false, charArray));
                continue;
            }
            if (columnSource.getType() == Byte.TYPE) {
                byte[] byteArray = new byte[data.size()];
                for (int ii = 0; ii < data.size(); ++ii) {
                    value = data.get(ii);
                    byteArray[ii] = value == null ? -128 : (int)((Byte)value).byteValue();
                }
                cols.add(new ColumnHolder(name, false, byteArray));
                continue;
            }
            if (columnSource.getType() == Short.TYPE) {
                short[] shortArray = new short[data.size()];
                for (int ii = 0; ii < data.size(); ++ii) {
                    value = data.get(ii);
                    shortArray[ii] = value == null ? Short.MIN_VALUE : (int)((Short)value).shortValue();
                }
                cols.add(new ColumnHolder(name, false, shortArray));
                continue;
            }
            cols.add(new ColumnHolder(name, columnSource.getType(), columnSource.getComponentType(), false, data.toArray((Object[])Array.newInstance(columnSource.getType(), data.size()))));
        }
        return TableTools.newTable((ColumnHolder[])cols.toArray(ColumnHolder.ZERO_LENGTH_COLUMN_HOLDER_ARRAY));
    }

    public static long getRandom(Random random, int bits) {
        long value = random.nextLong();
        return bits >= 64 ? value : (1L << bits) - 1L & value;
    }

    public static void assertRowSetEquals(@NotNull RowSet expected, @NotNull RowSet actual) {
        try {
            TestCase.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionFailedError error) {
            System.err.println("TrackingWritableRowSet equality check failed:\n\texpected: " + expected + "\n\tactual: " + actual + "\n\terror: " + error);
            throw error;
        }
    }

    public static void assertTableEquals(@NotNull Table expected, @NotNull Table actual, TableDiff.DiffItems ... itemsToSkip) {
        TstUtils.assertTableEquals("", expected, actual, itemsToSkip);
    }

    public static void assertEqualsByElements(Table actual, Table expected) {
        Map mapActual = actual.getColumnSourceMap();
        Map mapExpected = expected.getColumnSourceMap();
        Assertions.assertThat(mapActual.keySet()).containsExactlyInAnyOrderElementsOf(mapExpected.keySet());
        for (String key : mapActual.keySet()) {
            ColumnSource srcActual = (ColumnSource)mapActual.get(key);
            ColumnSource srcExpected = (ColumnSource)mapExpected.get(key);
            TstUtils.assertEquals((RowSet)actual.getRowSet(), srcActual, (RowSet)expected.getRowSet(), srcExpected);
        }
    }

    public static <T> void assertEquals(RowSet rowsActual, ElementSource<T> srcActual, RowSet rowsExpected, ElementSource<T> srcExpected) {
        Assertions.assertThat((long)rowsActual.size()).isEqualTo(rowsExpected.size());
        try (RowSet.Iterator itActual = rowsActual.iterator();
             RowSet.Iterator itExpected = rowsExpected.iterator();){
            while (itActual.hasNext()) {
                if (!itExpected.hasNext()) {
                    throw new IllegalStateException();
                }
                Assertions.assertThat((Object)srcActual.get(itActual.nextLong())).isEqualTo(srcExpected.get(itExpected.nextLong()));
            }
            if (itExpected.hasNext()) {
                throw new IllegalStateException();
            }
        }
    }

    public static Table subset(Table input, int dutyOn, int dutyOff) {
        return input.getSubTable((TrackingRowSet)RowSetTstUtils.subset((RowSet)input.getRowSet(), (int)dutyOn, (int)dutyOff).toTracking());
    }

    public static void assertTableEquals(String context, @NotNull Table expected, @NotNull Table actual, TableDiff.DiffItems ... itemsToSkip) {
        if (itemsToSkip.length > 0) {
            TstUtils.assertTableEquals(context, expected, actual, EnumSet.of(itemsToSkip[0], itemsToSkip));
        } else {
            TstUtils.assertTableEquals(context, expected, actual, EnumSet.noneOf(TableDiff.DiffItems.class));
        }
    }

    public static void assertTableEquals(String context, @NotNull Table expected, @NotNull Table actual, EnumSet<TableDiff.DiffItems> itemsToSkip) {
        Pair diffPair = TableTools.diffPair((Table)actual, (Table)expected, (long)10L, itemsToSkip);
        if (((String)diffPair.getFirst()).equals("")) {
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                long firstRow = Math.max(0L, (Long)diffPair.getSecond() - 5L);
                long lastRow = Math.max(10L, (Long)diffPair.getSecond() + 5L);
                try (PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);){
                    TableTools.showWithRowSet((Table)expected, (long)firstRow, (long)lastRow, (PrintStream)ps, (String[])new String[0]);
                }
                String expectedString = baos.toString();
                baos.reset();
                try (PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);){
                    TableTools.showWithRowSet((Table)actual, (long)firstRow, (long)lastRow, (PrintStream)ps, (String[])new String[0]);
                }
                String actualString = baos.toString();
                throw new ComparisonFailure(context + "\n" + (String)diffPair.getFirst(), expectedString, actualString);
            }
            catch (Throwable throwable) {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void findMinimalTestCase(RefreshingTableTestCase test, int initialSeed, int maxSeed, int initialSteps, BiConsumer<Integer, MutableInt> runner) {
        boolean origPrintTableUpdates = RefreshingTableTestCase.printTableUpdates;
        RefreshingTableTestCase.printTableUpdates = false;
        int bestSeed = initialSeed;
        int bestSteps = initialSteps;
        boolean failed = false;
        MutableInt maxSteps = new MutableInt(initialSteps);
        for (int seed = initialSeed; seed < maxSeed; ++seed) {
            if (maxSteps.intValue() <= 0) {
                System.out.println("Best Run: bestSeed=" + bestSeed + " bestSteps=" + bestSteps);
                return;
            }
            System.out.println("Running: seed=" + seed + " numSteps=" + maxSteps.intValue() + " bestSeed=" + bestSeed + " bestSteps=" + bestSteps);
            if (seed != initialSeed) {
                try {
                    test.tearDown();
                }
                catch (Error | Exception e) {
                    System.out.println("Error on test.tearDown():");
                    e.printStackTrace();
                }
                try {
                    test.setUp();
                }
                catch (Error | Exception e) {
                    System.out.println("Error on test.setUp():");
                    e.printStackTrace();
                }
            }
            try {
                runner.accept(seed, maxSteps);
                continue;
            }
            catch (Error | Exception e) {
                failed = true;
                bestSeed = seed;
                bestSteps = maxSteps.intValue() + 1;
                e.printStackTrace();
                System.out.println("Candidate: seed=" + seed + " numSteps=" + (maxSteps.intValue() + 1));
            }
        }
        RefreshingTableTestCase.printTableUpdates = origPrintTableUpdates;
        if (failed) {
            throw new RuntimeException("Debug candidate: seed=" + bestSeed + " steps=" + bestSteps);
        }
    }

    public static void expectLivenessException(@NotNull Runnable action) {
        try {
            action.run();
            Assert.statementNeverExecuted((String)"Expected LivenessStateException");
        }
        catch (LivenessStateException livenessStateException) {
            // empty catch block
        }
    }

    public static void assertThrows(Runnable runnable) {
        boolean threwException = false;
        try {
            runnable.run();
        }
        catch (Exception ignored) {
            threwException = true;
        }
        TestCase.assertTrue((boolean)threwException);
    }

    public static void tableRangesAreEqual(Table table1, Table table2, long from1, long from2, long size) {
        TstUtils.assertTableEquals((Table)((Table)table1.tail(table1.size() - from1)).head(size), (Table)((Table)table2.tail(table2.size() - from2)).head(size), new TableDiff.DiffItems[0]);
    }

    public static Table sparsify(@NotNull Table table, long sparsityFactor) {
        Assert.assertion((!table.isRefreshing() ? 1 : 0) != 0, (String)"!table.isRefreshing()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        TrackingRowSet inputRowSet = table.getRowSet();
        long expectedLastRowKey = Math.multiplyExact(inputRowSet.lastRowKey(), sparsityFactor);
        inputRowSet.forAllRowKeys(rowKey -> builder.appendKey(rowKey * sparsityFactor));
        WritableRowSet outputRowSet = builder.build();
        Assert.eq((long)expectedLastRowKey, (String)"expectedLastRowKey", (long)outputRowSet.lastRowKey(), (String)"outputRowSet.lastRowKey()");
        LongColumnSourceRowRedirection densifyingRedirection = new LongColumnSourceRowRedirection((ColumnSource)new ViewColumnSource(Long.class, (Formula)new DensifyRowKeysFormula(sparsityFactor), true));
        Map outputColumnSources = table.getColumnSourceMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, arg_0 -> TstUtils.lambda$sparsify$9((RowRedirection)densifyingRedirection, arg_0), Assert::neverInvoked, LinkedHashMap::new));
        return new QueryTable((TrackingRowSet)outputRowSet.toTracking(), outputColumnSources);
    }

    private static /* synthetic */ ColumnSource lambda$sparsify$9(RowRedirection densifyingRedirection, Map.Entry entry) {
        return RedirectedColumnSource.maybeRedirect((RowRedirection)densifyingRedirection, (ColumnSource)((ColumnSource)entry.getValue()));
    }

    private static final class DensifyRowKeysFormula
    extends Formula {
        private static final Formula.FillContext FILL_CONTEXT = new Formula.FillContext(){};
        private final long sparsityFactor;

        private DensifyRowKeysFormula(long sparsityFactor) {
            super(null);
            this.sparsityFactor = sparsityFactor;
        }

        private long densify(long rowKey) {
            Assert.eqZero((long)(rowKey % this.sparsityFactor), (String)"rowKey % sparsityFactor");
            return rowKey / this.sparsityFactor;
        }

        public Long get(long rowKey) {
            return TypeUtils.box((long)this.densify(rowKey));
        }

        public Long getPrev(long rowKey) {
            return this.get(rowKey);
        }

        public long getLong(long rowKey) {
            return this.densify(rowKey);
        }

        public long getPrevLong(long rowKey) {
            return this.getLong(rowKey);
        }

        protected ChunkType getChunkType() {
            return ChunkType.Long;
        }

        public Formula.FillContext makeFillContext(int chunkCapacity) {
            return FILL_CONTEXT;
        }

        public void fillChunk(@NotNull Formula.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
            destination.setSize(0);
            WritableLongChunk typedDestination = destination.asWritableLongChunk();
            rowSequence.forAllRowKeys(rowKey -> typedDestination.add(this.getLong(rowKey)));
        }

        public void fillPrevChunk(@NotNull Formula.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
            this.fillChunk(context, destination, rowSequence);
        }
    }
}

