/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableListener;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.TableUpdateListener;
import io.deephaven.engine.table.impl.InstrumentedTableUpdateListener;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.TableUpdateValidator;
import io.deephaven.engine.testutil.EvalNuggetInterface;
import io.deephaven.engine.util.TableTools;
import io.deephaven.util.annotations.ReferentialIntegrity;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.junit.Assert;

public class UpdateValidatorNugget
implements EvalNuggetInterface {
    private final QueryTable originalValue;
    private final TableUpdateValidator validator;
    private Throwable exception = null;
    @ReferentialIntegrity
    private final TableUpdateListener failureListener = new FailureListener();
    @ReferentialIntegrity
    private final TableUpdateListener validatorFailureListener = new FailureListener();

    public UpdateValidatorNugget(Table table) {
        this((QueryTable)table);
    }

    public UpdateValidatorNugget(QueryTable table) {
        this.originalValue = table;
        this.validator = TableUpdateValidator.make((QueryTable)this.originalValue);
        this.originalValue.addUpdateListener(this.failureListener);
        this.validator.getResultTable().addUpdateListener(this.validatorFailureListener);
    }

    @Override
    public void validate(String msg) {
        Assert.assertNull((Object)this.exception);
        Assert.assertFalse((boolean)this.validator.hasFailed());
    }

    @Override
    public void show() {
        TableTools.showWithRowSet((Table)this.originalValue, (long)100L, (String[])new String[0]);
    }

    private class FailureListener
    extends InstrumentedTableUpdateListener {
        public FailureListener() {
            super("Failure Listener");
        }

        public void onUpdate(TableUpdate update) {
        }

        public void onFailureInternal(Throwable originalException, TableListener.Entry sourceEntry) {
            UpdateValidatorNugget.this.exception = originalException;
            StringWriter errors = new StringWriter();
            originalException.printStackTrace(new PrintWriter(errors));
            TestCase.fail((String)errors.toString());
        }
    }
}

