/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.GeneratorCollectionFactory;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class AbstractAdaptableUniqueGenerator<SV, CV>
implements TestDataGenerator<CV, CV> {
    final Set<SV> generatedValues = new HashSet<SV>();
    final Map<Long, CV> currentValues = GeneratorCollectionFactory.makeUnsortedMapForType(this.getType());

    @Override
    public Chunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.size() == 0L) {
            return ObjectChunk.getEmptyChunk();
        }
        toAdd.forAllRowKeys(this.currentValues::remove);
        List result = GeneratorCollectionFactory.makeListForType(this.getType());
        HashSet usedValues = new HashSet();
        this.currentValues.values().forEach(v -> usedValues.add(this.invert(v)));
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            Object value = this.getNextUniqueValue(usedValues, nextKey, random);
            usedValues.add(value);
            CV adaptedValue = this.adapt(value);
            result.add(adaptedValue);
            this.currentValues.put(nextKey, adaptedValue);
        }
        return this.makeChunk(result);
    }

    SV getNextUniqueValue(Set<SV> usedValues, long key, Random random) {
        SV candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(key, random)));
        this.generatedValues.add(candidate);
        return candidate;
    }

    @Override
    public void onRemove(RowSet toRemove) {
        toRemove.forAllRowKeys(this.currentValues::remove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        if (delta < 0L) {
            for (long kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (long kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
    }

    Set<SV> getGeneratedValues() {
        return Collections.unmodifiableSet(this.generatedValues);
    }

    abstract Chunk<Values> makeChunk(List<CV> var1);

    abstract SV nextValue(long var1, Random var3);

    @Override
    public Class<CV> getColumnType() {
        return this.getType();
    }

    abstract CV adapt(SV var1);

    abstract SV invert(CV var1);
}

