/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractAdaptableUniqueGenerator;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;
import java.util.function.IntFunction;

public class AbstractFromUniqueAdaptableGenerator<SV, CV>
extends AbstractGenerator<CV> {
    private final Class<CV> type;
    private final AbstractAdaptableUniqueGenerator<SV, CV> uniqueGenerator;
    private final AbstractGenerator<CV> defaultGenerator;
    private final IntFunction<SV[]> arrayFactory;
    private final double existingFraction;
    int lastSize = 0;
    SV[] lastValues;

    AbstractFromUniqueAdaptableGenerator(Class<CV> type, AbstractAdaptableUniqueGenerator<SV, CV> uniqueGenerator, AbstractGenerator<CV> defaultGenerator, IntFunction<SV[]> arrayFactory, double existingFraction) {
        this.type = type;
        this.uniqueGenerator = uniqueGenerator;
        this.defaultGenerator = defaultGenerator;
        this.arrayFactory = arrayFactory;
        this.existingFraction = existingFraction;
    }

    @Override
    public CV nextValue(Random random) {
        if (random.nextDouble() < this.existingFraction) {
            int size = this.uniqueGenerator.getGeneratedValues().size();
            if (size != this.lastSize) {
                this.lastValues = this.uniqueGenerator.getGeneratedValues().toArray(this.arrayFactory);
                this.lastSize = this.lastValues.length;
            }
            if (size > 0) {
                return this.uniqueGenerator.adapt(this.lastValues[random.nextInt(this.lastValues.length)]);
            }
        }
        return (CV)this.defaultGenerator.nextValue(random);
    }

    @Override
    public Class<CV> getType() {
        return this.type;
    }
}

