/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.GeneratorCollectionFactory;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class AbstractSortedGenerator<T extends Comparable<? super T>>
implements TestDataGenerator<T, T> {
    final Map<Long, T> currentValues = GeneratorCollectionFactory.makeUnsortedMapForType(this.getType());
    final WritableRowSet currentRowSet = RowSetFactory.empty();

    @Override
    public Chunk<Values> populateChunk(RowSet toAdd, Random random) {
        long firstKey;
        if (toAdd.size() == 0L) {
            return ObjectChunk.getEmptyChunk();
        }
        SortedMap result = GeneratorCollectionFactory.makeSortedMapForType(this.getType());
        WritableRowSet orig = this.currentRowSet.copy();
        toAdd.forAllRowKeys(this.currentValues::remove);
        this.currentRowSet.remove(toAdd);
        RowSet.Iterator iterator = toAdd.iterator();
        long lastKey = firstKey = iterator.nextLong();
        T currentFloor = this.getFloor(firstKey);
        long ceilingKey = this.getCeilingKey(firstKey);
        T currentCeiling = this.getCeilingValue(ceilingKey);
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            if (nextKey < ceilingKey) {
                lastKey = nextKey;
                continue;
            }
            this.generateValues((RowSet)toAdd.subSetByKeyRange(firstKey, lastKey), currentFloor, currentCeiling, result, random);
            lastKey = firstKey = nextKey;
            currentFloor = this.getFloor(firstKey);
            ceilingKey = this.getCeilingKey(firstKey);
            currentCeiling = this.getCeilingValue(ceilingKey);
        }
        this.generateValues((RowSet)toAdd.subSetByKeyRange(firstKey, lastKey), currentFloor, currentCeiling, result, random);
        this.currentRowSet.insert(toAdd);
        this.currentValues.putAll(result);
        Object[] resultArray = result.values().toArray((Comparable[])Array.newInstance(this.getType(), result.size()));
        return ObjectChunk.chunkWrap((Object[])resultArray);
    }

    private T getCeilingValue(long ceilingKey) {
        return (T)(ceilingKey == Long.MAX_VALUE ? this.maxValue() : (Comparable)this.currentValues.get(ceilingKey));
    }

    private long getCeilingKey(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey > this.currentRowSet.lastRowKey()) {
            return Long.MAX_VALUE;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return firstKey;
        }
        return this.currentRowSet.get(-position - 1L);
    }

    private T getFloor(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey < this.currentRowSet.firstRowKey()) {
            return this.minValue();
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return (T)((Comparable)this.currentValues.get(firstKey));
        }
        long floorKey = this.currentRowSet.get(-position - 2L);
        Assert.assertion((boolean)this.currentValues.containsKey(floorKey), (String)"currentValues.containsKey(floorKey)");
        return (T)((Comparable)this.currentValues.get(floorKey));
    }

    abstract T maxValue();

    abstract T minValue();

    private void checkSorted() {
        Assert.eq((long)this.currentRowSet.size(), (String)"currentRowSet.size()", (long)this.currentValues.size(), (String)"currentValues.size()");
        MutableObject lastValue = new MutableObject(this.minValue());
        this.currentRowSet.forAllRowKeys(idx -> {
            Comparable value = (Comparable)this.currentValues.get(idx);
            Assert.assertion((value.compareTo(lastValue.getValue()) >= 0 ? 1 : 0) != 0, (String)"value >= lastValue", (Object)value, (String)"value", (Object)lastValue.getValue(), (String)"lastValue", (Object)value, (String)"value");
            lastValue.setValue((Object)value);
        });
    }

    private void generateValues(RowSet toadd, T floor, T ceiling, SortedMap<Long, T> result, Random random) {
        int ii;
        int count = (int)toadd.size();
        Object[] values = (Comparable[])Array.newInstance(this.getType(), count);
        for (ii = 0; ii < count; ++ii) {
            values[ii] = this.makeValue(floor, ceiling, random);
        }
        Arrays.sort(values);
        ii = 0;
        RowSet.Iterator it = toadd.iterator();
        while (it.hasNext()) {
            result.put(it.nextLong(), values[ii++]);
        }
    }

    abstract T makeValue(T var1, T var2, Random var3);

    @Override
    public Class<T> getColumnType() {
        return this.getType();
    }

    @Override
    public void onRemove(RowSet toRemove) {
        toRemove.forAllRowKeys(this.currentValues::remove);
        this.currentRowSet.remove(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        try (WritableRowSet shifted = this.currentRowSet.subSetByKeyRange(start, end);){
            if (delta < 0L) {
                shifted.forAllRowKeys(kk -> this.currentValues.put(kk + delta, (Comparable)this.currentValues.remove(kk)));
            } else {
                shifted.reverseIterator().forEachRemaining(kk -> this.currentValues.put(kk + delta, (Comparable)this.currentValues.remove(kk)));
            }
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)shifted);
        }
    }
}

