/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class AbstractUniqueGenerator<T>
implements UniqueTestDataGenerator<T, T> {
    final Map<Long, T> currentValues = new Long2ObjectOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();

    public ObjectChunk<T, Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return ObjectChunk.getEmptyChunk();
        }
        Object[] result = new Object[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        HashSet<T> usedValues = new HashSet<T>(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            T value = this.getNextUniqueValue(usedValues, nextKey, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return ObjectChunk.chunkWrap((Object[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(this.currentValues::remove);
        this.currentRowSet.remove(toAdd);
    }

    private void checkUnique() {
        HashMap rowForKey = new HashMap();
        this.currentValues.forEach((k, v) -> {
            Long ok = rowForKey.put(v, k);
            if (ok != null) {
                throw new IllegalStateException("Duplicate value: " + v + ", ok=" + ok + ", k=" + k);
            }
        });
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private T getNextUniqueValue(Set<T> usedValues, long key, Random random) {
        T candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(key, random)));
        return candidate;
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public T getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return this.currentValues.get(randKey);
    }

    abstract T nextValue(long var1, Random var3);

    @Override
    public Class<T> getColumnType() {
        return this.getType();
    }
}

