/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public class BigDecimalGenerator
extends AbstractGenerator<BigDecimal> {
    static final BigInteger DEFAULT_FROM = BigInteger.valueOf(Long.MIN_VALUE).multiply(BigInteger.valueOf(2L));
    static final BigInteger DEFAULT_TO = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
    private final BigInteger to;
    private final BigInteger from;
    private final BigDecimal toDecimal;
    private final BigDecimal fromDecimal;
    private final double nullFraction;
    private final int rangeBitLength;
    private final int decimalPlaces;
    private final BigInteger range;

    public BigDecimalGenerator() {
        this(DEFAULT_FROM, DEFAULT_TO, 10, 0.0);
    }

    public BigDecimalGenerator(double nullFraction) {
        this(DEFAULT_FROM, DEFAULT_TO, 10, nullFraction);
    }

    public BigDecimalGenerator(BigInteger from, BigInteger to) {
        this(from, to, 10, 0.0);
    }

    public BigDecimalGenerator(BigInteger from, BigInteger to, int decimalPlaces, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
        BigInteger scale = BigInteger.TEN.pow(decimalPlaces);
        this.decimalPlaces = decimalPlaces;
        this.range = to.subtract(from).multiply(scale);
        this.rangeBitLength = this.range.bitLength();
        this.toDecimal = new BigDecimal(to);
        this.fromDecimal = new BigDecimal(from);
    }

    @Override
    public BigDecimal nextValue(Random random) {
        BigInteger value;
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return null;
        }
        while ((value = new BigInteger(this.rangeBitLength, random)).compareTo(this.range) > 0) {
        }
        BigDecimal result = new BigDecimal(value, this.decimalPlaces).add(this.fromDecimal);
        Assert.assertion((result.compareTo(this.fromDecimal) >= 0 ? 1 : 0) != 0, (String)"result.compareTo(from) >= 0", (Object)result, (String)"result", (Object)this.from, (String)"from");
        Assert.assertion((result.compareTo(this.toDecimal) <= 0 ? 1 : 0) != 0, (String)"result.compareTo(to) <= 0", (Object)result, (String)"result", (Object)this.to, (String)"to");
        return result;
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }
}

