/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.math.BigInteger;
import java.util.Random;

public class BigIntegerGenerator
extends AbstractGenerator<BigInteger> {
    private static final BigInteger DEFAULT_FROM = BigInteger.valueOf(Long.MIN_VALUE).multiply(BigInteger.valueOf(2L));
    private static final BigInteger DEFAULT_TO = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
    private final BigInteger to;
    private final BigInteger from;
    private final double nullFraction;
    private final int rangeBitLength;
    private final BigInteger range;

    public BigIntegerGenerator() {
        this(DEFAULT_FROM, DEFAULT_TO);
    }

    public BigIntegerGenerator(double nullFraction) {
        this(BigInteger.valueOf(Long.MIN_VALUE).multiply(BigInteger.valueOf(2L)), BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)), nullFraction);
    }

    public BigIntegerGenerator(BigInteger from, BigInteger to) {
        this(from, to, 0.0);
    }

    public BigIntegerGenerator(BigInteger from, BigInteger to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
        this.range = to.subtract(from);
        this.rangeBitLength = this.range.bitLength();
    }

    @Override
    public BigInteger nextValue(Random random) {
        BigInteger value;
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return null;
        }
        while ((value = new BigInteger(this.rangeBitLength, random)).compareTo(this.range) > 0) {
        }
        BigInteger result = value.add(this.from);
        Assert.assertion((result.compareTo(this.from) >= 0 ? 1 : 0) != 0, (String)"result.compareTo(from) >= 0", (Object)result, (String)"result", (Object)this.from, (String)"from");
        Assert.assertion((result.compareTo(this.to) <= 0 ? 1 : 0) != 0, (String)"result.compareTo(to) <= 0", (Object)result, (String)"result", (Object)this.to, (String)"to");
        return result;
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }
}

