/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class BooleanGenerator
extends AbstractGenerator<Boolean> {
    private final double trueFraction;
    private final double nullFraction;

    public BooleanGenerator() {
        this(0.5, 0.0);
    }

    public BooleanGenerator(double trueFraction) {
        this(trueFraction, 0.0);
    }

    public BooleanGenerator(double trueFraction, double nullFraction) {
        this.trueFraction = trueFraction;
        this.nullFraction = nullFraction;
    }

    @Override
    public Boolean nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return null;
        }
        return random.nextDouble() < this.trueFraction;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }
}

