/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class ByteArrayGenerator
extends AbstractGenerator<byte[]> {
    private final byte min;
    private final byte max;
    private final int minSize;
    private final int maxSize;

    public ByteArrayGenerator(byte min, byte max, int minSize, int maxSize) {
        this.min = min;
        this.max = max;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public Class<byte[]> getType() {
        return byte[].class;
    }

    @Override
    byte[] nextValue(Random random) {
        int size = random.nextInt(this.maxSize - this.minSize) + this.minSize;
        byte[] arr = new byte[size];
        for (int ii = 0; ii < size; ++ii) {
            arr[ii] = (byte)(random.nextInt(this.max - this.min) + this.min);
        }
        return arr;
    }
}

