/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import java.util.Random;

public class ByteGenerator
extends AbstractGenerator<Byte> {
    private final byte to;
    private final byte from;
    private final double nullFraction;

    public ByteGenerator() {
        this(PrimitiveGeneratorFunctions.minByte(), PrimitiveGeneratorFunctions.maxByte());
    }

    public ByteGenerator(byte from, byte to) {
        this.from = from;
        this.to = to;
        this.nullFraction = 0.0;
    }

    public ByteGenerator(byte from, byte to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    @Override
    public Byte nextValue(Random random) {
        return this.nextByte(random);
    }

    private byte nextByte(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return -128;
        }
        return PrimitiveGeneratorFunctions.generateByte(random, this.from, this.to);
    }

    public WritableByteChunk<Values> populateChunk(RowSet toAdd, Random random) {
        byte[] result = new byte[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.nextByte(random);
        }
        return WritableByteChunk.writableChunkWrap((byte[])result);
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }
}

