/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import java.util.Random;

public class CharGenerator
extends AbstractGenerator<Character> {
    private final char to;
    private final char from;
    private final double nullFraction;

    public CharGenerator() {
        this(PrimitiveGeneratorFunctions.minChar(), PrimitiveGeneratorFunctions.maxChar());
    }

    public CharGenerator(char from, char to) {
        this.from = from;
        this.to = to;
        this.nullFraction = 0.0;
    }

    public CharGenerator(char from, char to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    @Override
    public Character nextValue(Random random) {
        return Character.valueOf(this.nextChar(random));
    }

    private char nextChar(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return '\uffff';
        }
        return PrimitiveGeneratorFunctions.generateChar(random, this.from, this.to);
    }

    public WritableCharChunk<Values> populateChunk(RowSet toAdd, Random random) {
        char[] result = new char[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.nextChar(random);
        }
        return WritableCharChunk.writableChunkWrap((char[])result);
    }

    @Override
    public Class<Character> getType() {
        return Character.class;
    }
}

