/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.Pair;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.table.impl.chunkboxer.ChunkBoxer;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import io.deephaven.util.SafeCloseable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class CompositeGenerator<T>
implements TestDataGenerator<T, T> {
    @NotNull
    private final List<TestDataGenerator<T, T>> generators;
    @NotNull
    private final double[] fractions;

    public CompositeGenerator(List<TestDataGenerator<T, T>> generators, double ... fractions) {
        if (fractions.length != generators.size() - 1) {
            throw new IllegalArgumentException("Generators must have one more element than fractions!");
        }
        double sum = Arrays.stream(fractions).sum();
        if (sum > 1.0) {
            throw new IllegalArgumentException();
        }
        TestDataGenerator<T, T> firstGenerator = generators.get(0);
        for (TestDataGenerator<T, T> generator : generators) {
            if (!generator.getType().equals(firstGenerator.getType())) {
                throw new IllegalArgumentException("Mismatched generator types: " + generator.getType() + " vs. " + firstGenerator.getType());
            }
            if (generator.getColumnType().equals(firstGenerator.getColumnType())) continue;
            throw new IllegalArgumentException("Mismatched generator column types: " + generator.getType() + " vs. " + firstGenerator.getType());
        }
        this.generators = generators;
        this.fractions = fractions;
    }

    @Override
    public Chunk<Values> populateChunk(RowSet toAdd, Random random) {
        Pair top;
        if (toAdd.isEmpty()) {
            return ObjectChunk.getEmptyChunk();
        }
        RowSetBuilderSequential[] builders = new RowSetBuilderSequential[this.generators.size()];
        RowSet[] builderRowSet = new RowSet[this.generators.size()];
        for (int ii = 0; ii < builders.length; ++ii) {
            builders[ii] = RowSetFactory.builderSequential();
        }
        toAdd.forAllRowKeys(ll -> builders[this.pickGenerator(random)].appendKey(ll));
        ObjectChunk[] intermediateResults = new ObjectChunk[builders.length];
        ChunkBoxer.BoxerKernel[] boxerKernel = new ChunkBoxer.BoxerKernel[builders.length];
        MutableInt[] offsets = new MutableInt[builders.length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(Comparator.comparingLong(a -> ((RowSet.SearchIterator)a.first).currentValue()));
        for (int ii = 0; ii < builders.length; ++ii) {
            builderRowSet[ii] = builders[ii].build().asRowSet();
            Chunk<Values> generatorResults = this.generators.get(ii).populateChunk(builderRowSet[ii], random);
            boxerKernel[ii] = ChunkBoxer.getBoxer((ChunkType)generatorResults.getChunkType(), (int)generatorResults.size());
            intermediateResults[ii] = boxerKernel[ii].box(generatorResults);
            offsets[ii] = new MutableInt();
            RowSet.SearchIterator it = builderRowSet[ii].searchIterator();
            if (!it.hasNext()) continue;
            it.nextLong();
            priorityQueue.add(new Pair((Object)it, (Object)ii));
        }
        Object[] result = (Object[])Array.newInstance(this.getType(), toAdd.intSize());
        int idx = 0;
        while ((top = priorityQueue.poll()) != null) {
            int generatorNumber = (Integer)top.second;
            result[idx++] = intermediateResults[generatorNumber].get(offsets[generatorNumber].getAndIncrement());
            if (!((RowSet.SearchIterator)top.first).hasNext()) continue;
            ((RowSet.SearchIterator)top.first).nextLong();
            priorityQueue.add(top);
        }
        SafeCloseable.closeAll((SafeCloseable[])boxerKernel);
        return ObjectChunk.chunkWrap((Object[])result);
    }

    @Override
    public Class<T> getType() {
        return this.generators.get(0).getType();
    }

    @Override
    public Class<T> getColumnType() {
        return this.generators.get(0).getColumnType();
    }

    private int pickGenerator(Random random) {
        int pickGenerator;
        double whichGenerator = random.nextDouble();
        double sum = 0.0;
        for (pickGenerator = 0; pickGenerator != this.generators.size() - 1 && (sum += this.fractions[pickGenerator]) < whichGenerator; ++pickGenerator) {
        }
        return pickGenerator;
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.generators.forEach(gg -> gg.onRemove(toRemove));
    }

    @Override
    public void shift(long start, long end, long delta) {
        this.generators.forEach(gg -> gg.shift(start, end, delta));
    }
}

