/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractSortedGenerator;
import java.util.Date;
import java.util.Random;

public class DateGenerator
extends AbstractSortedGenerator<Date> {
    private final Date minDate;
    private final Date maxDate;

    public DateGenerator(Date minDate, Date maxDate) {
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    @Override
    Date maxValue() {
        return this.maxDate;
    }

    @Override
    Date minValue() {
        return this.minDate;
    }

    @Override
    Date makeValue(Date floor, Date ceiling, Random random) {
        if (floor.equals(ceiling)) {
            return floor;
        }
        if (ceiling.getTime() < floor.getTime()) {
            throw new IllegalStateException("ceiling < floor: " + ceiling + " > " + floor);
        }
        return new Date(floor.getTime() + (long)random.nextInt((int)(ceiling.getTime() - floor.getTime() + 1L)));
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }
}

