/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class DoubleGenerator
extends AbstractGenerator<Double> {
    private final double to;
    private final double from;
    private final double nullFraction;
    private final double nanFraction;
    private final double negInfFraction;
    private final double posInfFraction;

    public DoubleGenerator() {
        this(Math.nextUp(-1.7976931348623157E308), Double.MAX_VALUE);
    }

    public DoubleGenerator(double from, double to) {
        this(from, to, 0.0);
    }

    public DoubleGenerator(double from, double to, double nullFraction) {
        this(from, to, nullFraction, 0.0);
    }

    public DoubleGenerator(double from, double to, double nullFraction, double nanFraction) {
        this(from, to, nullFraction, nanFraction, 0.0, 0.0);
    }

    public DoubleGenerator(double from, double to, double nullFraction, double nanFraction, double negInfFraction, double posInfFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
        this.nanFraction = nanFraction;
        this.negInfFraction = negInfFraction;
        this.posInfFraction = posInfFraction;
        Require.leq((double)(nullFraction + nanFraction + negInfFraction + posInfFraction), (String)"nullFraction + nanFraction + negInfFraction + posInfFraction", (double)1.0, (String)"1.0");
    }

    @Override
    public Double nextValue(Random random) {
        return this.generateDouble(random);
    }

    private double generateDouble(Random random) {
        if (this.nullFraction > 0.0 || this.nanFraction > 0.0 || this.negInfFraction > 0.0 || this.posInfFraction > 0.0) {
            double frac = random.nextDouble();
            if (this.nullFraction > 0.0 && frac < this.nullFraction) {
                return -1.7976931348623157E308;
            }
            if (this.nanFraction > 0.0 && frac < this.nullFraction + this.nanFraction) {
                return Double.NaN;
            }
            if (this.negInfFraction > 0.0 && frac < this.nullFraction + this.nanFraction + this.negInfFraction) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.posInfFraction > 0.0 && frac < this.nullFraction + this.nanFraction + this.negInfFraction + this.posInfFraction) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return (this.from / 2.0 + random.nextDouble() * (this.to / 2.0 - this.from / 2.0)) * 2.0;
    }

    public DoubleChunk<Values> populateChunk(RowSet toAdd, Random random) {
        double[] result = new double[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.generateDouble(random);
        }
        return DoubleChunk.chunkWrap((double[])result);
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }
}

