/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class FloatGenerator
extends AbstractGenerator<Float> {
    private final float to;
    private final float from;
    private final double nullFraction;
    private final double nanFraction;
    private final double negInfFraction;
    private final double posInfFraction;

    public FloatGenerator() {
        this(Math.nextUp(-3.4028235E38f), Float.MAX_VALUE);
    }

    public FloatGenerator(float from, float to) {
        this(from, to, 0.0);
    }

    public FloatGenerator(float from, float to, double nullFraction) {
        this(from, to, nullFraction, 0.0);
    }

    public FloatGenerator(float from, float to, double nullFraction, double nanFraction) {
        this(from, to, nullFraction, nanFraction, 0.0, 0.0);
    }

    public FloatGenerator(float from, float to, double nullFraction, double nanFraction, double negInfFraction, double posInfFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
        this.nanFraction = nanFraction;
        this.negInfFraction = negInfFraction;
        this.posInfFraction = posInfFraction;
        Require.leq((double)(nullFraction + nanFraction + negInfFraction + posInfFraction), (String)"nullFraction + nanFraction + negInfFraction + posInfFraction", (double)1.0, (String)"1.0");
    }

    @Override
    public Float nextValue(Random random) {
        return Float.valueOf(this.generateFloat(random));
    }

    private float generateFloat(Random random) {
        if (this.nullFraction > 0.0 || this.nanFraction > 0.0 || this.negInfFraction > 0.0 || this.posInfFraction > 0.0) {
            double frac = random.nextDouble();
            if (this.nullFraction > 0.0 && frac < this.nullFraction) {
                return -3.4028235E38f;
            }
            if (this.nanFraction > 0.0 && frac < this.nullFraction + this.nanFraction) {
                return Float.NaN;
            }
            if (this.negInfFraction > 0.0 && frac < this.nullFraction + this.nanFraction + this.negInfFraction) {
                return Float.NEGATIVE_INFINITY;
            }
            if (this.posInfFraction > 0.0 && frac < this.nullFraction + this.nanFraction + this.negInfFraction + this.posInfFraction) {
                return Float.POSITIVE_INFINITY;
            }
        }
        return (this.from / 2.0f + random.nextFloat() * (this.to / 2.0f - this.from / 2.0f)) * 2.0f;
    }

    public FloatChunk<Values> populateChunk(RowSet toAdd, Random random) {
        float[] result = new float[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.generateFloat(random);
        }
        return FloatChunk.chunkWrap((float[])result);
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }
}

