/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2ByteAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2CharAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2CharOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ShortAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;

public class GeneratorCollectionFactory {
    @NotNull
    public static <U> SortedMap<Long, U> makeSortedMapForType(Class<U> mapType) {
        if (mapType == Character.class || mapType == Character.TYPE) {
            Long2CharAVLTreeMap retMap = new Long2CharAVLTreeMap();
            retMap.defaultReturnValue('\uffff');
            return retMap;
        }
        if (mapType == Byte.class || mapType == Byte.TYPE) {
            Long2ByteAVLTreeMap retMap = new Long2ByteAVLTreeMap();
            retMap.defaultReturnValue((byte)-128);
            return retMap;
        }
        if (mapType == Short.class || mapType == Short.TYPE) {
            Long2ShortAVLTreeMap retMap = new Long2ShortAVLTreeMap();
            retMap.defaultReturnValue((short)Short.MIN_VALUE);
            return retMap;
        }
        if (mapType == Integer.class || mapType == Integer.TYPE) {
            Long2IntAVLTreeMap retMap = new Long2IntAVLTreeMap();
            retMap.defaultReturnValue(Integer.MIN_VALUE);
            return retMap;
        }
        if (mapType == Long.class || mapType == Long.TYPE) {
            Long2LongAVLTreeMap retMap = new Long2LongAVLTreeMap();
            retMap.defaultReturnValue(Long.MIN_VALUE);
            return retMap;
        }
        if (mapType == Float.class || mapType == Float.TYPE) {
            Long2FloatAVLTreeMap retMap = new Long2FloatAVLTreeMap();
            retMap.defaultReturnValue(-3.4028235E38f);
            return retMap;
        }
        if (mapType == Double.class || mapType == Double.TYPE) {
            Long2DoubleAVLTreeMap retMap = new Long2DoubleAVLTreeMap();
            retMap.defaultReturnValue(-1.7976931348623157E308);
            return retMap;
        }
        return new Long2ObjectAVLTreeMap();
    }

    @NotNull
    public static <U> Map<Long, U> makeUnsortedMapForType(Class<U> mapType) {
        if (mapType == Character.class || mapType == Character.TYPE) {
            Long2CharOpenHashMap retMap = new Long2CharOpenHashMap();
            retMap.defaultReturnValue('\uffff');
            return retMap;
        }
        if (mapType == Byte.class || mapType == Byte.TYPE) {
            Long2ByteOpenHashMap retMap = new Long2ByteOpenHashMap();
            retMap.defaultReturnValue((byte)-128);
            return retMap;
        }
        if (mapType == Short.class || mapType == Short.TYPE) {
            Long2ShortOpenHashMap retMap = new Long2ShortOpenHashMap();
            retMap.defaultReturnValue((short)Short.MIN_VALUE);
            return retMap;
        }
        if (mapType == Integer.class || mapType == Integer.TYPE) {
            Long2IntOpenHashMap retMap = new Long2IntOpenHashMap();
            retMap.defaultReturnValue(Integer.MIN_VALUE);
            return retMap;
        }
        if (mapType == Long.class || mapType == Long.TYPE) {
            Long2LongOpenHashMap retMap = new Long2LongOpenHashMap();
            retMap.defaultReturnValue(Long.MIN_VALUE);
            return retMap;
        }
        if (mapType == Float.class || mapType == Float.TYPE) {
            Long2FloatOpenHashMap retMap = new Long2FloatOpenHashMap();
            retMap.defaultReturnValue(-3.4028235E38f);
            return retMap;
        }
        if (mapType == Double.class || mapType == Double.TYPE) {
            Long2DoubleOpenHashMap retMap = new Long2DoubleOpenHashMap();
            retMap.defaultReturnValue(-1.7976931348623157E308);
            return retMap;
        }
        return new Long2ObjectOpenHashMap();
    }

    @NotNull
    public static <U> List<U> makeListForType(Class<U> listType) {
        if (listType == Character.class || listType == Character.TYPE) {
            CharArrayList retMap = new CharArrayList();
            return retMap;
        }
        if (listType == Byte.class || listType == Byte.TYPE) {
            ByteArrayList retMap = new ByteArrayList();
            return retMap;
        }
        if (listType == Short.class || listType == Short.TYPE) {
            ShortArrayList retMap = new ShortArrayList();
            return retMap;
        }
        if (listType == Integer.class || listType == Integer.TYPE) {
            IntArrayList retMap = new IntArrayList();
            return retMap;
        }
        if (listType == Long.class || listType == Long.TYPE) {
            LongArrayList retMap = new LongArrayList();
            return retMap;
        }
        if (listType == Float.class || listType == Float.TYPE) {
            FloatArrayList retMap = new FloatArrayList();
            return retMap;
        }
        if (listType == Double.class || listType == Double.TYPE) {
            DoubleArrayList retMap = new DoubleArrayList();
            return retMap;
        }
        return new ArrayList();
    }
}

