/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class IntArrayGenerator
extends AbstractGenerator<int[]> {
    private final int min;
    private final int max;
    private final int minSize;
    private final int maxSize;

    public IntArrayGenerator(int min, int max, int minSize, int maxSize) {
        this.min = min;
        this.max = max;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public Class<int[]> getType() {
        return int[].class;
    }

    @Override
    int[] nextValue(Random random) {
        int size = random.nextInt(this.maxSize - this.minSize) + this.minSize;
        int[] arr = new int[size];
        for (int ii = 0; ii < size; ++ii) {
            arr[ii] = random.nextInt(this.max - this.min) + this.min;
        }
        return arr;
    }
}

