/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import java.util.Random;

public class IntGenerator
extends AbstractGenerator<Integer> {
    private final int to;
    private final int from;
    private final double nullFraction;

    public IntGenerator() {
        this(PrimitiveGeneratorFunctions.minInt(), PrimitiveGeneratorFunctions.maxInt());
    }

    public IntGenerator(int from, int to) {
        this.from = from;
        this.to = to;
        this.nullFraction = 0.0;
    }

    public IntGenerator(int from, int to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    @Override
    public Integer nextValue(Random random) {
        return this.nextInt(random);
    }

    private int nextInt(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Integer.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateInt(random, this.from, this.to);
    }

    public WritableIntChunk<Values> populateChunk(RowSet toAdd, Random random) {
        int[] result = new int[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.nextInt(random);
        }
        return WritableIntChunk.writableChunkWrap((int[])result);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

