/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import java.util.Random;

public class LongGenerator
extends AbstractGenerator<Long> {
    private final long to;
    private final long from;
    private final double nullFraction;

    public LongGenerator() {
        this(PrimitiveGeneratorFunctions.minLong(), PrimitiveGeneratorFunctions.maxLong());
    }

    public LongGenerator(long from, long to) {
        this.from = from;
        this.to = to;
        this.nullFraction = 0.0;
    }

    public LongGenerator(long from, long to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    @Override
    public Long nextValue(Random random) {
        return this.nextLong(random);
    }

    private long nextLong(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Long.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateLong(random, this.from, this.to);
    }

    public WritableLongChunk<Values> populateChunk(RowSet toAdd, Random random) {
        long[] result = new long[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.nextLong(random);
        }
        return WritableLongChunk.writableChunkWrap((long[])result);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }
}

