/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import java.util.Random;

public class PrimitiveGeneratorFunctions {
    static char generateChar(Random random, char from, char to) {
        return (char)(from + random.nextInt(to - from));
    }

    static byte generateByte(Random random, byte from, byte to) {
        return (byte)(from + random.nextInt(to - from));
    }

    static short generateShort(Random random, short from, short to) {
        return (short)(from + random.nextInt(to - from));
    }

    static int generateInt(Random random, int from, int to) {
        if (from == to) {
            return from;
        }
        int bound = to - from;
        return from + random.nextInt(bound);
    }

    public static long generateLong(Random random, long from, long to) {
        long range = to - from;
        if (range > 0L && range < Integer.MAX_VALUE) {
            return from + (long)random.nextInt(Math.toIntExact(range));
        }
        if (from == -9223372036854775807L && to == Long.MAX_VALUE) {
            long r;
            while ((r = random.nextLong()) == Long.MIN_VALUE) {
            }
            return r;
        }
        int bits = 64 - Long.numberOfLeadingZeros(range);
        long candidate = PrimitiveGeneratorFunctions.getRandomLong(random, bits);
        while (candidate > range || candidate < 0L) {
            candidate = PrimitiveGeneratorFunctions.getRandomLong(random, bits);
        }
        return from + candidate;
    }

    private static long getRandomLong(Random random, int bits) {
        long value = random.nextLong();
        return bits >= 64 ? value : (1L << bits) - 1L & value;
    }

    static char minChar() {
        return '\u0000';
    }

    static char maxChar() {
        return '\ufffe';
    }

    static byte minByte() {
        return -127;
    }

    static byte maxByte() {
        return 127;
    }

    static short minShort() {
        return -32767;
    }

    static short maxShort() {
        return Short.MAX_VALUE;
    }

    static int minInt() {
        return -1073741824;
    }

    static int maxInt() {
        return 0x3FFFFFFF;
    }

    static long minLong() {
        return -9223372036854775807L;
    }

    static long maxLong() {
        return Long.MAX_VALUE;
    }

    public static double generateDouble(Random random, double from, double to) {
        return from + random.nextDouble() * (to - from);
    }
}

