/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;

public class SetCopyGenerator<T>
extends AbstractGenerator<T> {
    private final Function<T, T> copier;
    private final T[] set;
    private final Class<T> type;

    @SafeVarargs
    public SetCopyGenerator(Function<T, T> copier, T ... set) {
        this.copier = copier;
        this.set = set;
        this.type = set.getClass().getComponentType();
    }

    public SetCopyGenerator(Class<T> type, Function<T, T> copier, Collection<T> set) {
        this.type = type;
        this.copier = copier;
        this.set = set.toArray((Object[])Array.newInstance(type, set.size()));
    }

    @Override
    public T nextValue(Random random) {
        return this.copier.apply(this.set[random.nextInt(this.set.length)]);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

