/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.util.type.TypeUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Random;

public class SetGenerator<T>
extends AbstractGenerator<T> {
    private final T[] set;
    private final Class<T> type;

    public SetGenerator(T ... set) {
        this.set = set;
        this.type = set.getClass().getComponentType();
        this.scrubNulls(this.type);
    }

    public SetGenerator(Class<T> type, Collection<T> set) {
        this.type = type;
        this.set = set.toArray((Object[])Array.newInstance(type, set.size()));
        this.scrubNulls(type);
    }

    private void scrubNulls(Class<T> type) {
        Class unboxed = TypeUtils.getUnboxedTypeIfBoxed(type);
        if (!unboxed.isPrimitive()) {
            return;
        }
        for (int ii = 0; ii < this.set.length; ++ii) {
            if (this.set[ii] != null) continue;
            if (unboxed == Character.TYPE) {
                ((Character[])this.set)[ii] = Character.valueOf('\uffff');
                continue;
            }
            if (unboxed == Byte.TYPE) {
                ((Byte[])this.set)[ii] = -128;
                continue;
            }
            if (unboxed == Short.TYPE) {
                ((Short[])this.set)[ii] = Short.MIN_VALUE;
                continue;
            }
            if (unboxed == Integer.TYPE) {
                ((Integer[])this.set)[ii] = Integer.MIN_VALUE;
                continue;
            }
            if (unboxed == Long.TYPE) {
                ((Long[])this.set)[ii] = Long.MIN_VALUE;
                continue;
            }
            if (unboxed == Float.TYPE) {
                ((Float[])this.set)[ii] = Float.valueOf(-3.4028235E38f);
                continue;
            }
            if (unboxed != Double.TYPE) continue;
            ((Double[])this.set)[ii] = -1.7976931348623157E308;
        }
    }

    @Override
    public T nextValue(Random random) {
        return this.set[random.nextInt(this.set.length)];
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

