/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.testutil.generator.AbstractGenerator;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import java.util.Random;

public class ShortGenerator
extends AbstractGenerator<Short> {
    private final short to;
    private final short from;
    private final double nullFraction;

    public ShortGenerator() {
        this(PrimitiveGeneratorFunctions.minShort(), PrimitiveGeneratorFunctions.maxShort());
    }

    public ShortGenerator(short from, short to) {
        this.from = from;
        this.to = to;
        this.nullFraction = 0.0;
    }

    public ShortGenerator(short from, short to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    @Override
    public Short nextValue(Random random) {
        return this.nextShort(random);
    }

    private short nextShort(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Short.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateShort(random, this.from, this.to);
    }

    public WritableShortChunk<Values> populateChunk(RowSet toAdd, Random random) {
        short[] result = new short[toAdd.intSize()];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = this.nextShort(random);
        }
        return WritableShortChunk.writableChunkWrap((short[])result);
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }
}

