/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractSortedGenerator;
import java.math.BigInteger;
import java.util.Random;

public class SortedBigIntegerGenerator
extends AbstractSortedGenerator<BigInteger> {
    private final BigInteger minValue = BigInteger.ZERO;
    private final BigInteger maxValue;

    public SortedBigIntegerGenerator(int numBits) {
        BigInteger mv = BigInteger.ZERO;
        this.maxValue = mv = mv.setBit(numBits + 1).subtract(BigInteger.ONE);
    }

    @Override
    BigInteger minValue() {
        return this.minValue;
    }

    @Override
    BigInteger maxValue() {
        return this.maxValue;
    }

    @Override
    BigInteger makeValue(BigInteger floor, BigInteger ceiling, Random random) {
        BigInteger range = ceiling.subtract(floor);
        int allowedBits = range.bitLength();
        BigInteger candidate = null;
        for (int ii = 0; ii < 100 && (candidate = new BigInteger(allowedBits, random)).compareTo(range) >= 0; ++ii) {
            candidate = null;
        }
        if (candidate == null) {
            throw new RuntimeException(String.format("Couldn't find a suitable BigInteger between %s and %s", floor, ceiling));
        }
        return floor.add(candidate);
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }
}

