/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import it.unimi.dsi.fastutil.longs.Long2CharOpenHashMap;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SortedCharGenerator
implements TestDataGenerator<Character, Character> {
    final Long2CharOpenHashMap currentValues = new Long2CharOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final char minValue;
    private final char maxValue;

    public SortedCharGenerator(char minValue, char maxValue) {
        if (maxValue == '\uffff') {
            throw new UnsupportedOperationException("Character.MAX_VALUE not supported");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    char makeValue(char floor, char ceiling, Random random) {
        return PrimitiveGeneratorFunctions.generateChar(random, floor, ceiling);
    }

    @Override
    public Class<Character> getType() {
        return Character.class;
    }

    @Override
    public Class<Character> getColumnType() {
        return Character.class;
    }

    public CharChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return CharChunk.getEmptyChunk();
        }
        toAdd.forAllRowKeys(arg_0 -> ((Long2CharOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
        RowSet.Iterator iterator = toAdd.iterator();
        long firstKey = iterator.nextLong();
        char currentFloor = this.getFloor(firstKey);
        long ceilingKey = this.getCeilingKey(firstKey);
        char currentCeiling = this.getCeilingValue(ceilingKey);
        char[] resultArray = new char[toAdd.intSize()];
        int offset = 0;
        int count = 1;
        if (ceilingKey == Long.MAX_VALUE) {
            count = toAdd.intSize();
        } else {
            while (iterator.hasNext()) {
                long nextKey = iterator.nextLong();
                if (nextKey >= ceilingKey) {
                    this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
                    offset += count;
                    count = 0;
                    firstKey = nextKey;
                    currentFloor = this.getFloor(firstKey);
                    ceilingKey = this.getCeilingKey(firstKey);
                    currentCeiling = this.getCeilingValue(ceilingKey);
                }
                ++count;
            }
        }
        this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
        this.currentRowSet.insert(toAdd);
        MutableInt offset2 = new MutableInt(0);
        toAdd.forAllRowKeys(idx -> this.currentValues.put(idx, resultArray[offset2.getAndIncrement()]));
        return CharChunk.chunkWrap((char[])resultArray);
    }

    private char getCeilingValue(long ceilingKey) {
        return ceilingKey == Long.MAX_VALUE ? this.maxValue : this.currentValues.get(ceilingKey);
    }

    private long getCeilingKey(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey > this.currentRowSet.lastRowKey()) {
            return Long.MAX_VALUE;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return firstKey;
        }
        return this.currentRowSet.get(-position - 1L);
    }

    private char getFloor(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey < this.currentRowSet.firstRowKey()) {
            return this.minValue;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return this.currentValues.get(firstKey);
        }
        long floorKey = this.currentRowSet.get(-position - 2L);
        Assert.assertion((boolean)this.currentValues.containsKey(floorKey), (String)"currentValues.containsKey(floorKey)");
        return this.currentValues.get(floorKey);
    }

    private void generateValues(int count, char floor, char ceiling, char[] result, int offset, Random random) {
        char[] values = new char[count];
        for (int ii = 0; ii < count; ++ii) {
            values[ii] = this.makeValue(floor, ceiling, random);
        }
        Arrays.sort(values);
        if (offset > 0) {
            Assert.geq((char)values[0], (String)"values[0]", (char)result[offset - 1], (String)"result[offset - 1]");
        }
        System.arraycopy(values, 0, result, offset, values.length);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        toRemove.forAllRowKeys(arg_0 -> ((Long2CharOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        try (WritableRowSet shifted = this.currentRowSet.subSetByKeyRange(start, end);){
            if (delta < 0L) {
                shifted.forAllRowKeys(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            } else {
                shifted.reverseIterator().forEachRemaining(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            }
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)shifted);
        }
    }

    private void checkSorted() {
        Assert.eq((long)this.currentRowSet.size(), (String)"currentRowSet.size()", (long)this.currentValues.size(), (String)"currentValues.size()");
        MutableLong lastValue = new MutableLong(Long.MIN_VALUE);
        this.currentRowSet.forAllRowKeys(idx -> {
            char value = this.currentValues.get(idx);
            Assert.leq((long)lastValue.longValue(), (String)"lastValue", (long)value, (String)"value");
            lastValue.setValue((long)value);
        });
    }
}

