/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class SortedDoubleGenerator
implements TestDataGenerator<Double, Double> {
    final Long2DoubleOpenHashMap currentValues = new Long2DoubleOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final double minValue;
    private final double maxValue;

    public SortedDoubleGenerator(double minValue, double maxValue) {
        if (maxValue == Double.MAX_VALUE) {
            throw new UnsupportedOperationException("Double.MAX_VALUE not supported");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    double makeValue(double floor, double ceiling, Random random) {
        return PrimitiveGeneratorFunctions.generateDouble(random, floor, ceiling);
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public Class<Double> getColumnType() {
        return Double.class;
    }

    public DoubleChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return DoubleChunk.getEmptyChunk();
        }
        toAdd.forAllRowKeys(arg_0 -> ((Long2DoubleOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
        RowSet.Iterator iterator = toAdd.iterator();
        long firstKey = iterator.nextLong();
        double currentFloor = this.getFloor(firstKey);
        long ceilingKey = this.getCeilingKey(firstKey);
        double currentCeiling = this.getCeilingValue(ceilingKey);
        double[] resultArray = new double[toAdd.intSize()];
        int offset = 0;
        int count = 1;
        if (ceilingKey == Long.MAX_VALUE) {
            count = toAdd.intSize();
        } else {
            while (iterator.hasNext()) {
                long nextKey = iterator.nextLong();
                if (nextKey >= ceilingKey) {
                    this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
                    offset += count;
                    count = 0;
                    firstKey = nextKey;
                    currentFloor = this.getFloor(firstKey);
                    ceilingKey = this.getCeilingKey(firstKey);
                    currentCeiling = this.getCeilingValue(ceilingKey);
                }
                ++count;
            }
        }
        this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
        this.currentRowSet.insert(toAdd);
        MutableInt offset2 = new MutableInt(0);
        toAdd.forAllRowKeys(idx -> this.currentValues.put(idx, resultArray[offset2.getAndIncrement()]));
        return DoubleChunk.chunkWrap((double[])resultArray);
    }

    private double getCeilingValue(long ceilingKey) {
        return ceilingKey == Long.MAX_VALUE ? this.maxValue : this.currentValues.get(ceilingKey);
    }

    private long getCeilingKey(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey > this.currentRowSet.lastRowKey()) {
            return Long.MAX_VALUE;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return firstKey;
        }
        return this.currentRowSet.get(-position - 1L);
    }

    private double getFloor(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey < this.currentRowSet.firstRowKey()) {
            return this.minValue;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return this.currentValues.get(firstKey);
        }
        long floorKey = this.currentRowSet.get(-position - 2L);
        Assert.assertion((boolean)this.currentValues.containsKey(floorKey), (String)"currentValues.containsKey(floorKey)");
        return this.currentValues.get(floorKey);
    }

    private void generateValues(int count, double floor, double ceiling, double[] result, int offset, Random random) {
        double[] values = new double[count];
        for (int ii = 0; ii < count; ++ii) {
            values[ii] = this.makeValue(floor, ceiling, random);
        }
        Arrays.sort(values);
        if (offset > 0) {
            Assert.geq((double)values[0], (String)"values[0]", (double)result[offset - 1], (String)"result[offset - 1]");
        }
        System.arraycopy(values, 0, result, offset, values.length);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        toRemove.forAllRowKeys(arg_0 -> ((Long2DoubleOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        try (WritableRowSet shifted = this.currentRowSet.subSetByKeyRange(start, end);){
            if (delta < 0L) {
                shifted.forAllRowKeys(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            } else {
                shifted.reverseIterator().forEachRemaining(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            }
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)shifted);
        }
    }

    private void checkSorted() {
        Assert.eq((long)this.currentRowSet.size(), (String)"currentRowSet.size()", (long)this.currentValues.size(), (String)"currentValues.size()");
        MutableDouble lastValue = new MutableDouble(-1.7976931348623157E308);
        this.currentRowSet.forAllRowKeys(idx -> {
            double value = this.currentValues.get(idx);
            Assert.leq((double)lastValue.doubleValue(), (String)"lastValue", (double)value, (String)"value");
            lastValue.setValue(value);
        });
    }
}

