/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractSortedGenerator;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.Random;

public class SortedInstantGenerator
extends AbstractSortedGenerator<Instant> {
    private final Instant minTime;
    private final Instant maxTime;

    public SortedInstantGenerator(Instant minTime, Instant maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    @Override
    Instant maxValue() {
        return this.maxTime;
    }

    @Override
    Instant minValue() {
        return this.minTime;
    }

    @Override
    Instant makeValue(Instant floor, Instant ceiling, Random random) {
        long longFloor = DateTimeUtils.epochNanos((Instant)floor);
        long longCeiling = DateTimeUtils.epochNanos((Instant)ceiling);
        long range = longCeiling - longFloor + 1L;
        long nextLong = Math.abs(random.nextLong()) % range;
        return DateTimeUtils.epochNanosToInstant((long)(longFloor + nextLong));
    }

    @Override
    public Class<Instant> getType() {
        return Instant.class;
    }
}

