/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.TestDataGenerator;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SortedLongGenerator
implements TestDataGenerator<Long, Long> {
    final Long2LongOpenHashMap currentValues = new Long2LongOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final long minValue;
    private final long maxValue;

    public SortedLongGenerator(long minValue, long maxValue) {
        if (maxValue == Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Long.MAX_VALUE not supported");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    long makeValue(long floor, long ceiling, Random random) {
        return PrimitiveGeneratorFunctions.generateLong(random, floor, ceiling);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Class<Long> getColumnType() {
        return Long.class;
    }

    public LongChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return LongChunk.getEmptyChunk();
        }
        toAdd.forAllRowKeys(arg_0 -> ((Long2LongOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
        RowSet.Iterator iterator = toAdd.iterator();
        long firstKey = iterator.nextLong();
        long currentFloor = this.getFloor(firstKey);
        long ceilingKey = this.getCeilingKey(firstKey);
        long currentCeiling = this.getCeilingValue(ceilingKey);
        long[] resultArray = new long[toAdd.intSize()];
        int offset = 0;
        int count = 1;
        if (ceilingKey == Long.MAX_VALUE) {
            count = toAdd.intSize();
        } else {
            while (iterator.hasNext()) {
                long nextKey = iterator.nextLong();
                if (nextKey >= ceilingKey) {
                    this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
                    offset += count;
                    count = 0;
                    firstKey = nextKey;
                    currentFloor = this.getFloor(firstKey);
                    ceilingKey = this.getCeilingKey(firstKey);
                    currentCeiling = this.getCeilingValue(ceilingKey);
                }
                ++count;
            }
        }
        this.generateValues(count, currentFloor, currentCeiling, resultArray, offset, random);
        this.currentRowSet.insert(toAdd);
        MutableInt offset2 = new MutableInt(0);
        toAdd.forAllRowKeys(idx -> this.currentValues.put(idx, resultArray[offset2.getAndIncrement()]));
        return LongChunk.chunkWrap((long[])resultArray);
    }

    private long getCeilingValue(long ceilingKey) {
        return ceilingKey == Long.MAX_VALUE ? this.maxValue : this.currentValues.get(ceilingKey);
    }

    private long getCeilingKey(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey > this.currentRowSet.lastRowKey()) {
            return Long.MAX_VALUE;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return firstKey;
        }
        return this.currentRowSet.get(-position - 1L);
    }

    private long getFloor(long firstKey) {
        if (this.currentRowSet.isEmpty() || firstKey < this.currentRowSet.firstRowKey()) {
            return this.minValue;
        }
        long position = this.currentRowSet.find(firstKey);
        if (position >= 0L) {
            return this.currentValues.get(firstKey);
        }
        long floorKey = this.currentRowSet.get(-position - 2L);
        Assert.assertion((boolean)this.currentValues.containsKey(floorKey), (String)"currentValues.containsKey(floorKey)");
        return this.currentValues.get(floorKey);
    }

    private void generateValues(int count, long floor, long ceiling, long[] result, int offset, Random random) {
        long[] values = new long[count];
        for (int ii = 0; ii < count; ++ii) {
            values[ii] = this.makeValue(floor, ceiling, random);
        }
        Arrays.sort(values);
        if (offset > 0) {
            Assert.geq((long)values[0], (String)"values[0]", (long)result[offset - 1], (String)"result[offset - 1]");
        }
        System.arraycopy(values, 0, result, offset, values.length);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        toRemove.forAllRowKeys(arg_0 -> ((Long2LongOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        try (WritableRowSet shifted = this.currentRowSet.subSetByKeyRange(start, end);){
            if (delta < 0L) {
                shifted.forAllRowKeys(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            } else {
                shifted.reverseIterator().forEachRemaining(kk -> this.currentValues.put(kk + delta, this.currentValues.remove(kk)));
            }
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)shifted);
        }
    }

    private void checkSorted() {
        Assert.eq((long)this.currentRowSet.size(), (String)"currentRowSet.size()", (long)this.currentValues.size(), (String)"currentValues.size()");
        MutableLong lastValue = new MutableLong(Long.MIN_VALUE);
        this.currentRowSet.forAllRowKeys(idx -> {
            long value = this.currentValues.get(idx);
            Assert.leq((long)lastValue.longValue(), (String)"lastValue", (long)value, (String)"value");
            lastValue.setValue(value);
        });
    }
}

