/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class StringArrayGenerator
extends AbstractGenerator<String[]> {
    private final int minSize;
    private final int maxSize;

    public StringArrayGenerator(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    String[] nextValue(Random random) {
        int size = random.nextInt(this.maxSize - this.minSize) + this.minSize;
        String[] arr = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            arr[ii] = Long.toString(random.nextLong(), 35);
        }
        return arr;
    }
}

