/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractGenerator;
import java.util.Random;

public class StringGenerator
extends AbstractGenerator<String> {
    private final int bound;
    private final double nullFrac;

    public StringGenerator() {
        this(0);
    }

    public StringGenerator(int bound) {
        this(bound, 0.0);
    }

    public StringGenerator(int bound, double nullFrac) {
        this.bound = bound;
        this.nullFrac = nullFrac;
    }

    @Override
    public String nextValue(Random random) {
        if (this.nullFrac > 0.0 && random.nextDouble() < this.nullFrac) {
            return null;
        }
        long value = this.bound > 0 ? (long)random.nextInt(this.bound) : random.nextLong();
        return Long.toString(value, 35);
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }
}

